// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator

@ccclass
export default class VideoPlus extends cc.VideoPlayer {
  @property(cc.Asset)
  _source: cc.Asset = null
  // LIFE-CYCLE CALLBACKS:

  // onLoad () {}

  start() {
    if (this._source) this.source = this._source
    this.play()
  }

  @property(cc.Asset)
  @property({ tooltip: '本地视频剪辑' })
  get source() {
    return this._source
  }
  set source(val) {
    if (this._source !== val) {
      this._source = val
      this['_clip'] = val as any
      //   this['_updateVideoSource']()
      console.log('VideoPlus: source changed', this)
    }
  }

  // update (dt) {}
}
