// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import { ITicker } from "./ITicker";
import { TickManager } from "./TickManager";
import { TickManagerComponent } from "./TickManagerComponent";
const {ccclass, property} = cc._decorator;

@ccclass
export default class Main extends cc.Component implements ITicker{

    @property(cc.Node)
    stage: cc.Node = null;

    
    @property(cc.Camera)
    camera: cc.Camera = null;


    @property(cc.Node)
    ani: cc.Node = null;
   
    private tickManager:TickManager|TickManagerComponent;

    start () {
        //开启物理
        cc.director.getPhysics3DManager().enabled=true;


        //使用节点组件的方式
        // let tickNode:cc.Node=new cc.Node("TickManager");
        // this.node.addChild(tickNode);
        // this.tickManager=tickNode.addComponent(TickManagerComponent);
        // this.tickManager.addTicker(this);

        //使用director.getScheduler方式
        this.tickManager=new TickManager();
        this.tickManager.addTicker(this);

        
        //点击时打印点击到的节点名称
        let canvas=cc.find("Canvas");
        canvas.on(cc.Node.EventType.TOUCH_START,this.touchHandler,this);
    }

    private touchHandler(e:cc.Event.EventTouch):void{
        // cc.log(e);
        let cocosPos: cc.Vec2 = e.getLocation();

        let camera: cc.Camera = this.camera;
        let ray = camera.getRay(cocosPos);
        let maxDistance = 3000;
        let rayColliderGroupName = "3D";
        const result: cc.PhysicsRayResult = cc.director.getPhysics3DManager().raycastClosest(ray, rayColliderGroupName, maxDistance, true);
        if (result) {
            console.log(result.collider.node.name);
        }
    }

    tick(dt:number):void{
        this.ani.setPosition(this.ani.position.x+0.1,this.ani.position.y,this.ani.position.z);
    }
}
