import { ITicker } from "./ITicker";

const {ccclass, property} = cc._decorator;

@ccclass
export class TickManagerComponent extends cc.Component{

    private __tickerList: Array<ITicker>=[];

    
    
    update(dt: number): void {
        for (let index = 0; index < this.__tickerList.length; index++) {
            const element = this.__tickerList[index];
            element.tick(dt);
        }
    }

    addTicker(value: ITicker): void {
        let index: number = this.__tickerList.indexOf(value);
        if (index >= 0) {
            throw new Error("Ticker 重复添加！");
        }
        this.__tickerList.push(value);
    }

    removeTicker(value: ITicker): void {
        let index: number = this.__tickerList.indexOf(value);
        if (index < 0) {
            throw new Error("找不到要删除的Tick！");
        }
        this.__tickerList.splice(index, 1);
    }
}
