"use strict";
cc._RF.push(module, '45f8c93Ou5PdpwLpZ96CSqz', 'Main');
// resources/Main.ts

"use strict";
// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var TickManager_1 = require("./TickManager");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Main = /** @class */ (function (_super) {
    __extends(Main, _super);
    function Main() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.stage = null;
        _this.camera = null;
        _this.ani = null;
        return _this;
    }
    Main.prototype.start = function () {
        //开启物理
        cc.director.getPhysics3DManager().enabled = true;
        //使用节点组件的方式
        // let tickNode:cc.Node=new cc.Node("TickManager");
        // this.node.addChild(tickNode);
        // this.tickManager=tickNode.addComponent(TickManagerComponent);
        // this.tickManager.addTicker(this);
        //使用director.getScheduler方式
        this.tickManager = new TickManager_1.TickManager();
        this.tickManager.addTicker(this);
        //点击时打印点击到的节点名称
        var canvas = cc.find("Canvas");
        canvas.on(cc.Node.EventType.TOUCH_START, this.touchHandler, this);
    };
    Main.prototype.touchHandler = function (e) {
        // cc.log(e);
        var cocosPos = e.getLocation();
        var camera = this.camera;
        var ray = camera.getRay(cocosPos);
        var maxDistance = 3000;
        var rayColliderGroupName = "3D";
        var result = cc.director.getPhysics3DManager().raycastClosest(ray, rayColliderGroupName, maxDistance, true);
        if (result) {
            console.log(result.collider.node.name);
        }
    };
    Main.prototype.tick = function (dt) {
        this.ani.setPosition(this.ani.position.x + 0.1, this.ani.position.y, this.ani.position.z);
    };
    __decorate([
        property(cc.Node)
    ], Main.prototype, "stage", void 0);
    __decorate([
        property(cc.Camera)
    ], Main.prototype, "camera", void 0);
    __decorate([
        property(cc.Node)
    ], Main.prototype, "ani", void 0);
    Main = __decorate([
        ccclass
    ], Main);
    return Main;
}(cc.Component));
exports.default = Main;

cc._RF.pop();