"use strict";
cc._RF.push(module, 'be5ca0dqPpIAq1zHPLT9hHn', 'TickManager');
// resources/TickManager.ts

"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TickManager = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var TickManager = /** @class */ (function () {
    function TickManager() {
        this.__tickerList = [];
        cc.director.getScheduler().enableForTarget(this);
        cc.director.getScheduler().scheduleUpdate(this, 0, false);
    }
    TickManager.prototype.update = function (dt) {
        for (var index = 0; index < this.__tickerList.length; index++) {
            var element = this.__tickerList[index];
            element.tick(dt);
        }
    };
    TickManager.prototype.addTicker = function (value) {
        var index = this.__tickerList.indexOf(value);
        if (index >= 0) {
            throw new Error("Ticker 重复添加！");
        }
        this.__tickerList.push(value);
    };
    TickManager.prototype.removeTicker = function (value) {
        var index = this.__tickerList.indexOf(value);
        if (index < 0) {
            throw new Error("找不到要删除的Tick！");
        }
        this.__tickerList.splice(index, 1);
    };
    TickManager = __decorate([
        ccclass
    ], TickManager);
    return TickManager;
}());
exports.TickManager = TickManager;

cc._RF.pop();