
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/util/AStar.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '05f35CaCepNEpykvXMMJg4o', 'AStar');
// script/util/AStar.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Point = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Point = /** @class */ (function () {
    function Point(x, y) {
        this.G = 0; //G = 从起点A，沿着产生的路径，移动到网格上指定方格的移动耗费。
        this.H = 0; //H = 从网格上那个方格移动到终点B的预估移动耗费
        this.F = 0; //F = G + H
        this.father = null; //这个点的上一个点，通过回溯可以找到起点 
        this.is_close = false; //是否关闭搜索
        this.x = x;
        this.y = y;
    }
    return Point;
}());
exports.Point = Point;
var AStar = /** @class */ (function (_super) {
    __extends(AStar, _super);
    function AStar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 获取路线 （此寻路不走斜线）  切记 A*并不保证每次都是最短路径，只是效率更高
     */
    AStar.getRoute = function (start, end, map, size) {
        var _this = this;
        //清空上次寻路，并赋值
        this.is_find = false;
        this.arr_open = [];
        this.pppp = null;
        this.start = __assign({}, start);
        this.end = __assign({}, end);
        this.map = new Map();
        map.forEach(function (value, key) {
            _this.map.set(key, __assign({}, value)); //map 里放的是传过来的对象，使用深拷贝
        });
        this.size = size;
        map.get(this.start.x + this.start.y * this.size.width).G = 0;
        //开始寻路
        var route = new Array();
        try {
            this.search(this.start); //内存不够会报错，一般是终点封闭
        }
        catch (error) {
            console.error("位置不对");
            return route;
        }
        if (this.pppp) {
            this.getFather(this.pppp, route);
        }
        return route;
    };
    AStar.search = function (point) {
        var _this = this;
        if (point.x == this.end.x && point.y == this.end.y) {
            this.is_find = true;
            this.pppp = point;
            return;
        }
        var arr = this.getAround(point);
        arr.forEach(function (p) {
            _this.setFather(p, point);
        });
        //arr按照F排序 从小到大
        this.arr_open.sort(this.compare);
        //递归继续找
        this.arr_open.forEach(function (pp, index, arr) {
            if (pp.is_close) { //删除没用的
                arr.splice(index, 1);
            }
            if (!_this.is_find) {
                _this.search(pp);
            }
        });
    };
    /**
     * 获取周围4个点，上下左右
     */
    AStar.getAround = function (point) {
        point.is_close = true;
        var arr = new Array();
        var index;
        var p;
        //上
        if (point.y != 0) { //到顶了，没有上
            index = point.x + (point.y - 1) * this.size.width;
            p = this.map.get(index);
            if (p && !p.is_close) {
                arr.push(this.map.get(index));
                this.arr_open.push(this.map.get(index)); //我也要一份
            }
        }
        //下
        if (point.y + 1 != this.size.height) { //到底了，没有下
            index = point.x + (point.y + 1) * this.size.width;
            p = this.map.get(index);
            if (p && !p.is_close) {
                arr.push(this.map.get(index));
                this.arr_open.push(this.map.get(index));
            }
        }
        //左
        if (point.x != 0) { //同理
            index = point.x - 1 + point.y * this.size.width;
            p = this.map.get(index);
            if (p && !p.is_close) {
                arr.push(this.map.get(index));
                this.arr_open.push(this.map.get(index));
            }
        }
        //右
        if (point.x + 1 != this.size.width) { //同理
            index = point.x + 1 + point.y * this.size.width;
            p = this.map.get(index);
            if (p && !p.is_close) {
                arr.push(this.map.get(index));
                this.arr_open.push(this.map.get(index));
            }
        }
        return arr;
    };
    /**
     * point换父亲,并重新计算G、H、F
     */
    AStar.setFather = function (son, father) {
        if (!son.father || son.father.G > father.G) {
            son.father = father;
            son.G = son.father.G + 1;
            son.H = Math.abs(son.x - this.end.x) + Math.abs(son.y - this.end.y);
            son.F = son.G + son.H;
        }
    };
    /**
     * 比较器
     */
    AStar.compare = function (p1, p2) {
        if (p1.F > p2.F) {
            return 1;
        }
        else {
            return -1;
        }
    };
    /**
     * 递归
     */
    AStar.getFather = function (point, route) {
        var father = point.father;
        if (father) {
            this.getFather(father, route);
        }
        route.push(point);
    };
    AStar.start = null; //起点
    AStar.end = null; //终点
    AStar.map = null; //地图point
    AStar.size = null; //地图尺寸
    AStar.arr_open = []; //开放队列
    AStar.pppp = null; //执行完寻路，它就有值了，除非没找到
    /**
     * 寻路
     */
    AStar.is_find = false; //是否已经找到路线
    AStar = __decorate([
        ccclass
    ], AStar);
    return AStar;
}(cc.Component));
exports.default = AStar;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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