import { _decorator, Component, Node, RenderTexture, view } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Reset')
export class Reset extends Component {
    @property(RenderTexture)
    readonly renderTexture: RenderTexture = null;
    @property
    readonly textureGrade: number = 1;

    start() {
        // this.renderTexture.resize(512, 512);
        const visibleSize = view.getVisibleSize();
        console.log("resetRenderTexture ", visibleSize);
        this.renderTexture.resize(visibleSize.width * this.textureGrade, visibleSize.height * this.textureGrade);
    }

    update(deltaTime: number) {

    }
}

