/*
 * @Author: Mr.Hong
 * @Date: 2022-10-14 16:24:24
 * @File: AddEffect.ts
*/

import { _decorator, Component, Node, CCInteger, Material, Sprite, CCFloat, dragonBones, assetManager, EffectAsset } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('AddEffect')
export class AddEffect extends Component {

    @property(CCFloat)
    darknessValue: number = 0.8

    onLoad() {
        
    }

    start() {
        this.addDarknessEffect()
    }

    addDarknessEffect() {
        let mat = new Material()
        mat.initialize({
            effectName: '../DarkEffect',
            defines: {
                USE_TEXTURE: true,
            }
        })

        let renderer: Sprite = this.getComponent(Sprite)
        renderer.setMaterial(mat, 0)
        renderer.sharedMaterial.setProperty('a_darkness', this.darknessValue)
    }

    setDarknessEffect(darknessValue: number) {
        if (this.darknessValue == darknessValue) {
            return
        }
        this.darknessValue = darknessValue

        let renderer: Sprite = this.getComponent(Sprite)
        renderer.sharedMaterial.setProperty('a_darkness', this.darknessValue)
    }
    
}