
import { _decorator, math, Component, Node, resources, Texture2D, Sprite, SpriteFrame, UITransform } from 'cc';
const { ccclass, property } = _decorator;
 
@ccclass('mainScene')
export class mainScene extends Component {
    
    start () {
        let thisSelf = this;       
              
        let resList: string = "map/test1/texture";        
        resources.load(resList, Texture2D, function(error, asset: Texture2D): void {
            if(!error){
                thisSelf.updateSceneData(asset);
            }
            else console.log(error.message);
        });
        
        /*
        let resList: string = "map/test1/spriteFrame";
        resources.load(resList, SpriteFrame, function(error, asset: SpriteFrame): void {
            if(!error){
                thisSelf.updateScene(asset);
            }
            else console.log(error.message);
        });*/
    }

    private updateScene(background: SpriteFrame): void {        

        let width = background.texture.width;
        let height = background.texture.height;
        this.getComponent(UITransform).setContentSize(new math.Size(width, height));

        let sprite = this.node.getComponent(Sprite);        
        sprite.spriteFrame = background;
    }

    private updateSceneData(background: Texture2D): void {        

        let width = background.width;
        let height = background.height;
        this.getComponent(UITransform).setContentSize(new math.Size(width, height));

        let sprite = this.node.getComponent(Sprite);
        sprite.spriteFrame = new SpriteFrame(); 
        sprite.spriteFrame.texture = background;
    }
}