import { Node } from "cc";

// 定义链表节点类
class ListNode {
	val: Node;
	next: ListNode | null;

	constructor(node: Node) {
		this.val = node;
		this.next = null;
	}
}

// 定义链表类 先进先出 后进后出
export class LinkedList {
	head: ListNode | null;

	constructor() {
		this.head = null;
	}


	//获取一个元素 从头部取元素
	public get(): Node | null {
		if (!this.head) {
			return null
		}
		let popNode: Node = this.head.val
		let nextListNode = this.head.next
		if (nextListNode) {
			this.head = nextListNode
		} else {
			this.head = null
		}
		popNode.active = true
		return popNode
	}

	public put(node: Node) {
		node.active = false
		node.removeFromParent()
		const newListNode = new ListNode(node)
		if (!this.head) {
			this.head = newListNode;
		} else {
			let current = this.head;
			while (current.next) {
				current = current.next;
			}
			current.next = newListNode
		}
	}
}