import { Component, EPhysics2DDrawFlags, Node, PhysicsSystem2D, Prefab, UITransform, Vec3, _decorator, bezier, find, instantiate, misc, resources, tween, v3 } from 'cc';
import { LinkedList } from '../framework/customNodePool';
const { ccclass, property } = _decorator;


/**
 * 鱼群的控制
 * 把范围扩大到1w 然后把每一个鱼的区间全定义出来 13种鱼
 */
@ccclass('FishCtrl')
export class FishCtrl extends Component {

	//左闭右开 小怪60 ;中怪26.4;大怪13.2;boos 0.4
	private fishWeightMap = { //交叉分布1500 660 330
		"S1": [0, 1500],
		"E1": [1500, 1500 + 660],
		"L1": [2160, 2160 + 330],
		"S2": [2490, 3990],
		"E2": [3990, 4650],
		"L2": [4650, 4980],
		"S3": [4980, 6480],
		"E3": [6480, 7140],
		"L3": [7140, 7470],
		"S4": [7470, 8970],
		"E4": [8970, 9630],
		"L4": [9630, 9960],
		"Boss": [9960, 10000],
	};

	private fishRunSpeed: number[] = [null, 100, 150, 200] //鱼的运动速度
	private curFishNodesCount: number = 0
	private screenMaxFish: number = 3 //屏幕上最多50条鱼 超过这个就不生成了
	private bossNode: Prefab
	private fishSList: Prefab[] = []
	private fishEList: Prefab[] = []
	private fishBList: Prefab[] = []

	private fishNodePools: LinkedList[] = [] //长度为13的鱼节点池数组

	private nodeHeight: number = 0
	start() {

		PhysicsSystem2D.instance.debugDrawFlags = EPhysics2DDrawFlags.Aabb |
			EPhysics2DDrawFlags.Pair |
			EPhysics2DDrawFlags.CenterOfMass |
			EPhysics2DDrawFlags.Joint |
			EPhysics2DDrawFlags.Shape;

		this.nodeHeight = this.node.getComponent(UITransform).contentSize.height


		for (let index = 1; index < 5; index++) {
			resources.load("prefab/fish/fishS" + index, Prefab, (err, data) => {
				if (!err) {
					this.fishSList[index] = data
				}
			})
		}

		this.scheduleOnce(() => {
			for (let index2 = 1; index2 < 5; index2++) {
				resources.load("prefab/fish/fishE" + index2, Prefab, (err, data) => {
					if (!err) {
						this.fishEList[index2] = data
					}
				})

			}
		}, 0.1)

		this.scheduleOnce(() => {
			for (let index3 = 1; index3 < 5; index3++) {
				resources.load("prefab/fish/fishB" + index3, Prefab, (err, data) => {
					if (!err) {
						this.fishBList[index3] = data
					}
				})
			}
		}, 0.3)

		this.scheduleOnce(() => {
			resources.load("prefab/fish/fishBoss", Prefab, (err, data) => {
				if (!err) {
					this.bossNode = data
				}
			})
		}, 0.5)

		this.scheduleOnce(this.produceFish, 1)

		console.log(this.node.getComponent(UITransform).getComputeAABB())

		let creatorFish3 = function () {
			if (this.fishBList[3]) {
				let fishB3: Node = instantiate(this.fishBList[3])
				fishB3.setPosition(0, 500, 0)
				this.node.addChild(fishB3)
				tween(fishB3)
					.to(2, { position: v3(0, -600, 0) })
					.removeSelf()
					.start()
				// tween(fishB3)
				// 	.sequence(
				// 		tween(fishB3).to(0.1, { position: v3(0, 400, 0) }),
				// 		tween(fishB3).to(0.2, { position: v3(0, -400, 0) })
				// 	)
				// 	.repeatForever()
				// 	.start()
				setTimeout(creatorFish3, 100)
			}
		}.bind(this)

		this.scheduleOnce(() => {
			// creatorFish3()
		}, 3)

	}

	/**
	 * 使用定时器 用随机间隔去生成鱼
	 * 使用随机间隔去生成鱼 
	 */
	private produceFish() {
		if (this.curFishNodesCount >= this.screenMaxFish) {
			let randomTime = this.getRandomFloatInRange(1, 3)
			this.scheduleOnce(() => {
				this.produceFish()
			}, randomTime)
			return
		}
		let getRandomFish = function (): string {
			const randomValue = this.getRandomInt(0, 10000)
			for (const key in this.fishWeightMap) {
				const [min, max] = this.fishWeightMap[key];
				if (randomValue >= min && randomValue <= max) {
					return key;
				}
			}
			// 默认返回第一个元素（理论上不会到这里，因为总和是准确的）
			return Object.keys(this.fishWeightMap)[0];
		}.bind(this)
		let fishSuffix: string = getRandomFish()
		switch (fishSuffix[0]) {
			case 'S':
				this.produceSmallFish(parseInt(fishSuffix[1]))
				break;
			case 'E':
				this.produceEliteFish(parseInt(fishSuffix[1]))
				break;
			case 'L':
				this.produceBossFish(parseInt(fishSuffix[1]))
				break;
			case 'B':
				this.produceBoss()
				break;
			default:
				break;
		}

		let randomTime = this.getRandomFloatInRange(0.3, 0.5)
		this.scheduleOnce(() => {
			this.produceFish()
		}, randomTime)
	}

	//boss boss存在一条就不要创建了
	private produceBoss() {
		let fishPrefab = this.bossNode
		if (!fishPrefab) {
			return
		}
		let fishNode = this.getFishNode(fishPrefab, 13)
		if (!fishNode) {
			//已经有一条了
			return
		}
		// boss的运动 从上半部分出来 运动到中间 然后回右上部分
		let initPos = v3(-590, this.getRandomInt(0, this.nodeHeight / 2), 0)
		fishNode.setPosition(initPos)
		let endPos = v3(590, this.getRandomInt(0, this.nodeHeight / 2), 0)
		let midPos = v3(0, this.nodeHeight / 4)
		fishNode.angle = this.calculateAngle(midPos, initPos)
		let endAngle = this.calculateAngle(endPos, midPos)
		tween(fishNode)
			.to(3, { position: midPos })
			.delay(3)
			.parallel(tween(fishNode).to(3, { position: endPos }), tween(fishNode).to(1.5, { angle: endAngle }))
			.call(() => {
				this.fishNodePools[13].put(fishNode)
				this.curFishNodesCount--
			})
			.start()
	}

	private produceBossFish(fishIndex: number) {
		let fishPrefab = this.fishBList[fishIndex]
		if (!fishPrefab) {
			return
		}
		let fishPoolIndex = fishIndex + 4 * 2
		let fishNode = this.getFishNode(fishPrefab, fishPoolIndex) as Node
		if (Math.random() > 0.5) {//走贝塞尔
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[3], true)
		} else {
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[3], false)
		}
	}

	private produceEliteFish(fishIndex: number) {
		let fishPrefab = this.fishEList[fishIndex]
		if (!fishPrefab) {
			return
		}
		let fishPoolIndex = fishIndex + 4
		let fishNode = this.getFishNode(fishPrefab, fishPoolIndex) as Node
		if (Math.random() > 0.5) {//走贝塞尔
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[2], true)
		} else {
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[2], false)
		}
	}

	//开始制作小鱼 使用uuid生成唯一id 小鱼可以走鱼群 和走贝塞尔运动
	private produceSmallFish(fishIndex: number) {
		let fishPrefab = this.fishSList[fishIndex]
		if (!fishPrefab) {
			return
		}
		let fishPoolIndex = fishIndex
		let fishNode = this.getFishNode(fishPrefab, fishPoolIndex) as Node
		if (Math.random() > 0.5) {//走贝塞尔
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[1], true)
		} else {
			this.fishRun(fishNode, fishPoolIndex, this.fishRunSpeed[1], false)
		}
	}

	//获取一条鱼
	private getFishNode(fishPrefab: Prefab, index: number) {
		let linkedList = this.fishNodePools[index]
		let newNode: Node
		if (!linkedList) {
			newNode = instantiate(fishPrefab)
			this.fishNodePools[index] = new LinkedList()
		} else {
			newNode = linkedList.get()
			if (!newNode) {
				if (index == 13) {
					return false
				}
				newNode = instantiate(fishPrefab)
			}
		}
		this.node.addChild(newNode)
		find("Label", newNode).active = false
		this.curFishNodesCount++
		return newNode
	}

	private fishRun(fishNode: Node, fishPoolIndex: number, runSpeed: number, isBezierRun: boolean) {
		let isUp = Math.random() > 0.5 //在上部分
		let initY: number = 0
		if (isUp) {
			initY = this.getRandomInt(0, this.nodeHeight / 2)
		} else {
			initY = this.getRandomInt(-this.nodeHeight / 2, 0)
		}

		let initPos = v3(-590, initY, 0)
		fishNode.setPosition(initPos)

		let endY: number = 0
		if (isUp) {
			endY = this.getRandomInt(-this.nodeHeight / 2, 0)
		} else {
			endY = this.getRandomInt(0, this.nodeHeight / 2)
		}
		let endPos = v3(590, endY, 0)

		fishNode.angle = this.calculateAngle(initPos, endPos)
		let runTime = (endPos.clone().subtract(initPos)).length() / runSpeed

		if (isBezierRun) {
			let startPos: Vec3, endPos2: Vec3, controlPos1: Vec3, controlPos2: Vec3, runNode: Node, runTime2: number, updateCallF: Function, onCompleteCallF: Function
			startPos = initPos
			endPos2 = endPos
			controlPos1 = v3(this.getRandomInt(-390, 0), this.getRandomInt(-this.nodeHeight / 3, this.nodeHeight / 3), 0)
			controlPos2 = v3(this.getRandomInt(0, 390), this.getRandomInt(-this.nodeHeight / 3, this.nodeHeight / 3), 0)
			runNode = fishNode
			runTime2 = runTime
			let oldPos: Vec3 = startPos
			updateCallF = function (tempVec3: Vec3, ratio: number, target: Node) {
				target.angle = this.calculateAngle(tempVec3, oldPos)
				oldPos = tempVec3.clone()
			}.bind(this)
			onCompleteCallF = function (target: Node) {
				this.fishNodePools[fishPoolIndex].put(fishNode)
				this.curFishNodesCount--
			}.bind(this)
			this.easyBezierRun(startPos, endPos2, controlPos1, controlPos2, runNode, runTime2, updateCallF, onCompleteCallF)
		} else {
			tween(fishNode)
				.to(runTime, { position: endPos })
				.call(() => {
					this.fishNodePools[fishPoolIndex].put(fishNode)
					this.curFishNodesCount--
				})
				.start()
		}
	}

	/**
	 * 给定两个点 算出一个角度 boss的不处理 只处理12条鱼
	 */
	private calculateAngle(newPos: Vec3, oldPos: Vec3): number {
		let tanA = (newPos.y - oldPos.y) / (newPos.x - oldPos.x)
		let angle = misc.radiansToDegrees(tanA)
		return angle
	}

	/**
	* 获取 [m,n]之间的随机浮点数
	* @param min 
	* @param max 
	*/
	public getRandomFloatInRange(min: number, max: number) {
		let newMax = max + 0.002
		const rr = Math.random() * (newMax - min) + min
		return Math.min(rr, max)
	}

	public getRandomInt(min: number, max: number) {
		const r = Math.random();
		const rr = r * (max - min + 1) + min;
		return Math.floor(rr);
	}

	/**
	 * 一个简单的贝塞尔曲线的运动
	 */
	public easyBezierRun(startPos: Vec3, endPos: Vec3, controlPos1: Vec3, controlPos2: Vec3, runNode: Node, runTime: number, updateCallF: Function, onCompleteCallF: Function) {
		// 三维空间的缓动
		const bezierCurve = (t: number, p1: Vec3, cp1: Vec3, cp2: Vec3, p2: Vec3, out: Vec3) => {
			out.x = bezier(p1.x, cp1.x, cp2.x, p2.x, t);
			out.y = bezier(p1.y, cp1.y, cp2.y, p2.y, t);
			out.z = bezier(p1.z, cp1.z, cp2.z, p2.z, t);
		}
		const tempVec3 = v3();
		tween(runNode)
			.to(runTime, { position: endPos }, { //其实这里是在onUpdate里面去重新设置了节点的坐标
				onUpdate: (target, ratio) => {
					bezierCurve(ratio, startPos, controlPos1, controlPos2, endPos, tempVec3);
					runNode.setPosition(tempVec3)
					updateCallF(tempVec3, ratio, target)
				},
				onStart(target) {

				},
				onComplete(target) {
					onCompleteCallF(target)
				},
			})
			.start();
	}


}

