﻿
let hasInjectCustomJs = false;

// 注意，必须设置了run_at=document_start 此段代码才会生效
document.addEventListener('DOMContentLoaded', function () {

});

chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
	if (request.action == "startParseUI") {
		if (!hasInjectCustomJs) {
			injectCustomJs(() => {
				hasInjectCustomJs = true;
				window.postMessage({ action: 'startParseUI', domName: request.domName }, '*');
			});
		} else {
			window.postMessage({ action: 'startParseUI', domName: request.domName }, '*');
		}
	}
});

// 向页面注入JS
function injectCustomJs(callback) {
	jsPath = 'js/inject.js';
	var temp = document.createElement('script');
	temp.setAttribute('type', 'text/javascript');
	// 获得的地址类似：chrome-extension://ihcokhadfjfchaeagdoclpnjdiokfakg/js/inject.js
	temp.src = chrome.extension.getURL(jsPath);
	temp.onload = function () {
		// 放在页面不好看，执行完后移除掉
		this.parentNode.removeChild(this);
		if (callback) {
			callback();
		}
	};
	document.body.appendChild(temp);
}