// 获取当前选项卡ID
function getCurrentTabId(callback)
{
	chrome.tabs.query({active: true, currentWindow: true}, function(tabs)
	{
		if(callback) callback(tabs.length ? tabs[0].id: null);
	});
}

// 向content-script主动发送消息
function sendMessageToContentScript(message, callback)
{
	getCurrentTabId((tabId) =>
	{
		chrome.tabs.sendMessage(tabId, message, function(response)
		{
			if(callback) callback(response);
		});
	});
}

window.onload = function () {
    console.log("onload");
    document.getElementById("btnStart").addEventListener('click', function () {
        console.log("click start");
        // chrome.runtime.sendMessage({ action: 'startParseUI' });
		let domName = document.getElementById("dom").value;
        sendMessageToContentScript({ action: 'startParseUI', domName: domName }, (response) => {
            if(response) alert('收到来自content-script的回复：'+response);
        });
    })
}