const {ccclass, property} = cc._decorator;

const PI = 3.141592653579;

@ccclass
export default class TestGraphics extends cc.Component {

    private gfx: cc.Graphics;
    private speed: number = 0.1;    // 画线速度
    private percent: number = 0;
    private action: boolean = false;
    private rspeed: number = 10;    // 旋转速度
    onLoad () {
        this.gfx = this.node.getComponent(cc.Graphics);
        if (!this.gfx) {
            this.gfx = this.node.addComponent(cc.Graphics);
            this.gfx.lineWidth = 3;
            this.gfx.strokeColor = cc.Color.BLACK;
        }
    }

    start () {
        this.percent = 0;
    }

    drawGraphics (percent: number) {
        this.percent += percent;
        this.gfx.clear();
        // 分为四部分
        switch (true) {
            case this.percent >= 1:
                // 填充
                this.gfxFill();
            case this.percent > 0.5:
                // 50%~100%画两个小圆
                this.drawSmallCircle(this.percent - 0.5);
            case this.percent > 0.25:
                // 25%~50%画中间间隔
                this.drawMiddle(this.percent - 0.25);
            case this.percent > 0:
                // 25%画大圆
                this.drawBigCircle(this.percent);
        }
        this.action && (this.percent = -1);
    }

    drawBigCircle (p: number) {
        let percent = Math.min(p * 4, 1);    // 扩充为100%
        let width = this.node.width;
        let radius = width / 2;
        this.gfx.arc(0, 0, radius, PI / 2, PI / 2 + PI * percent, true);
        this.gfx.arc(0, 0, radius, -PI / 2, -PI / 2 + PI * percent, true);
        this.gfx.stroke();
    }

    drawMiddle (p: number) {
        let percent = Math.min(p * 4, 1);
        let width = this.node.width;
        let radius = width / 4;
        this.gfx.arc(0, width / 4, radius, PI / 2, PI / 2 + PI * percent, true);
        this.gfx.arc(0, -width / 4, radius, -PI / 2, -PI / 2 + PI * percent, true);
        this.gfx.stroke();
    }

    drawSmallCircle (p: number) {
        let percent = Math.min(p * 2, 1);
        let width = this.node.width;
        let radius = width / 8;
        this.gfx.arc(0, width / 4, radius, -PI/2, -PI/2 + 2 * PI * percent, true);
        this.gfx.arc(0, -width / 4, radius, PI/2, PI/2 + 2 * PI * percent, true);
        this.gfx.stroke();
    }

    gfxFill () {
        let width = this.node.width;
        this.gfx.arc(0, 0, width/2, PI/2, 3*PI/2, true);
        this.gfx.fillColor = cc.Color.BLACK;
        this.gfx.fill();
        this.gfx.arc(0, 0, width/2, PI/2, 3*PI/2, false);
        this.gfx.fillColor = cc.Color.WHITE;
        this.gfx.fill();

        this.gfx.arc(0, -width/4, width/4, PI/2, 3*PI/2, false);
        this.gfx.fillColor = cc.Color.BLACK;
        this.gfx.fill();
        this.gfx.arc(0, width/4, width/4, PI/2, 3*PI/2, true);
        this.gfx.fillColor = cc.Color.WHITE;
        this.gfx.fill();

        this.gfx.arc(0, width/4, width/8, 0, 2*PI, true);
        this.gfx.fillColor = cc.Color.BLACK;
        this.gfx.fill();
        this.gfx.arc(0, -width/4, width/8, 0, 2*PI, true);
        this.gfx.fillColor = cc.Color.WHITE;
        this.gfx.fill();
        this.action = true;
    }

    update (dt) {
        if (this.percent >= 0) {
            this.drawGraphics(this.speed * dt);
        }
        this.action && (this.node.angle += this.rspeed * dt, this.node.angle %= 360);
    }
}
