"use strict";

// src/Compact.ts
var typeCodes = {};
var typeArr = [0, "bool", "int", "float", "string", "arr", "dict", 7];
var typesBuffer = new Uint8Array(1024 * 2);
var bytes = new Uint8Array(1024 * 1024 * 4);
var offset;
var strIndices = {};
var strIndex;
var strs = [];
var counts = {};
var cs = [];
var codesByPart = {};
var partsByCode = [];
var codes = [];
var sb = [];
var uis = new Uint32Array(10);
var rootField;
var currField;
var Compact_default = new class {
  types = [];
  end = void 0;
  constructor() {
    let i2 = -1;
    for (const type of typeArr) {
      typeCodes[type] = ++i2;
    }
  }
  autoAddTypes(value) {
    if (value) {
      switch (typeof value) {
        case "boolean":
          this.types.push("bool");
          break;
        case "number":
          this.types.push("int");
          break;
        case "string":
          this.types.push("string");
          break;
        default:
          if (Array.isArray(value)) {
            this.types.push("arr");
            this.autoAddTypes(value[0]);
            this.types.push(0);
          } else {
            this.types.push("dict");
            for (const key in value) {
              this.types.push(key);
              this.autoAddTypes(value[key]);
            }
            this.types.push(0);
          }
          break;
      }
    } else {
      switch (value) {
        case false:
          this.types.push("bool");
          break;
        case 0:
          this.types.push("int");
          break;
        default:
          this.types.push("string");
          break;
      }
    }
  }
  \u628A\u7EBF\u6027\u7684types\u6574\u7406\u6210\u6811\u72B6() {
    rootField = { name: void 0, type: this.types[0], subs: void 0 };
    let curr;
    let field = void 0;
    const stack = [];
    curr = rootField;
    switch (curr.type) {
      case "arr":
      case "dict":
        stack.push(curr);
        curr.subs = [];
        break;
    }
    let offset2 = 0;
    while (++offset2 < this.types.length) {
      const type = this.types[offset2];
      switch (type) {
        case 0:
          curr = stack.pop();
          field = void 0;
          break;
        case "bool":
        case "int":
        case "float":
        case "string":
        case "arr":
        case "dict":
          if (curr.type == "arr") {
            curr.subs.push(field = { type, name: void 0, subs: void 0 });
          } else {
            field.type = type;
          }
          switch (type) {
            case "arr":
            case "dict":
              stack.push(curr);
              curr = field;
              curr.subs = [];
              break;
          }
          field = void 0;
          break;
        default:
          curr.subs.push(field = { type: void 0, name: type, subs: void 0 });
          break;
      }
    }
    stack.length = 0;
  }
  outputFields() {
    sb.length = 0;
    this._outputField(rootField, "");
    return sb.join("");
  }
  _outputField(field, tab) {
    sb.push("\n");
    sb.push(tab);
    if (field.name) {
      sb.push(field.name);
      sb.push(": ");
    }
    sb.push(field.type);
    if (field.subs) {
      tab += "  ";
      for (const sub of field.subs) {
        this._outputField(sub, tab);
      }
    }
  }
  clearObj(obj) {
    for (const key in obj) {
      delete obj[key];
    }
  }
  encode(data, _types) {
    this.clearObj(strIndices);
    strs.length = strIndex = 0;
    strs[0] = "";
    this.types.length = 0;
    if (_types) {
      this.types.push.apply(this.types, _types);
    } else {
      this.autoAddTypes(data);
    }
    this.types.push(7);
    const dataOffset = offset = bytes.length >> 1;
    let typesSize = 0;
    let shift = 0;
    let u16 = 0;
    for (const type of this.types) {
      const code = typeCodes[type];
      if (code > -1) {
        u16 |= code << shift;
        if ((shift += 3) < 8) {
        } else {
          typesBuffer[typesSize++] = u16;
          shift -= 8;
          u16 >>= 8;
        }
      } else {
        this.writeIndexStr(type);
      }
    }
    if (u16) {
      typesBuffer[typesSize++] = u16;
    }
    this.types.pop();
    typesSize > typesBuffer.length >> 1 && console.error("\u8981\u8D85\u62C9\uFF01" + typesSize);
    this.\u628A\u7EBF\u6027\u7684types\u6574\u7406\u6210\u6811\u72B6();
    currField = rootField;
    this.writeValue(data);
    offset > (bytes.length >> 2) * 3 && console.error("\u8981\u8D85\u62C9\uFF01" + offset);
    const dataBuffer = bytes.subarray(dataOffset, offset);
    offset = 0;
    if (strIndex) {
      strs.shift();
      const allStr = strs.join("");
      this.clearObj(counts);
      cs.length = 0;
      let index = 0;
      const len = allStr.length;
      let i2 = -1;
      while (++i2 < len) {
        const c = allStr[i2];
        if (counts[c]) {
          counts[c]++;
        } else {
          counts[c] = 1;
          cs[index++] = c;
        }
      }
      cs.sort((c1, c2) => {
        const d = counts[c2] - counts[c1];
        if (d) return d;
        return c1 < c2 ? -1 : 1;
      });
      this.clearObj(codesByPart);
      let code = 0;
      for (const c of cs) {
        codesByPart[c] = code++;
      }
      let prevPart = void 0;
      codes.length = 0;
      index = 0;
      while (offset < len) {
        let part = allStr[offset];
        i2 = 1;
        while (offset + i2 < len) {
          const nextPart = part + allStr[offset + i2];
          if (codesByPart[nextPart] > -1) {
            part = nextPart;
            i2++;
          } else {
            break;
          }
        }
        codes[index++] = codesByPart[part];
        offset += i2;
        if (prevPart) {
          prevPart += part[0];
          codesByPart[prevPart] > -1 || (codesByPart[prevPart] = code++);
        }
        prevPart = part;
      }
      offset = 0;
      this.writeUint(cs.length);
      for (const c of cs) {
        this.writeC(c.charCodeAt(0));
      }
      this.writeUint(codes.length);
      for (const _code of codes) {
        this.writeUint(_code);
      }
      this.writeUint(strIndex);
      for (const str of strs) {
        this.writeUint(str.length);
      }
    } else {
      this.writeByte(0);
    }
    bytes.set(typesBuffer.subarray(0, typesSize), offset);
    bytes.set(dataBuffer, offset + typesSize);
    this.end = offset + typesSize + dataBuffer.length;
    return bytes.subarray(0, this.end);
  }
  writeValue(value) {
    switch (currField.type) {
      case "bool":
        this.writeBool(value);
        break;
      case "int":
        this.writeInt(value);
        break;
      case "float":
        this.writeFloat(value, 6);
        break;
      case "string":
        this.writeIndexStr(value);
        break;
      case "arr":
        this.writeArr(value);
        break;
      case "dict":
        this.writeDict(value);
        break;
    }
  }
  writeArr(arr) {
    if (arr) {
      this.writeUint(arr.length + 1);
      const arrField = currField;
      let fieldIndex = -1;
      for (const value of arr) {
        ++fieldIndex < arrField.subs.length || (fieldIndex = 0);
        currField = arrField.subs[fieldIndex];
        this.writeValue(value);
      }
      currField = arrField;
    } else {
      this.writeByte(0);
    }
  }
  writeDict(dict) {
    if (dict) {
      this.writeByte(1);
      const dictField = currField;
      for (currField of dictField.subs) {
        this.writeValue(dict[currField.name]);
      }
      currField = dictField;
    } else {
      this.writeByte(0);
    }
  }
  decode(_bytes) {
    bytes.set(_bytes);
    offset = 0;
    let i2 = this.readUint();
    if (i2) {
      this.clearObj(codesByPart);
      partsByCode.length = 0;
      let code = 0;
      while (i2--) {
        const c = this.readC();
        codesByPart[c] = code;
        partsByCode[code++] = c;
      }
      sb.length = 0;
      let sbIndex = 0;
      let prevPart = void 0;
      i2 = this.readUint();
      while (i2--) {
        const _code = this.readUint();
        const part = partsByCode[_code];
        sb[sbIndex++] = part;
        if (prevPart) {
          prevPart += part[0];
          if (codesByPart[prevPart]) {
          } else {
            codesByPart[prevPart] = code;
            partsByCode[code++] = prevPart;
          }
        }
        prevPart = part;
      }
      const allStr = sb.join("");
      let strCount = this.readUint();
      strs[0] = "";
      let j = 0;
      i2 = 0;
      while (strCount--) {
        const strLen = this.readUint();
        strs[++j] = allStr.substr(i2, strLen);
        i2 += strLen;
      }
    }
    this.types.length = 0;
    let shift = 0;
    let u16 = bytes[offset++] | bytes[offset++] << 8;
    i2 = -1;
    for (; ; ) {
      const code = u16 >> shift & 7;
      if (code == 7) break;
      this.types[++i2] = typeArr[code];
      if ((shift += 3) < 8) {
      } else {
        u16 = u16 >> 8 | bytes[offset++] << 8;
        shift -= 8;
      }
    }
    shift + 3 > 8 || offset--;
    this.readDictKeys();
    this.\u628A\u7EBF\u6027\u7684types\u6574\u7406\u6210\u6811\u72B6();
    currField = rootField;
    const value = this.readValue();
    this.end = offset;
    return value;
  }
  readDictKeys() {
    const stack = [];
    let curr;
    switch (this.types[0]) {
      case "arr":
      case "dict":
        stack.push(curr = this.types[0]);
        break;
      default:
        curr = void 0;
        break;
    }
    let offset2 = 0;
    while (++offset2 < this.types.length) {
      const type = this.types[offset2];
      switch (type) {
        case 0:
          curr = stack.pop();
          break;
        case "bool":
        case "int":
        case "float":
        case "string":
        case "arr":
        case "dict":
          if (curr == "dict") {
            this.types.splice(offset2++, 0, this.readIndexStr());
          }
          switch (type) {
            case "arr":
            case "dict":
              stack.push(curr);
              curr = type;
              break;
          }
          break;
      }
    }
    stack.length = 0;
  }
  readValue() {
    switch (currField.type) {
      case "bool":
        return this.readBool();
      case "int":
        return this.readInt();
      case "float":
        return this.readFloat();
      case "string":
        return this.readIndexStr();
      case "arr":
        return this.readArr();
      case "dict":
        return this.readDict();
    }
  }
  readArr() {
    let count = this.readUint();
    if (count > 1e6) {
      throw new Error("count=" + count);
    }
    if (count) {
      const arr = [];
      if (--count) {
        const arrField = currField;
        let fieldIndex = -1;
        for (let i2 = 0; i2 < count; i2++) {
          ++fieldIndex < arrField.subs.length || (fieldIndex = 0);
          currField = arrField.subs[fieldIndex];
          arr[i2] = this.readValue();
        }
        currField = arrField;
      }
      return arr;
    }
    return void 0;
  }
  readDict() {
    if (this.readByte()) {
      const dict = {};
      const dictField = currField;
      for (currField of dictField.subs) {
        dict[currField.name] = this.readValue();
      }
      currField = dictField;
      return dict;
    }
    return void 0;
  }
  writeBool(flag) {
    bytes[offset++] = flag ? 1 : 0;
  }
  readBool() {
    return bytes[offset++] > 0;
  }
  writeByte(num) {
    bytes[offset++] = num;
  }
  readByte() {
    return bytes[offset++];
  }
  writeUint(num) {
    if (num < 128) {
      bytes[offset++] = num;
    } else if (num < 16384) {
      bytes[offset++] = 128 | num >> 7;
      bytes[offset++] = num & 127;
    } else if (num < 2097152) {
      bytes[offset++] = 128 | num >> 14;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    } else if (num < 268435456) {
      bytes[offset++] = 128 | num >> 21;
      bytes[offset++] = 128 | num >> 14 & 127;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    } else {
      bytes[offset++] = 128 | num >> 28;
      bytes[offset++] = 128 | num >> 21 & 127;
      bytes[offset++] = 128 | num >> 14 & 127;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    }
  }
  readUint() {
    const byte1 = bytes[offset++];
    if (byte1 & 128) {
      const byte2 = bytes[offset++];
      if (byte2 & 128) {
        const byte3 = bytes[offset++];
        if (byte3 & 128) {
          const byte4 = bytes[offset++];
          if (byte4 & 128) {
            const byte5 = bytes[offset++];
            return (byte1 & 127) << 28 | (byte2 & 127) << 21 | (byte3 & 127) << 14 | (byte4 & 127) << 7 | byte5;
          } else {
            return (byte1 & 127) << 21 | (byte2 & 127) << 14 | (byte3 & 127) << 7 | byte4;
          }
        } else {
          return (byte1 & 127) << 14 | (byte2 & 127) << 7 | byte3;
        }
      } else {
        return (byte1 & 127) << 7 | byte2;
      }
    } else {
      return byte1;
    }
  }
  writeInt(num) {
    let sign;
    if (num < 0) {
      sign = 128;
      num = -num;
    } else {
      sign = 0;
    }
    if (num < 64) {
      bytes[offset++] = sign | num;
    } else if (num < 8192) {
      bytes[offset++] = sign | 64 | num >> 7;
      bytes[offset++] = num & 127;
    } else if (num < 1048576) {
      bytes[offset++] = sign | 64 | num >> 14;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    } else if (num < 134217728) {
      bytes[offset++] = sign | 64 | num >> 21;
      bytes[offset++] = 128 | num >> 14 & 127;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    } else {
      bytes[offset++] = sign | 64 | num >> 28;
      bytes[offset++] = 128 | num >> 21 & 127;
      bytes[offset++] = 128 | num >> 14 & 127;
      bytes[offset++] = 128 | num >> 7 & 127;
      bytes[offset++] = num & 127;
    }
  }
  readInt() {
    let num;
    const byte1 = bytes[offset++];
    if (byte1 & 64) {
      const byte2 = bytes[offset++];
      if (byte2 & 128) {
        const byte3 = bytes[offset++];
        if (byte3 & 128) {
          const byte4 = bytes[offset++];
          if (byte4 & 128) {
            const byte5 = bytes[offset++];
            num = (byte1 & 63) << 28 | (byte2 & 127) << 21 | (byte3 & 127) << 14 | (byte4 & 127) << 7 | byte5;
          } else {
            num = (byte1 & 63) << 21 | (byte2 & 127) << 14 | (byte3 & 127) << 7 | byte4;
          }
        } else {
          num = (byte1 & 63) << 14 | (byte2 & 127) << 7 | byte3;
        }
      } else {
        num = (byte1 & 63) << 7 | byte2;
      }
    } else {
      num = byte1 & 63;
    }
    return byte1 & 128 ? -num : num;
  }
  writeFloat(num, pow) {
    let sign;
    if (num < 0) {
      sign = 128;
      num = -num;
    } else {
      sign = 0;
    }
    uis[0] = num;
    const d = num - uis[0];
    if (d > 1e-7) {
      if (uis[0]) {
        pow -= Math.ceil(Math.log10(uis[0]));
      }
      uis[1] = Math.pow(10, pow);
      uis[2] = Math.round(d * uis[1]);
      while (pow) {
        uis[3] = uis[2] / 10;
        uis[3] *= 10;
        if (uis[2] == uis[3]) {
          uis[1] /= 10;
          uis[2] /= 10;
          pow--;
        } else {
          break;
        }
      }
      uis[0] = uis[0] * uis[1] + uis[2];
      pow <<= 4;
    } else {
      pow = 0;
    }
    const _int = uis[0];
    if (_int < 8) {
      bytes[offset++] = sign | pow | _int;
    } else if (_int < 1024) {
      bytes[offset++] = sign | pow | 8 | _int >> 7;
      bytes[offset++] = _int & 127;
    } else if (_int < 131072) {
      bytes[offset++] = sign | pow | 8 | _int >> 14;
      bytes[offset++] = 128 | _int >> 7 & 127;
      bytes[offset++] = _int & 127;
    } else if (_int < 16777216) {
      bytes[offset++] = sign | pow | 8 | _int >> 21;
      bytes[offset++] = 128 | _int >> 14 & 127;
      bytes[offset++] = 128 | _int >> 7 & 127;
      bytes[offset++] = _int & 127;
    } else {
      bytes[offset++] = sign | pow | 8 | _int >> 28;
      bytes[offset++] = 128 | _int >> 21 & 127;
      bytes[offset++] = 128 | _int >> 14 & 127;
      bytes[offset++] = 128 | _int >> 7 & 127;
      bytes[offset++] = _int & 127;
    }
  }
  readFloat() {
    let num;
    const byte1 = bytes[offset++];
    if (byte1 & 8) {
      const byte2 = bytes[offset++];
      if (byte2 & 128) {
        const byte3 = bytes[offset++];
        if (byte3 & 128) {
          const byte4 = bytes[offset++];
          if (byte4 & 128) {
            const byte5 = bytes[offset++];
            num = (byte1 & 7) << 28 | (byte2 & 127) << 21 | (byte3 & 127) << 14 | (byte4 & 127) << 7 | byte5;
          } else {
            num = (byte1 & 7) << 21 | (byte2 & 127) << 14 | (byte3 & 127) << 7 | byte4;
          }
        } else {
          num = (byte1 & 7) << 14 | (byte2 & 127) << 7 | byte3;
        }
      } else {
        num = (byte1 & 7) << 7 | byte2;
      }
    } else {
      num = byte1 & 7;
    }
    let pow = byte1 >> 4 & 7;
    let _10s = 1;
    while (pow--) {
      _10s *= 10;
    }
    num /= _10s;
    return byte1 & 128 ? -num : num;
  }
  writeC(c) {
    if (c < 128) {
      bytes[offset++] = c;
    } else if (c < 16384) {
      bytes[offset++] = 128 | c & 127;
      bytes[offset++] = c >> 7;
    } else {
      bytes[offset++] = 128 | c & 127;
      bytes[offset++] = 128 | c >> 7 & 127;
      bytes[offset++] = c >> 14;
    }
  }
  readC() {
    const code1 = bytes[offset++];
    if (code1 < 128) {
      return String.fromCharCode(code1);
    }
    const code2 = bytes[offset++];
    if (code2 < 128) {
      return String.fromCharCode(code2 << 7 | code1 & 127);
    }
    const code3 = bytes[offset++];
    return String.fromCharCode(code3 << 14 | (code2 & 127) << 7 | code1 & 127);
  }
  // private writeStr(str: string): void {
  //     if (str) {
  //         const len = str.length;
  //         for (let i: number = 0; i < len; i++) {
  //             this.writeC(str.charCodeAt(i));
  //         }
  //     }
  // }
  // private readStr(size: number): string {
  //     size += offset;
  //     sb.length = 0;
  //     let sbIndex: number = 0;
  //     while (offset < size) {
  //         sb[sbIndex++] = this.readC();
  //     }
  //     return sb.join("");
  // }
  // private writeSizeStr(str: string): void {
  //     offset += 4;//先占4位
  //     const oldOffset = offset;
  //     this.writeStr(str);
  //     let size: number = offset - oldOffset;
  //     offset = oldOffset - 4;
  //     this.writeUint(size);
  //     const _offset = oldOffset - offset;
  //     if (_offset > 0) {
  //         while (size--) {
  //             bytes[offset] = bytes[offset + _offset];
  //             offset++;
  //         }
  //     }
  // }
  // private readSizeStr(): string {
  //     return this.readStr(this.readUint());
  // }
  writeIndexStr(str) {
    if (str) {
      const index = strIndices[str];
      if (index) {
        this.writeUint(index);
      } else {
        this.writeUint(strIndices[str] = ++strIndex);
        strs[strIndex] = str;
      }
    } else {
      this.writeUint(0);
    }
  }
  readIndexStr() {
    return strs[this.readUint()];
  }
}();

// src/tests.ts
var Hex = new class {
  sb = [];
  s = [
    "00",
    "01",
    "02",
    "03",
    "04",
    "05",
    "06",
    "07",
    "08",
    "09",
    "0a",
    "0b",
    "0c",
    "0d",
    "0e",
    "0f",
    "10",
    "11",
    "12",
    "13",
    "14",
    "15",
    "16",
    "17",
    "18",
    "19",
    "1a",
    "1b",
    "1c",
    "1d",
    "1e",
    "1f",
    "20",
    "21",
    "22",
    "23",
    "24",
    "25",
    "26",
    "27",
    "28",
    "29",
    "2a",
    "2b",
    "2c",
    "2d",
    "2e",
    "2f",
    "30",
    "31",
    "32",
    "33",
    "34",
    "35",
    "36",
    "37",
    "38",
    "39",
    "3a",
    "3b",
    "3c",
    "3d",
    "3e",
    "3f",
    "40",
    "41",
    "42",
    "43",
    "44",
    "45",
    "46",
    "47",
    "48",
    "49",
    "4a",
    "4b",
    "4c",
    "4d",
    "4e",
    "4f",
    "50",
    "51",
    "52",
    "53",
    "54",
    "55",
    "56",
    "57",
    "58",
    "59",
    "5a",
    "5b",
    "5c",
    "5d",
    "5e",
    "5f",
    "60",
    "61",
    "62",
    "63",
    "64",
    "65",
    "66",
    "67",
    "68",
    "69",
    "6a",
    "6b",
    "6c",
    "6d",
    "6e",
    "6f",
    "70",
    "71",
    "72",
    "73",
    "74",
    "75",
    "76",
    "77",
    "78",
    "79",
    "7a",
    "7b",
    "7c",
    "7d",
    "7e",
    "7f",
    "80",
    "81",
    "82",
    "83",
    "84",
    "85",
    "86",
    "87",
    "88",
    "89",
    "8a",
    "8b",
    "8c",
    "8d",
    "8e",
    "8f",
    "90",
    "91",
    "92",
    "93",
    "94",
    "95",
    "96",
    "97",
    "98",
    "99",
    "9a",
    "9b",
    "9c",
    "9d",
    "9e",
    "9f",
    "a0",
    "a1",
    "a2",
    "a3",
    "a4",
    "a5",
    "a6",
    "a7",
    "a8",
    "a9",
    "aa",
    "ab",
    "ac",
    "ad",
    "ae",
    "af",
    "b0",
    "b1",
    "b2",
    "b3",
    "b4",
    "b5",
    "b6",
    "b7",
    "b8",
    "b9",
    "ba",
    "bb",
    "bc",
    "bd",
    "be",
    "bf",
    "c0",
    "c1",
    "c2",
    "c3",
    "c4",
    "c5",
    "c6",
    "c7",
    "c8",
    "c9",
    "ca",
    "cb",
    "cc",
    "cd",
    "ce",
    "cf",
    "d0",
    "d1",
    "d2",
    "d3",
    "d4",
    "d5",
    "d6",
    "d7",
    "d8",
    "d9",
    "da",
    "db",
    "dc",
    "dd",
    "de",
    "df",
    "e0",
    "e1",
    "e2",
    "e3",
    "e4",
    "e5",
    "e6",
    "e7",
    "e8",
    "e9",
    "ea",
    "eb",
    "ec",
    "ed",
    "ee",
    "ef",
    "f0",
    "f1",
    "f2",
    "f3",
    "f4",
    "f5",
    "f6",
    "f7",
    "f8",
    "f9",
    "fa",
    "fb",
    "fc",
    "fd",
    "fe",
    "ff"
  ];
  $s = [];
  $S = [];
  n = {
    "00": 0,
    "01": 1,
    "02": 2,
    "03": 3,
    "04": 4,
    "05": 5,
    "06": 6,
    "07": 7,
    "08": 8,
    "09": 9,
    "0a": 10,
    "0b": 11,
    "0c": 12,
    "0d": 13,
    "0e": 14,
    "0f": 15,
    "10": 16,
    "11": 17,
    "12": 18,
    "13": 19,
    "14": 20,
    "15": 21,
    "16": 22,
    "17": 23,
    "18": 24,
    "19": 25,
    "1a": 26,
    "1b": 27,
    "1c": 28,
    "1d": 29,
    "1e": 30,
    "1f": 31,
    "20": 32,
    "21": 33,
    "22": 34,
    "23": 35,
    "24": 36,
    "25": 37,
    "26": 38,
    "27": 39,
    "28": 40,
    "29": 41,
    "2a": 42,
    "2b": 43,
    "2c": 44,
    "2d": 45,
    "2e": 46,
    "2f": 47,
    "30": 48,
    "31": 49,
    "32": 50,
    "33": 51,
    "34": 52,
    "35": 53,
    "36": 54,
    "37": 55,
    "38": 56,
    "39": 57,
    "3a": 58,
    "3b": 59,
    "3c": 60,
    "3d": 61,
    "3e": 62,
    "3f": 63,
    "40": 64,
    "41": 65,
    "42": 66,
    "43": 67,
    "44": 68,
    "45": 69,
    "46": 70,
    "47": 71,
    "48": 72,
    "49": 73,
    "4a": 74,
    "4b": 75,
    "4c": 76,
    "4d": 77,
    "4e": 78,
    "4f": 79,
    "50": 80,
    "51": 81,
    "52": 82,
    "53": 83,
    "54": 84,
    "55": 85,
    "56": 86,
    "57": 87,
    "58": 88,
    "59": 89,
    "5a": 90,
    "5b": 91,
    "5c": 92,
    "5d": 93,
    "5e": 94,
    "5f": 95,
    "60": 96,
    "61": 97,
    "62": 98,
    "63": 99,
    "64": 100,
    "65": 101,
    "66": 102,
    "67": 103,
    "68": 104,
    "69": 105,
    "6a": 106,
    "6b": 107,
    "6c": 108,
    "6d": 109,
    "6e": 110,
    "6f": 111,
    "70": 112,
    "71": 113,
    "72": 114,
    "73": 115,
    "74": 116,
    "75": 117,
    "76": 118,
    "77": 119,
    "78": 120,
    "79": 121,
    "7a": 122,
    "7b": 123,
    "7c": 124,
    "7d": 125,
    "7e": 126,
    "7f": 127,
    "80": 128,
    "81": 129,
    "82": 130,
    "83": 131,
    "84": 132,
    "85": 133,
    "86": 134,
    "87": 135,
    "88": 136,
    "89": 137,
    "8a": 138,
    "8b": 139,
    "8c": 140,
    "8d": 141,
    "8e": 142,
    "8f": 143,
    "90": 144,
    "91": 145,
    "92": 146,
    "93": 147,
    "94": 148,
    "95": 149,
    "96": 150,
    "97": 151,
    "98": 152,
    "99": 153,
    "9a": 154,
    "9b": 155,
    "9c": 156,
    "9d": 157,
    "9e": 158,
    "9f": 159,
    "a0": 160,
    "a1": 161,
    "a2": 162,
    "a3": 163,
    "a4": 164,
    "a5": 165,
    "a6": 166,
    "a7": 167,
    "a8": 168,
    "a9": 169,
    "aa": 170,
    "ab": 171,
    "ac": 172,
    "ad": 173,
    "ae": 174,
    "af": 175,
    "b0": 176,
    "b1": 177,
    "b2": 178,
    "b3": 179,
    "b4": 180,
    "b5": 181,
    "b6": 182,
    "b7": 183,
    "b8": 184,
    "b9": 185,
    "ba": 186,
    "bb": 187,
    "bc": 188,
    "bd": 189,
    "be": 190,
    "bf": 191,
    "c0": 192,
    "c1": 193,
    "c2": 194,
    "c3": 195,
    "c4": 196,
    "c5": 197,
    "c6": 198,
    "c7": 199,
    "c8": 200,
    "c9": 201,
    "ca": 202,
    "cb": 203,
    "cc": 204,
    "cd": 205,
    "ce": 206,
    "cf": 207,
    "d0": 208,
    "d1": 209,
    "d2": 210,
    "d3": 211,
    "d4": 212,
    "d5": 213,
    "d6": 214,
    "d7": 215,
    "d8": 216,
    "d9": 217,
    "da": 218,
    "db": 219,
    "dc": 220,
    "dd": 221,
    "de": 222,
    "df": 223,
    "e0": 224,
    "e1": 225,
    "e2": 226,
    "e3": 227,
    "e4": 228,
    "e5": 229,
    "e6": 230,
    "e7": 231,
    "e8": 232,
    "e9": 233,
    "ea": 234,
    "eb": 235,
    "ec": 236,
    "ed": 237,
    "ee": 238,
    "ef": 239,
    "f0": 240,
    "f1": 241,
    "f2": 242,
    "f3": 243,
    "f4": 244,
    "f5": 245,
    "f6": 246,
    "f7": 247,
    "f8": 248,
    "f9": 249,
    "fa": 250,
    "fb": 251,
    "fc": 252,
    "fd": 253,
    "fe": 254,
    "ff": 255
  };
  cs = [];
  constructor() {
    let i2 = this.s.length;
    while (i2--) {
      this.$s[i2] = "%" + this.s[i2];
      this.$S[i2] = this.$s[i2].toUpperCase();
    }
    for (const key of Object.keys(this.n)) {
      const byte = this.n[key];
      const c = String.fromCharCode(byte);
      const Key = key.toUpperCase();
      this.n[c] = this.n[Key] = this.n["%" + key] = this.n["%" + Key] = byte;
      this.cs[byte] = c;
    }
  }
  int2str(_int) {
    this.sb.length = 0;
    this.sb[3] = this.s[_int & 255];
    this.sb[2] = this.s[_int >> 8 & 255];
    this.sb[1] = this.s[_int >> 16 & 255];
    this.sb[0] = this.s[_int >> 24 & 255];
    return this.sb.join("");
  }
  bytes2str(bytes3, offset2 = 0, len = -1) {
    offset2 > 0 || (offset2 = 0);
    len == -1 && (len = bytes3.length);
    this.sb.length = 0;
    while (len--) {
      this.sb[len] = this.s[bytes3[offset2 + len]];
    }
    return this.sb.join(" ");
  }
  str2bytes(str) {
    const hexs = str.match(/\w+/g);
    const bytes3 = new Uint8Array(hexs.length);
    let i2 = hexs.length;
    while (i2--) {
      bytes3[i2] = this.n[hexs[i2]];
    }
    return bytes3;
  }
  ints2str(_ints) {
    this.sb.length = 0;
    let i2 = _ints.length;
    let j = i2 << 2;
    while (i2--) {
      const _int = _ints[i2];
      this.sb[--j] = this.s[_int & 255];
      this.sb[--j] = this.s[_int >> 8 & 255];
      this.sb[--j] = this.s[_int >> 16 & 255];
      this.sb[--j] = this.s[_int >> 24 & 255];
    }
    return this.sb.join("");
  }
  intrevs2str(_ints) {
    this.sb.length = 0;
    let i2 = _ints.length;
    let j = i2 << 2;
    while (i2--) {
      const _int = _ints[i2];
      this.sb[--j] = this.s[_int >> 24 & 255];
      this.sb[--j] = this.s[_int >> 16 & 255];
      this.sb[--j] = this.s[_int >> 8 & 255];
      this.sb[--j] = this.s[_int & 255];
    }
    return this.sb.join("");
  }
}();
var Utils = new class {
  tryStringify(value, replacer, space) {
    try {
      return JSON.stringify(value, replacer, space);
    } catch (e) {
      console.error(e);
    }
    return "";
  }
}();
var Timer = new class {
  s = {};
  sec = 0;
  start(key) {
    if (key) {
      if (this.s[key]) {
        console.error("Timer \u91CD\u590Dstart\uFF1A" + key);
      } else {
        this.s[key] = (/* @__PURE__ */ new Date()).getTime();
      }
    } else {
      console.error("start Timer \u672A\u6307\u5B9A key");
    }
  }
  stop(key, threshold = -1) {
    if (key) {
      const startTime = this.s[key];
      if (startTime > 0) {
        delete this.s[key];
        this.sec = ((/* @__PURE__ */ new Date()).getTime() - startTime) / 1e3;
        this.sec > threshold && console.log(key + " \u8017\u65F6 " + this.sec + " \u79D2\uFF01");
      } else {
        console.error("Timer \u65E0\uFF1A" + key);
      }
    } else {
      console.error("stop Timer \u672A\u6307\u5B9A key");
    }
  }
  fixes(msOffset) {
    for (const key in this.s) {
      this.s[key] += msOffset;
    }
  }
}();
function test(value, cankaoTypes, cankaoFields, cankaoHex, cankaoStr, _types) {
  const bytes3 = Compact_default.encode(value, _types);
  const types2 = Utils.tryStringify(Compact_default.types);
  let ok = true;
  if (types2 == cankaoTypes) {
  } else {
    console.error(
      "types \u4E0D\u4E00\u81F4\uFF1A" + types2 + "\n      \u3000\u3000\u671F\u671B\uFF1A" + cankaoTypes
    );
    ok = false;
  }
  const fields = Compact_default.outputFields();
  if (fields == cankaoFields) {
  } else {
    console.error(
      "fields \u4E0D\u4E00\u81F4\uFF1A" + fields + "\n       \u3000\u3000\u671F\u671B\uFF1A" + cankaoFields
    );
    ok = false;
  }
  const hex = Hex.bytes2str(bytes3);
  if (hex == cankaoHex) {
  } else {
    console.error(
      "hex \u4E0D\u4E00\u81F4\uFF1A" + hex + "\n    \u3000\u3000\u671F\u671B\uFF1A" + cankaoHex
    );
    ok = false;
  }
  value = Compact_default.decode(bytes3);
  const str = Utils.tryStringify(value);
  if (str == cankaoStr) {
  } else {
    console.error(
      "str \u4E0D\u4E00\u81F4\uFF1A" + str + "\n    \u3000\u3000\u671F\u671B\uFF1A" + cankaoStr
    );
    ok = false;
  }
  ok ? \u901A\u8FC7\u6D4B\u8BD5++ : \u4E0D\u901A\u8FC7\u6D4B\u8BD5++;
}
var \u901A\u8FC7\u6D4B\u8BD5 = 0;
var \u4E0D\u901A\u8FC7\u6D4B\u8BD5 = 0;
test(true, '["bool"]', `
bool`, "00 39 01", "true");
test([1, false, "\u5566\u5566\u5566"], '["arr","bool","int","string"]', `
arr
  bool
  int
  string`, "01 e6 aa 01 03 00 00 00 01 03 8d 78 04 01 00 01", '[true,0,"\u5566\u5566\u5566"]', ["arr", "bool", "int", "string"]);
test({
  a: 233,
  b: [1, 2, 3, 4, 5],
  c: "\u{1F4A9}\u{1F468}\u200D\u{1F469}\u200D\u{1F466}\u200D\u{1F466}\u{1F926}\u{1F3FB}\u200D\u2642\uFE0F",
  d: [{ x: "\u{1F420}\u2B50", y: 555, z: null }, { x: "\u{1F5E1}\uFE0F1\u0F06\u82CD\u0F12\u767D", y: 666, z: 9527 }]
}, '["dict","a","int","b","arr","int",0,"c","string","d","arr","dict","x","string","y","int","z","string",0,0,0]', `
dict
  a: int
  b: arr
    int
  c: string
  d: arr
    dict
      x: string
      y: int
      z: string`, "1f bd b0 03 8d 40 e6 b8 03 8f fc 03 31 32 35 37 39 61 62 63 64 78 79 7a 86 1e 92 1e c2 4c d0 56 fd ec 01 cd 85 02 bc b0 03 be b0 03 a0 b8 03 e8 b8 03 e9 b8 03 a9 b9 03 a6 ba 03 e1 bb 03 fb bf 03 27 09 0a 0b 0c 0d 0e 0f 00 1b 00 19 01 00 1a 2a 02 2d 17 1c 16 1e 01 12 03 00 18 13 00 1d 03 04 10 15 11 14 08 06 05 07 0b 01 01 01 01 01 01 01 14 03 08 80 80 80 80 00 56 05 d6 14 01 1c 01 02 03 04 05 06 07 01 41 69 06 01 02 03 04 05 08 03 01 09 44 2b 00 01 0a 45 1a 0b", '{"a":233,"b":[1,2,3,4,5],"c":"\u{1F4A9}\u{1F468}\u200D\u{1F469}\u200D\u{1F466}\u200D\u{1F466}\u{1F926}\u{1F3FB}\u200D\u2642\uFE0F","d":[{"x":"\u{1F420}\u2B50","y":555,"z":""},{"x":"\u{1F5E1}\uFE0F1\u0F06\u82CD\u0F12\u767D","y":666,"z":""}]}');
console.log("\u901A\u8FC7\u6D4B\u8BD5\uFF1A" + \u901A\u8FC7\u6D4B\u8BD5 + "\uFF0C\u4E0D\u901A\u8FC7\u6D4B\u8BD5\uFF1A" + \u4E0D\u901A\u8FC7\u6D4B\u8BD5);
console.log(Compact_default.decode(Compact_default.encode(
  { a: 1, b: "2", c: ["\u5566\u5566\u5566"] }
  /*不指定类型就自动填充*/
)));
var datas = {
  version: 1234,
  heros: [],
  enemies: []
};
var i = 1e4;
while (i--) {
  datas.heros[i] = {
    id: 100001 + i,
    name: "\u7537/\u5973\u4E3B",
    atk: [(Math.random() * 1e4 >> 0) / 100, (Math.random() * 1e4 >> 0) / 100],
    def: [(Math.random() * 1e4 >> 0) / 100, (Math.random() * 1e4 >> 0) / 100]
  };
  datas.enemies[i] = {
    id: 200001 + i,
    name: "\u654C\u4EBA",
    desc: "\u8FD9\u5BB6\u4F19\u5F88\u61D2\u6CA1\u5199\u8BF4\u660E"
  };
}
var json1 = Utils.tryStringify(datas);
console.log("json\uFF1A" + (json1.length / (1024 * 1024)).toFixed(2) + "M");
Timer.start("json \u8F6C datas");
JSON.parse(json1);
Timer.stop("json \u8F6C datas");
var types = ["dict"];
types.push("version", "int");
types.push("heros", "arr");
types.push("dict");
types.push("id", "int");
types.push("name", "string");
types.push("atk", "arr", "float", 0);
types.push("def", "arr", "float", 0);
types.push(0);
types.push(0);
types.push("enemies", "arr");
types.push("dict");
types.push("id", "int");
types.push("name", "string");
types.push("desc", "string");
types.push(0);
types.push(0);
var bytes2 = Compact_default.encode(datas, types);
console.log("bytes\uFF1A" + (bytes2.length / (1024 * 1024)).toFixed(2) + "M");
Timer.start("bytes \u8F6C datas");
var datas2 = Compact_default.decode(bytes2);
Timer.stop("bytes \u8F6C datas");
var json2 = Utils.tryStringify(datas2);
if (json1 == json2) {
  console.log("\u6570\u636E\u4E00\u81F4\uFF01");
} else {
  console.error("\u6570\u636E\u4E0D\u4E00\u81F4\uFF01");
}
