const typeCodes: { [key: string]: number } = {};
const typeArr: Array<string | 0 | 7> = [0, "bool", "int", "float", "string", "arr", "dict", 7];
const typesBuffer = new Uint8Array(1024 * 2);
const bytes = new Uint8Array(1024 * 1024 * 4);
let offset: number;
const strIndices: { [key: string]: number } = {};
let strIndex: number;
const strs: Array<string> = [];
const counts: { [key: string]: number } = {};
const cs: Array<string> = [];
const codesByPart: { [key: string]: number } = {};
const partsByCode: Array<string> = [];
const codes: Array<number> = [];
const sb: Array<string> = [];
const uis: Uint32Array = new Uint32Array(10);
interface Field {
    name: string;
    type: "bool" | "int" | "float" | "string" | "arr" | "dict",
    subs: Field[]
}
let rootField: Field;
let currField: Field;
export default new class {
    public types: (string | 0 | 7)[] = [];
    public end: number = undefined!;

    public constructor() {
        let i: number = -1;
        for (const type of typeArr) {
            typeCodes[type] = ++i;
        }
    }

    private autoAddTypes(value: any): void {
        if (value) {
            switch (typeof (value)) {
                case "boolean":
                    this.types.push("bool");
                    break;
                case "number":
                    this.types.push("int");
                    break;
                case "string":
                    this.types.push("string");
                    break;
                default:
                    if (Array.isArray(value)) {
                        this.types.push("arr");
                        this.autoAddTypes(value[0]);
                        this.types.push(0);
                    } else {
                        this.types.push("dict");
                        for (const key in value) {
                            this.types.push(key);
                            this.autoAddTypes(value[key]);
                        }
                        this.types.push(0);
                    }
                    break;
            }
        } else {
            switch (value) {
                case false:
                    this.types.push("bool");
                    break;
                case 0:
                    this.types.push("int");
                    break;
                default:
                    this.types.push("string");
                    break;
            }
        }
    }
    private 把线性的types整理成树状(): void {
        rootField = { name: undefined!, type: this.types[0] as any, subs: undefined! };
        let curr: Field;
        let field: Field = undefined!;
        const stack: Field[] = [];
        curr = rootField;
        switch (curr.type) {
            case "arr":
            case "dict":
                stack.push(curr);
                curr.subs = [];
                break;
        }
        let offset: number = 0;
        while (++offset < this.types.length) {
            const type = this.types[offset];
            switch (type) {
                case 0:
                    curr = stack.pop()!;
                    field = undefined!;
                    break;
                case "bool":
                case "int":
                case "float":
                case "string":
                case "arr":
                case "dict":
                    if (curr.type == "arr") {
                        curr.subs.push(field = { type: type, name: undefined!, subs: undefined! });
                    } else {
                        field.type = type;
                    }
                    switch (type) {
                        case "arr":
                        case "dict":
                            stack.push(curr);
                            curr = field;
                            curr.subs = [];
                            break;
                    }
                    field = undefined!;
                    break;
                default:
                    curr.subs.push(field = { type: undefined!, name: type as string, subs: undefined! });
                    break;
            }
        }
        stack.length = 0;
    }
    public outputFields(): string {
        sb.length = 0;
        this._outputField(rootField, "");
        return sb.join("");
    }
    private _outputField(field: Field, tab: string): void {
        sb.push("\n");
        sb.push(tab);
        if (field.name) {
            sb.push(field.name);
            sb.push(": ");
        }
        sb.push(field.type);
        if (field.subs) {
            tab += "  ";
            for (const sub of field.subs) {
                this._outputField(sub, tab);
            }
        }
    }
    public clearObj<T>(obj: T): void {
        for (const key in obj) {
            delete obj[key];
        }
    }
    public encode<T>(data: T, _types?: (string | 0 | 7)[]): Uint8Array {
        this.clearObj(strIndices);
        strs.length = strIndex = 0;
        strs[0] = "";

        //#region 写入类型
        this.types.length = 0;
        if (_types) {
            this.types.push.apply(this.types, _types);
        } else {
            this.autoAddTypes(data);
        }
        this.types.push(7);
        const dataOffset = offset = bytes.length >> 1;
        let typesSize: number = 0;
        let shift: number = 0;
        let u16: number = 0;
        for (const type of this.types) {
            const code = typeCodes[type]!;
            if (code > -1) {
                u16 |= code << shift;
                if ((shift += 3) < 8) { } else {
                    typesBuffer[typesSize++] = u16;
                    shift -= 8;
                    u16 >>= 8;
                }
            } else {
                this.writeIndexStr(type as string);
            }
        }
        if (u16) {
            typesBuffer[typesSize++] = u16;
        }
        this.types.pop();
        typesSize > typesBuffer.length >> 1 && console.error("要超拉！" + typesSize);
        //console.log("类型块大小：" + typesSize);
        //#endregion

        this.把线性的types整理成树状();

        currField = rootField;
        this.writeValue(data);
        offset > (bytes.length >> 2) * 3 && console.error("要超拉！" + offset);
        const dataBuffer = bytes.subarray(dataOffset, offset);
        //console.log("数据块大小：" + dataBuffer.length);

        offset = 0;
        if (strIndex) {
            strs.shift();
            const allStr = strs.join("");

            //#region 统计字符使用频率，按降序排序
            this.clearObj(counts);
            cs.length = 0;
            let index: number = 0;
            const len = allStr.length;
            let i: number = -1;
            while (++i < len) {
                const c = allStr[i]!;
                if (counts[c]) {
                    counts[c]++;
                } else {
                    counts[c] = 1;
                    cs[index++] = c;
                }
            }
            cs.sort((c1, c2) => {
                const d = counts[c2]! - counts[c1]!;
                if (d) return d;
                return c1 < c2 ? -1 : 1;
            });
            //#endregion

            //#region lzw
            this.clearObj(codesByPart);
            let code: number = 0;
            for (const c of cs) {
                codesByPart[c] = code++;
            }

            let prevPart: string = undefined!;
            codes.length = 0;
            index = 0;
            while (offset < len) {
                let part: string = allStr[offset]!;
                i = 1;
                while (offset + i < len) {
                    const nextPart = part + allStr[offset + i];
                    if (codesByPart[nextPart]! > -1) {
                        part = nextPart;
                        i++;
                    } else {
                        break;
                    }
                }
                codes[index++] = codesByPart[part]!;

                offset += i;
                if (prevPart) {
                    prevPart += part[0];
                    codesByPart[prevPart]! > -1 || (codesByPart[prevPart] = code++);
                }
                prevPart = part;
            }
            //#endregion

            offset = 0;
            //#region 写入字符字典
            this.writeUint(cs.length);
            for (const c of cs) {
                this.writeC(c.charCodeAt(0));
            }
            //#endregion

            this.writeUint(codes.length);
            for (const _code of codes) {
                this.writeUint(_code);
            }

            this.writeUint(strIndex);
            for (const str of strs) {
                this.writeUint(str.length);
            }
            //console.log("字符串池大小：" + offset);
        } else {
            this.writeByte(0);
        }

        bytes.set(typesBuffer.subarray(0, typesSize), offset);
        bytes.set(dataBuffer, offset + typesSize);
        this.end = offset + typesSize + dataBuffer.length;
        //console.log("encode end=" + this.end);
        return bytes.subarray(0, this.end);
    }
    private writeValue(value: any): void {
        switch (currField.type) {
            case "bool":
                this.writeBool(value);
                break;
            case "int":
                this.writeInt(value);
                break;
            case "float":
                this.writeFloat(value, 6);
                break;
            case "string":
                this.writeIndexStr(value);
                break;
            case "arr":
                this.writeArr(value);
                break;
            case "dict":
                this.writeDict(value);
                break;
        }
    }
    private writeArr(arr: Array<any>): void {
        if (arr) {
            this.writeUint(arr.length + 1);
            const arrField = currField;
            let fieldIndex: number = -1;
            for (const value of arr) {
                ++fieldIndex < arrField.subs.length || (fieldIndex = 0);
                currField = arrField.subs[fieldIndex]!;
                this.writeValue(value);
            }
            currField = arrField;
        } else {
            this.writeByte(0);
        }
    }
    private writeDict(dict: { [key: string]: any }): void {
        if (dict) {
            this.writeByte(1);
            const dictField = currField;
            for (currField of dictField.subs) {
                this.writeValue(dict[currField.name]);
            }
            currField = dictField;
        } else {
            this.writeByte(0);
        }
    }

    public decode<T>(_bytes: Uint8Array): T {
        bytes.set(_bytes);

        offset = 0;
        let i: number = this.readUint();
        if (i) {
            //#region 读取字符字典
            this.clearObj(codesByPart);
            partsByCode.length = 0;
            let code: number = 0;
            while (i--) {
                const c = this.readC();
                codesByPart[c] = code;
                partsByCode[code++] = c;
            }
            //#endregion

            //#region lzw
            sb.length = 0;
            let sbIndex: number = 0;
            let prevPart: string = undefined!;
            i = this.readUint();
            while (i--) {
                const _code = this.readUint();
                const part = partsByCode[_code]!;
                sb[sbIndex++] = part;
                if (prevPart) {
                    prevPart += part[0];
                    if (codesByPart[prevPart]) { } else {
                        codesByPart[prevPart] = code;
                        partsByCode[code++] = prevPart;
                    }
                }
                prevPart = part;
            }
            //#endregion

            const allStr = sb.join("");
            let strCount: number = this.readUint();
            strs[0] = "";
            let j: number = 0;
            i = 0;
            while (strCount--) {
                const strLen = this.readUint();
                strs[++j] = allStr.substr(i, strLen);
                i += strLen;
            }
        }

        this.types.length = 0;
        let shift: number = 0;
        let u16: number = bytes[offset++]! | bytes[offset++]! << 8;
        i = -1;
        for (; ;) {
            const code = (u16 >> shift) & 7;
            if (code == 7) break;
            this.types[++i] = typeArr[code]!;
            if ((shift += 3) < 8) { } else {
                u16 = u16 >> 8 | bytes[offset++]! << 8;
                shift -= 8;
            }
        }
        shift + 3 > 8 || (offset--);
        this.readDictKeys();

        this.把线性的types整理成树状();

        currField = rootField;
        const value = this.readValue();
        this.end = offset;
        //console.log("decode end=" + this.end);
        return value;
    }

    private readDictKeys(): void {
        const stack = [];
        let curr: string;
        switch (this.types[0]) {
            case "arr":
            case "dict":
                stack.push(curr = this.types[0]);
                break;
            default:
                curr = undefined!;
                break;
        }
        let offset: number = 0;
        while (++offset < this.types.length) {
            const type = this.types[offset];
            switch (type) {
                case 0:
                    curr = stack.pop()!;
                    break;
                case "bool":
                case "int":
                case "float":
                case "string":
                case "arr":
                case "dict":
                    if (curr == "dict") {
                        this.types.splice(offset++, 0, this.readIndexStr());
                    }
                    switch (type) {
                        case "arr":
                        case "dict":
                            stack.push(curr);
                            curr = type;
                            break;
                    }
                    break;
            }
        }
        stack.length = 0;
    }
    private readValue(): any {
        switch (currField.type) {
            case "bool":
                return this.readBool();
            case "int":
                return this.readInt();
            case "float":
                return this.readFloat();
            case "string":
                return this.readIndexStr();
            case "arr":
                return this.readArr();
            case "dict":
                return this.readDict();
        }
    }
    private readArr(): Array<any> {
        let count: number = this.readUint();
        if (count > 1000000) {
            throw new Error("count=" + count);
        }
        if (count) {
            const arr: Array<any> = [];
            if (--count) {
                const arrField = currField;
                let fieldIndex: number = -1;
                for (let i: number = 0; i < count; i++) {
                    ++fieldIndex < arrField.subs.length || (fieldIndex = 0);
                    currField = arrField.subs[fieldIndex]!;
                    arr[i] = this.readValue();
                }
                currField = arrField;
            }
            return arr;
        }
        return undefined!;
    }
    private readDict(): { [key: string]: any } {
        if (this.readByte()) {
            const dict: { [key: string]: any } = {};
            const dictField = currField;
            for (currField of dictField.subs) {
                dict[currField.name] = this.readValue();
            }
            currField = dictField;
            return dict;
        }
        return undefined!;
    }

    private writeBool(flag: boolean): void {
        bytes[offset++] = flag ? 1 : 0;
    }
    private readBool(): boolean {
        return bytes[offset++]! > 0;
    }
    private writeByte(num: number): void {
        bytes[offset++] = num;
    }
    private readByte(): number {
        return bytes[offset++]!;
    }
    private writeUint(num: number): void {
        if (num < 0x80)//0 xxxxxxx
        {
            bytes[offset++] = num;
        } else if (num < 0x4000)//1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = 0x80 | (num >> 7);
            bytes[offset++] = num & 0x7f;
        } else if (num < 0x200000)//1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = 0x80 | (num >> 14);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        } else if (num < 0x10000000)//1 xxxxxxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = 0x80 | (num >> 21);
            bytes[offset++] = 0x80 | ((num >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        } else//1 xxxxxxx | 1 xxxxxxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = 0x80 | (num >> 28);
            bytes[offset++] = 0x80 | ((num >> 21) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        }
    }
    private readUint(): number {
        const byte1 = bytes[offset++]!;
        if (byte1 & 0x80) {
            const byte2 = bytes[offset++]!;
            if (byte2 & 0x80) {
                const byte3 = bytes[offset++]!;
                if (byte3 & 0x80) {
                    const byte4 = bytes[offset++]!;
                    if (byte4 & 0x80) {
                        const byte5 = bytes[offset++]!;
                        return ((byte1 & 0x7f) << 28) | ((byte2 & 0x7f) << 21) | ((byte3 & 0x7f) << 14) | ((byte4 & 0x7f) << 7) | byte5;
                    } else {
                        return ((byte1 & 0x7f) << 21) | ((byte2 & 0x7f) << 14) | ((byte3 & 0x7f) << 7) | byte4;
                    }
                } else {
                    return ((byte1 & 0x7f) << 14) | ((byte2 & 0x7f) << 7) | byte3;
                }
            } else {
                return ((byte1 & 0x7f) << 7) | byte2;
            }
        } else {
            return byte1;
        }
    }
    private writeInt(num: number): void {
        let sign: number;
        if (num < 0) {
            sign = 0x80;
            num = -num;
        } else {
            sign = 0x00;
        }
        if (num < 0x40)//sign 0 xxxxxx
        {
            bytes[offset++] = sign | num;
        } else if (num < 0x2000)//sign 1 xxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | 0x40 | (num >> 7);
            bytes[offset++] = num & 0x7f;
        } else if (num < 0x100000)//sign 1 xxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | 0x40 | (num >> 14);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        } else if (num < 0x8000000)//sign 1 xxxxxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | 0x40 | (num >> 21);
            bytes[offset++] = 0x80 | ((num >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        } else//sign 1 xxxxxx | 1 xxxxxxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | 0x40 | (num >> 28);
            bytes[offset++] = 0x80 | ((num >> 21) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((num >> 7) & 0x7f);
            bytes[offset++] = num & 0x7f;
        }
    }
    private readInt(): number {
        let num: number;
        const byte1 = bytes[offset++]!;
        if (byte1 & 0x40) {
            const byte2 = bytes[offset++]!;
            if (byte2 & 0x80) {
                const byte3 = bytes[offset++]!;
                if (byte3 & 0x80) {
                    const byte4 = bytes[offset++]!;
                    if (byte4 & 0x80) {
                        const byte5 = bytes[offset++]!;
                        num = ((byte1 & 0x3f) << 28) | ((byte2 & 0x7f) << 21) | ((byte3 & 0x7f) << 14) | ((byte4 & 0x7f) << 7) | byte5;
                    } else {
                        num = ((byte1 & 0x3f) << 21) | ((byte2 & 0x7f) << 14) | ((byte3 & 0x7f) << 7) | byte4;
                    }
                } else {
                    num = ((byte1 & 0x3f) << 14) | ((byte2 & 0x7f) << 7) | byte3;
                }
            } else {
                num = ((byte1 & 0x3f) << 7) | byte2;
            }
        } else {
            num = byte1 & 0x3f;
        }
        return byte1 & 0x80 ? -num : num;
    }
    private writeFloat(num: number, pow: number): void {
        let sign: number;
        if (num < 0) {
            sign = 0x80;
            num = -num;
        } else {
            sign = 0x00;
        }
        uis[0] = num;
        const d = num - uis[0];
        if (d > 0.0000001) {
            if (uis[0]) {
                pow -= Math.ceil(Math.log10(uis[0]));
            }
            uis[1] = Math.pow(10, pow);
            uis[2] = Math.round(d * uis[1]);
            while (pow) {
                uis[3] = uis[2] / 10;
                uis[3] *= 10;
                if (uis[2] == uis[3]) {
                    uis[1] /= 10;
                    uis[2] /= 10;
                    pow--;
                } else {
                    break;
                }
            }
            uis[0] = uis[0] * uis[1] + uis[2];
            pow <<= 4;
        } else {
            pow = 0;
        }
        const _int = uis[0];
        if (_int < 0x8)//sign xxx 0 xxx
        {
            bytes[offset++] = sign | pow | _int;
        } else if (_int < 0x400)//sign xxx 1 xxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | pow | 0x8 | (_int >> 7);
            bytes[offset++] = _int & 0x7f;
        } else if (_int < 0x20000)//sign xxx 1 xxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | pow | 0x8 | (_int >> 14);
            bytes[offset++] = 0x80 | ((_int >> 7) & 0x7f);
            bytes[offset++] = _int & 0x7f;
        } else if (_int < 0x1000000)//sign xxx 1 xxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | pow | 0x8 | (_int >> 21);
            bytes[offset++] = 0x80 | ((_int >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((_int >> 7) & 0x7f);
            bytes[offset++] = _int & 0x7f;
        } else//sign xxx 1 xxx | 1 xxxxxxx | 1 xxxxxxx | 1 xxxxxxx | 0 xxxxxxx
        {
            bytes[offset++] = sign | pow | 0x8 | (_int >> 28);
            bytes[offset++] = 0x80 | ((_int >> 21) & 0x7f);
            bytes[offset++] = 0x80 | ((_int >> 14) & 0x7f);
            bytes[offset++] = 0x80 | ((_int >> 7) & 0x7f);
            bytes[offset++] = _int & 0x7f;
        }
    }
    private readFloat(): number {
        let num: number;
        const byte1 = bytes[offset++]!;
        if (byte1 & 0x8) {
            const byte2 = bytes[offset++]!;
            if (byte2 & 0x80) {
                const byte3 = bytes[offset++]!;
                if (byte3 & 0x80) {
                    const byte4 = bytes[offset++]!;
                    if (byte4 & 0x80) {
                        const byte5 = bytes[offset++]!;
                        num = ((byte1 & 0x7) << 28) | ((byte2 & 0x7f) << 21) | ((byte3 & 0x7f) << 14) | ((byte4 & 0x7f) << 7) | byte5;
                    } else {
                        num = ((byte1 & 0x7) << 21) | ((byte2 & 0x7f) << 14) | ((byte3 & 0x7f) << 7) | byte4;
                    }
                } else {
                    num = ((byte1 & 0x7) << 14) | ((byte2 & 0x7f) << 7) | byte3;
                }
            } else {
                num = ((byte1 & 0x7) << 7) | byte2;
            }
        } else {
            num = byte1 & 0x7;
        }
        let pow: number = (byte1 >> 4) & 0x7;
        let _10s: number = 1;
        while (pow--) {
            _10s *= 10;
        }
        num /= _10s;
        return byte1 & 0x80 ? -num : num;
    }
    private writeC(c: number): void {
        if (c < 0x80) {
            bytes[offset++] = c;
        } else if (c < 0x4000) {
            bytes[offset++] = 0x80 | (c & 0x7f);
            bytes[offset++] = c >> 7;
        } else {
            bytes[offset++] = 0x80 | (c & 0x7f);
            bytes[offset++] = 0x80 | ((c >> 7) & 0x7f);
            bytes[offset++] = c >> 14;
        }
    }
    private readC(): string {
        const code1 = bytes[offset++]!;
        if (code1 < 0x80) {
            return String.fromCharCode(code1);
        }
        const code2 = bytes[offset++]!;
        if (code2 < 0x80) {
            return String.fromCharCode((code2 << 7) | (code1 & 0x7f));
        }
        const code3 = bytes[offset++]!;
        return String.fromCharCode((code3 << 14) | ((code2 & 0x7f) << 7) | (code1 & 0x7f));
    }
    // private writeStr(str: string): void {
    //     if (str) {
    //         const len = str.length;
    //         for (let i: number = 0; i < len; i++) {
    //             this.writeC(str.charCodeAt(i));
    //         }
    //     }
    // }
    // private readStr(size: number): string {
    //     size += offset;
    //     sb.length = 0;
    //     let sbIndex: number = 0;
    //     while (offset < size) {
    //         sb[sbIndex++] = this.readC();
    //     }
    //     return sb.join("");
    // }
    // private writeSizeStr(str: string): void {
    //     offset += 4;//先占4位
    //     const oldOffset = offset;
    //     this.writeStr(str);
    //     let size: number = offset - oldOffset;
    //     offset = oldOffset - 4;
    //     this.writeUint(size);
    //     const _offset = oldOffset - offset;
    //     if (_offset > 0) {
    //         while (size--) {
    //             bytes[offset] = bytes[offset + _offset];
    //             offset++;
    //         }
    //     }
    // }
    // private readSizeStr(): string {
    //     return this.readStr(this.readUint());
    // }
    private writeIndexStr(str: string): void {
        if (str) {
            const index = strIndices[str];
            if (index) {
                this.writeUint(index);
            } else {
                this.writeUint(strIndices[str] = ++strIndex);
                strs[strIndex] = str;
            }
        } else {
            this.writeUint(0);
        }
    }
    private readIndexStr(): string {
        return strs[this.readUint()]!;
    }
}