import Compact from "./Compact";
const Hex = new class {
    private sb: Array<string> = [];
    public s: Array<string> = [
        "00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f",
        "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f",
        "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f",
        "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f",
        "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f",
        "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f",
        "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f",
        "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f",
        "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f",
        "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f",
        "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af",
        "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf",
        "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf",
        "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df",
        "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef",
        "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"
    ];
    public $s: Array<string> = [];
    public $S: Array<string> = [];
    public n: { [key: string]: number } = {
        "00": 0x00, "01": 0x01, "02": 0x02, "03": 0x03, "04": 0x04, "05": 0x05, "06": 0x06, "07": 0x07, "08": 0x08, "09": 0x09, "0a": 0x0a, "0b": 0x0b, "0c": 0x0c, "0d": 0x0d, "0e": 0x0e, "0f": 0x0f,
        "10": 0x10, "11": 0x11, "12": 0x12, "13": 0x13, "14": 0x14, "15": 0x15, "16": 0x16, "17": 0x17, "18": 0x18, "19": 0x19, "1a": 0x1a, "1b": 0x1b, "1c": 0x1c, "1d": 0x1d, "1e": 0x1e, "1f": 0x1f,
        "20": 0x20, "21": 0x21, "22": 0x22, "23": 0x23, "24": 0x24, "25": 0x25, "26": 0x26, "27": 0x27, "28": 0x28, "29": 0x29, "2a": 0x2a, "2b": 0x2b, "2c": 0x2c, "2d": 0x2d, "2e": 0x2e, "2f": 0x2f,
        "30": 0x30, "31": 0x31, "32": 0x32, "33": 0x33, "34": 0x34, "35": 0x35, "36": 0x36, "37": 0x37, "38": 0x38, "39": 0x39, "3a": 0x3a, "3b": 0x3b, "3c": 0x3c, "3d": 0x3d, "3e": 0x3e, "3f": 0x3f,
        "40": 0x40, "41": 0x41, "42": 0x42, "43": 0x43, "44": 0x44, "45": 0x45, "46": 0x46, "47": 0x47, "48": 0x48, "49": 0x49, "4a": 0x4a, "4b": 0x4b, "4c": 0x4c, "4d": 0x4d, "4e": 0x4e, "4f": 0x4f,
        "50": 0x50, "51": 0x51, "52": 0x52, "53": 0x53, "54": 0x54, "55": 0x55, "56": 0x56, "57": 0x57, "58": 0x58, "59": 0x59, "5a": 0x5a, "5b": 0x5b, "5c": 0x5c, "5d": 0x5d, "5e": 0x5e, "5f": 0x5f,
        "60": 0x60, "61": 0x61, "62": 0x62, "63": 0x63, "64": 0x64, "65": 0x65, "66": 0x66, "67": 0x67, "68": 0x68, "69": 0x69, "6a": 0x6a, "6b": 0x6b, "6c": 0x6c, "6d": 0x6d, "6e": 0x6e, "6f": 0x6f,
        "70": 0x70, "71": 0x71, "72": 0x72, "73": 0x73, "74": 0x74, "75": 0x75, "76": 0x76, "77": 0x77, "78": 0x78, "79": 0x79, "7a": 0x7a, "7b": 0x7b, "7c": 0x7c, "7d": 0x7d, "7e": 0x7e, "7f": 0x7f,
        "80": 0x80, "81": 0x81, "82": 0x82, "83": 0x83, "84": 0x84, "85": 0x85, "86": 0x86, "87": 0x87, "88": 0x88, "89": 0x89, "8a": 0x8a, "8b": 0x8b, "8c": 0x8c, "8d": 0x8d, "8e": 0x8e, "8f": 0x8f,
        "90": 0x90, "91": 0x91, "92": 0x92, "93": 0x93, "94": 0x94, "95": 0x95, "96": 0x96, "97": 0x97, "98": 0x98, "99": 0x99, "9a": 0x9a, "9b": 0x9b, "9c": 0x9c, "9d": 0x9d, "9e": 0x9e, "9f": 0x9f,
        "a0": 0xa0, "a1": 0xa1, "a2": 0xa2, "a3": 0xa3, "a4": 0xa4, "a5": 0xa5, "a6": 0xa6, "a7": 0xa7, "a8": 0xa8, "a9": 0xa9, "aa": 0xaa, "ab": 0xab, "ac": 0xac, "ad": 0xad, "ae": 0xae, "af": 0xaf,
        "b0": 0xb0, "b1": 0xb1, "b2": 0xb2, "b3": 0xb3, "b4": 0xb4, "b5": 0xb5, "b6": 0xb6, "b7": 0xb7, "b8": 0xb8, "b9": 0xb9, "ba": 0xba, "bb": 0xbb, "bc": 0xbc, "bd": 0xbd, "be": 0xbe, "bf": 0xbf,
        "c0": 0xc0, "c1": 0xc1, "c2": 0xc2, "c3": 0xc3, "c4": 0xc4, "c5": 0xc5, "c6": 0xc6, "c7": 0xc7, "c8": 0xc8, "c9": 0xc9, "ca": 0xca, "cb": 0xcb, "cc": 0xcc, "cd": 0xcd, "ce": 0xce, "cf": 0xcf,
        "d0": 0xd0, "d1": 0xd1, "d2": 0xd2, "d3": 0xd3, "d4": 0xd4, "d5": 0xd5, "d6": 0xd6, "d7": 0xd7, "d8": 0xd8, "d9": 0xd9, "da": 0xda, "db": 0xdb, "dc": 0xdc, "dd": 0xdd, "de": 0xde, "df": 0xdf,
        "e0": 0xe0, "e1": 0xe1, "e2": 0xe2, "e3": 0xe3, "e4": 0xe4, "e5": 0xe5, "e6": 0xe6, "e7": 0xe7, "e8": 0xe8, "e9": 0xe9, "ea": 0xea, "eb": 0xeb, "ec": 0xec, "ed": 0xed, "ee": 0xee, "ef": 0xef,
        "f0": 0xf0, "f1": 0xf1, "f2": 0xf2, "f3": 0xf3, "f4": 0xf4, "f5": 0xf5, "f6": 0xf6, "f7": 0xf7, "f8": 0xf8, "f9": 0xf9, "fa": 0xfa, "fb": 0xfb, "fc": 0xfc, "fd": 0xfd, "fe": 0xfe, "ff": 0xff
    }
    public cs: Array<string> = [];
    public constructor() {
        let i: number = this.s.length;
        while (i--) {
            this.$s[i] = "%" + this.s[i];
            this.$S[i] = this.$s[i]!.toUpperCase();
        }
        for (const key of Object.keys(this.n)) {
            const byte = this.n[key]!;
            const c = String.fromCharCode(byte);
            const Key = key.toUpperCase();
            this.n[c] = this.n[Key] = this.n["%" + key] = this.n["%" + Key] = byte;
            this.cs[byte] = c;
        }
    }
    public int2str(_int: number): string {
        this.sb.length = 0;
        this.sb[3] = this.s[_int & 0xff]!;
        this.sb[2] = this.s[(_int >> 8) & 0xff]!;
        this.sb[1] = this.s[(_int >> 16) & 0xff]!;
        this.sb[0] = this.s[(_int >> 24) & 0xff]!;
        return this.sb.join("");
    }

    public bytes2str(bytes: Uint8Array | Array<number>, offset: number = 0, len: number = -1): string {
        offset > 0 || (offset = 0);
        len == -1 && (len = bytes.length);
        this.sb.length = 0;
        while (len--) {
            this.sb[len] = this.s[bytes[offset + len]!]!;
        }
        return this.sb.join(" ");
    }
    public str2bytes(str: string): Uint8Array {
        const hexs: Array<string> = str.match(/\w+/g)!;
        const bytes = new Uint8Array(hexs.length);
        let i: number = hexs.length;
        while (i--) {
            bytes[i] = this.n[hexs[i]!]!;
        }
        return bytes;
    }

    public ints2str(_ints: Uint32Array | Array<number>): string {
        this.sb.length = 0;
        let i: number = _ints.length;
        let j: number = i << 2;
        while (i--) {
            const _int = _ints[i]!;
            this.sb[--j] = this.s[_int & 0xff]!;
            this.sb[--j] = this.s[(_int >> 8) & 0xff]!;
            this.sb[--j] = this.s[(_int >> 16) & 0xff]!;
            this.sb[--j] = this.s[(_int >> 24) & 0xff]!;
        }
        return this.sb.join("");
    }

    public intrevs2str(_ints: Uint32Array | Array<number>): string {
        this.sb.length = 0;
        let i: number = _ints.length;
        let j: number = i << 2;
        while (i--) {
            const _int = _ints[i]!;
            this.sb[--j] = this.s[(_int >> 24) & 0xff]!;
            this.sb[--j] = this.s[(_int >> 16) & 0xff]!;
            this.sb[--j] = this.s[(_int >> 8) & 0xff]!;
            this.sb[--j] = this.s[_int & 0xff]!;
        }
        return this.sb.join("");
    }
}
const Utils = new class {
    public tryStringify(value: any, replacer?: (this: any, key: string, value: any) => any, space?: string | number): string {
        try {
            return JSON.stringify(value, replacer, space);
        } catch (e) {
            console.error(e);
        }
        return "";
    }
}
const Timer = new class {
    private s: { [key: string]: number } = {};
    private sec: number = 0;
    public start(key: string): void {
        if (key) {
            if (this.s[key]) {
                console.error("Timer 重复start：" + key);
            } else {
                this.s[key] = new Date().getTime();
            }
        } else {
            console.error("start Timer 未指定 key");
        }
    }
    public stop(key: string, threshold: number = -1): void {
        if (key) {
            const startTime = this.s[key]!;
            if (startTime > 0) {
                delete this.s[key];
                this.sec = (new Date().getTime() - startTime) / 1000;
                this.sec > threshold && console.log(key + " 耗时 " + this.sec + " 秒！");
            } else {
                console.error("Timer 无：" + key);
            }
        } else {
            console.error("stop Timer 未指定 key");
        }
    }
    public fixes(msOffset: number): void {
        for (const key in this.s) {
            this.s[key] += msOffset;
        }
    }
}
function test(value: any, cankaoTypes: string, cankaoFields: string, cankaoHex: string, cankaoStr: string, _types?: (string | 0 | 7)[]): void {
    const bytes = Compact.encode(value, _types);
    const types = Utils.tryStringify(Compact.types);
    let ok: boolean = true;
    if (types == cankaoTypes) { } else {
        console.error(
            "types 不一致：" + types + "\n" +
            "      　　期望：" + cankaoTypes
        );
        ok = false;
    }
    const fields = Compact.outputFields();
    if (fields == cankaoFields) { } else {
        console.error(
            "fields 不一致：" + fields + "\n" +
            "       　　期望：" + cankaoFields
        );
        ok = false;
    }
    const hex = Hex.bytes2str(bytes);
    if (hex == cankaoHex) { } else {
        console.error(
            "hex 不一致：" + hex + "\n" +
            "    　　期望：" + cankaoHex
        );
        ok = false;
    }
    value = Compact.decode(bytes);
    const str = Utils.tryStringify(value);
    if (str == cankaoStr) { } else {
        console.error(
            "str 不一致：" + str + "\n" +
            "    　　期望：" + cankaoStr
        );
        ok = false;
    }
    ok ? (通过测试++) : (不通过测试++);
}

let 通过测试: number = 0;
let 不通过测试: number = 0;

test(true, '["bool"]', `
bool`, "00 39 01", 'true');

test([1, false, "啦啦啦"], '["arr","bool","int","string"]', `
arr
  bool
  int
  string`, "01 e6 aa 01 03 00 00 00 01 03 8d 78 04 01 00 01", '[true,0,"啦啦啦"]', ["arr", "bool", "int", "string"]);

test({
    a: 233,
    b: [1, 2, 3, 4, 5],
    c: "💩👨‍👩‍👦‍👦🤦🏻‍♂️",
    d: [{ x: "🐠⭐", y: 555, z: null }, { x: "🗡️1༆苍༒白", y: 666, z: 9527 }]
}, '["dict","a","int","b","arr","int",0,"c","string","d","arr","dict","x","string","y","int","z","string",0,0,0]', `
dict
  a: int
  b: arr
    int
  c: string
  d: arr
    dict
      x: string
      y: int
      z: string`, '1f bd b0 03 8d 40 e6 b8 03 8f fc 03 31 32 35 37 39 61 62 63 64 78 79 7a 86 1e 92 1e c2 4c d0 56 fd ec 01 cd 85 02 bc b0 03 be b0 03 a0 b8 03 e8 b8 03 e9 b8 03 a9 b9 03 a6 ba 03 e1 bb 03 fb bf 03 27 09 0a 0b 0c 0d 0e 0f 00 1b 00 19 01 00 1a 2a 02 2d 17 1c 16 1e 01 12 03 00 18 13 00 1d 03 04 10 15 11 14 08 06 05 07 0b 01 01 01 01 01 01 01 14 03 08 80 80 80 80 00 56 05 d6 14 01 1c 01 02 03 04 05 06 07 01 41 69 06 01 02 03 04 05 08 03 01 09 44 2b 00 01 0a 45 1a 0b', '{"a":233,"b":[1,2,3,4,5],"c":"💩👨‍👩‍👦‍👦🤦🏻‍♂️","d":[{"x":"🐠⭐","y":555,"z":""},{"x":"🗡️1༆苍༒白","y":666,"z":""}]}');

console.log("通过测试：" + 通过测试 + "，不通过测试：" + 不通过测试);


console.log(Compact.decode(Compact.encode({ a: 1, b: "2", c: ["啦啦啦"] },/*不指定类型就自动填充*/)));

interface Hero {
    id: number;
    name: string;
    atk: number[],
    def: number[]
}
interface Enemy {
    id: number;
    name: string;
    desc: string;
}
const datas: {
    version: number;
    heros: Hero[],
    enemies: Enemy[]
} = {
    version: 1234,
    heros: [],
    enemies: []
};
let i: number = 10000;
while (i--) {
    datas.heros[i] = {
        id: 100001 + i,
        name: "男/女主",
        atk: [(Math.random() * 10000 >> 0) / 100, (Math.random() * 10000 >> 0) / 100],
        def: [(Math.random() * 10000 >> 0) / 100, (Math.random() * 10000 >> 0) / 100]
    };
    datas.enemies[i] = {
        id: 200001 + i,
        name: "敌人",
        desc: "这家伙很懒没写说明",
    };
}
const json1 = Utils.tryStringify(datas);
console.log("json：" + (json1.length / (1024 * 1024)).toFixed(2) + "M");
Timer.start("json 转 datas");
JSON.parse(json1);
Timer.stop("json 转 datas");

//精确指定类型：
const types: (string | 0 | 7)[] = ["dict"];//datas
types.push("version", "int")//datas 的 version 字段

types.push("heros", "arr");
types.push("dict");
types.push("id", "int");
types.push("name", "string");
types.push("atk", "arr", "float", 0);
types.push("def", "arr", "float", 0);
types.push(0);//标记 dict 结束
types.push(0);//标记 arr 结束

types.push("enemies", "arr");
types.push("dict");
types.push("id", "int");
types.push("name", "string");
types.push("desc", "string");
types.push(0);//标记 dict 结束
types.push(0);//标记 arr 结束

const bytes = Compact.encode(datas, types);
console.log("bytes：" + (bytes.length / (1024 * 1024)).toFixed(2) + "M");
Timer.start("bytes 转 datas");
const datas2 = Compact.decode(bytes);
Timer.stop("bytes 转 datas");
const json2 = Utils.tryStringify(datas2);
if (json1 == json2) {
    console.log("数据一致！");
} else {
    console.error("数据不一致！");
}
// console.log(json1);
// console.log(json2);