package org.cocos2dx.lua;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebViewPay {
    private WebView mWebView;
    private Activity act;
    private Context mContext;
    private String mReferer;
    private boolean isOpen;
    public String payUrl = "";

    public WebViewPay(Activity activity, Context context) {
        initVebView(activity);
        act = activity;
        mContext = context;
    }

    private void initVebView(Activity activity) {
        if (activity == null) {
            return;
        }
        mWebView = new WebView(activity);
        WebSettings settings = mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        // 适应屏幕
        settings.setUseWideViewPort(true);
        // 解决图片不显示
        settings.setBlockNetworkImage(false);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            settings.setMixedContentMode(WebSettings.LOAD_NORMAL);
        }
        settings.setLoadWithOverviewMode(true);
        settings.setDomStorageEnabled(true);
        settings.setAppCacheMaxSize(1024 * 1024 * 8);
        String appCachePath = AppInterface.getActivity().getContext().getCacheDir().getAbsolutePath();
        settings.setAppCachePath(appCachePath);
        settings.setAllowFileAccess(true);
        settings.setAppCacheEnabled(true);
        settings.setLoadsImagesAutomatically(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        settings.setGeolocationEnabled(true);
        settings.setSaveFormData(true);
        settings.setSavePassword(true);
        CookieManager.getInstance().setAcceptCookie(true);
        settings.setSupportZoom(true);
        settings.setBuiltInZoomControls(true);
        settings.setDisplayZoomControls(false);
        settings.setSupportMultipleWindows(false);
        settings.setEnableSmoothTransition(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setDatabaseEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);

        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Log.e("pay", "收到webview回调 url-->" + url);
                if (isWeiXinUrl(url) && !isOpen) {
                    if (isWeixinAvilible(mContext)) {
                        JumpToPay(url);
                    } else {
                        Log.i("pay", "微信未安装,请先安装微信");
                        Toast.makeText(act, "微信未安装,请先安装微信", Toast.LENGTH_LONG).show();
                    }
                    isOpen = true;
                    return true;
                } else if (isAlipaysUrl(url) && !isOpen) {
                    if (isAliPayInstalled()) {
                        JumpToPay(url);
                    } else {
                        openBrowToPay(payUrl);
                    }
                    isOpen = true;
                    return true;
                }

                Uri uri = Uri.parse(url);
                // 返回值是true的时候控制去WebView打开，为false调用系统浏览器或第三方浏览器
                Map<String, String> extraHeaders = new HashMap<>();
                extraHeaders.put("Referer", mReferer);
                view.loadUrl(url, extraHeaders);
                // 取上一次的rdferer头需要在最后处理；
                mReferer = uri.getScheme() + "://" + uri.getHost();
                Log.e("pay", "url-->" + mReferer);

                return false;
            }
        });
    }

    // 跳转到微信/支付宝支付
    public void JumpToPay(String url) {
        try {
            Log.e("pay", "直接跳转微信/支付宝");
            Intent intent = new Intent();
            intent.setAction(Intent.ACTION_VIEW);
            Uri content_url = Uri.parse(url);
            intent.setData(content_url);
            AppInterface.getActivity().startActivity(intent);
        } catch (Exception e) {
            Log.e("pay", "直接跳转微信/支付宝 异常");
            e.printStackTrace();
        }
    }

    // 打开浏览器支付
    public void openBrowToPay(String url) {
        try {
            Log.e("pay", "打开浏览器支付");
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");// 打开手机自带浏览器
            intent.setData(Uri.parse(url));// 设置
            AppInterface.getActivity().startActivity(intent);
        } catch (Exception e) {
            Log.e("pay", "打开浏览器支付 异常");
            e.printStackTrace();
        }
    }

    public static boolean isAliPayInstalled() {
        Uri uri = Uri.parse("alipays://platformapi/startApp");
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        ComponentName componentName = intent.resolveActivity(AppInterface.getActivity().getPackageManager());
        return componentName != null;
    }

    public void loadUrl(String url) {
        if (!TextUtils.isEmpty(url) && mWebView != null) {
            isOpen = false;
            payUrl = url;
            mWebView.loadUrl(url);
        }
    }

    private boolean isOpenScheme(String url) {
        if (TextUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("alipays://") || url.startsWith("weixin://");
    }

    public static boolean isHttp(String url) {
        if (TextUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("http://") || url.startsWith("https://");
    }

    public static boolean isWeiXinUrl(String url) {
        if (TextUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("weixin://");
    }

    public static boolean isAlipaysUrl(String url) {
        if (TextUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("alipays://");
    }

    /**
     * 检测是否安装支付宝
     * 
     * @return * @param context
     */
    public static boolean checkAliPayInstalled(Context context) {
        Uri uri = Uri.parse("alipays://platformapi/startApp");
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        ComponentName componentName = intent.resolveActivity(context.getPackageManager());
        boolean isInstall = componentName != null;
        Log.i("pay", "支付宝是否安装=" + isInstall);
        return isInstall;
    }

    /**
     * 判断 用户是否安装微信客户端
     */
    public static boolean isWeixinAvilible(Context context) {
        final PackageManager packageManager = context.getPackageManager(); // 获取packagemanager
        List<PackageInfo> pinfo = packageManager.getInstalledPackages(0);// 获取所有已安装程序的包信息
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); i++) {
                String pn = pinfo.get(i).packageName;
                if (pn.equals("com.tencent.mm")) {
                    Log.i("pay", "微信已安装");
                    return true;
                }
            }
        }
        return false;
    }

    public void destroy() {
        mWebView.destroy();
        mWebView = null;
    }

}