
import { _decorator, Component, Node, Collider2D, EventTouch, Vec2, UITransform, v3, tween, find, Animation, Vec3, log, Tween, Contact2DType, BoxCollider2D, IPhysics2DContact } from 'cc';

const { ccclass, property } = _decorator;

@ccclass('ToolsDrag')
export class ToolsDrag extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    canvas: Node = null;

    StartPos: Vec3 = new Vec3();
    collider: Collider2D = null;

    isDrag: boolean = false;
    @property
    DragIndex: number = 0;

    onLoad() {
        this.canvas = find("Canvas");
        this.StartPos = v3(this.node.position);
        this.collider = this.node.getComponent(Collider2D);
        this.node.on(Node.EventType.TOUCH_START, this.Tool_Start, this);
        this.node.on(Node.EventType.TOUCH_MOVE, this.Tool_Move, this);
        this.node.on(Node.EventType.TOUCH_END, this.Tool_End, this);
        this.node.on(Node.EventType.TOUCH_CANCEL, this.Tool_End, this);

        if (this.collider) {
            this.collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            // this.collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
            // this.collider.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
            // this.collider.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
        }
    }

    start() {
        // [3]

    }

    update(deltaTime: number) {
        // [4]
        //log(this.StartPos)
    }

    Tool_Start(event: EventTouch) {

        Tween.stopAllByTarget(this.node);
        //this.node.getComponent(Animation).stop();
        tween(this.node).to(0.2, { scale: v3(1, 1) }).start();
        let posV2: Vec2 = event.getUILocation();
        let posV3 = this.canvas.getComponent(UITransform).convertToNodeSpaceAR(v3(posV2.x, posV2.y));
        this.node.setPosition(posV3);
        //Event_Mgr.emit(EventDefine.Tool_Start, this.DragIndex);
    }

    Tool_Move(event: EventTouch) {

        let posV2: Vec2 = event.getUILocation();
        let posV3 = this.canvas.getComponent(UITransform).convertToNodeSpaceAR(v3(posV2.x, posV2.y));
        this.node.setPosition(posV3);
    }

    Tool_End(event: EventTouch) {

        Tween.stopAllByTarget(this.node);
        tween(this.node).to(0.5, { position: this.StartPos, scale: v3(0.8, 0.8) }).call(() => {
            //this.node.getComponent(Animation).play();
            //Event_Mgr.emit(EventDefine.Tool_End);
        }).start();
        //this.node.getComponent(Animation).play();
        //Event_Mgr.emit(EventDefine.Tool_End, this.DragIndex);
    }


    onBeginContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体开始接触时被调用一次
        console.log('onBeginContact');
        if (otherCollider.group == 2) {
            this.node.active = false;
            //Event_Mgr.emit(EventDefine.Tool_Event, this.node.name);
        }
    }

    onEndContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体结束接触时被调用一次
        console.log('onEndContact');
    }
    onPreSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次将要处理碰撞体接触逻辑时被调用
        console.log('onPreSolve');
    }
    onPostSolve(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次处理完碰撞体接触逻辑时被调用
        console.log('onPostSolve');
    }
}

