import FruitsGame, { FruitType } from "./FruitsGame";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Fruits extends cc.Component {
    private _fruitsType: FruitType = FruitType.草莓
    private rigidBody: cc.RigidBody = null
    @property(FruitsGame)
    fruitsGame: FruitsGame = null

    onLoad() {
    }

    start() {
    }

    private onBeginContact(contact: cc.PhysicsCollider, selfCollider: cc.PhysicsCollider, otherCollider: cc.PhysicsCollider) {
        cc.log("触发碰撞")
        if (otherCollider.tag == 0) {
            // this.rigidBody.linearVelocity = cc.v2(0, 0);
        } else if (otherCollider.tag == this.fruitsType) {
            cc.log("需要合成！")
            let B = otherCollider.node.position
            let A = selfCollider.node.position
            let pos = cc.v3((A.x + B.x) / 2, (A.y + B.y) / 2)
            // otherCollider.enabled =false
            // selfCollider.enabled =false
            selfCollider.node.name = "one"
            otherCollider.node.name = "two"
            this.fruitsGame.recovery(otherCollider.node)//cc.NodePool回收
            this.fruitsGame.recovery(selfCollider.node)//cc.NodePool回收
            // this.fruitsGame.createFruits(this.fruitsType += 1, pos)//再次创建  会报错
        }

    }



    onEndContact(contact: cc.PhysicsContact, selfCollider: cc.PhysicsCollider, otherCollider: cc.PhysicsCollider) {              //碰撞则播放爆炸动画
        // cc.log(contact)
        // cc.log(selfCollider)
        // cc.log(otherCollider)

    }


    // // 只在两个碰撞体结束接触时被调用一次
    // onEndContact(contact, selfCollider, otherCollider) {
    // }


    public set fruitsType(type: any) {
        this._fruitsType = type
        this.rigidBody = this.getComponent(cc.RigidBody)
        this.getComponent(cc.PhysicsCollider).tag = type

        cc.log(this.getComponent(cc.PhysicsCollider).enabledInHierarchy)
        this.node.scale = 1 + 0.1 * type
        this.rigidBody.linearVelocity = cc.v2(0, -500);
    }


    public get fruitsType() {
        return this._fruitsType
    }





    // update (dt) {}
}
