import Fruits from "./Fruits";

export enum FruitType {
    草莓 = 1,
    橘子,
    苹果,
    火龙果,
    哈密瓜,
    西瓜,
}


const { ccclass, property } = cc._decorator;
@ccclass
export default class FruitsGame extends cc.Component {

    @property(cc.Node)
    top_fruits: cc.Node = null;
    @property(cc.Node)
    cloneFruits: cc.Node = null;

    nodePool: cc.NodePool = null;

    onLoad() {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getCollisionManager().enabledDebugDraw = true;

        this.top_fruits.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this)
        this.top_fruits.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this)
        this.top_fruits.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this)


        this.nodePool = new cc.NodePool()
        for (let i = 0; i < 20; i++) {
            this.nodePool.put(cc.instantiate(this.cloneFruits))
        }
    }
    createFruits(type: FruitType, position) {
        let fruits = null
        if (this.nodePool.size() > 0) {
            fruits = this.nodePool.get()
        } else {
            fruits = cc.instantiate(this.cloneFruits)
        }
        this.node.addChild(fruits)
        fruits.position = position
        fruits.getComponent(Fruits).fruitsType = type
        cc.log("生成的是",fruits)
        return fruits
    }



    private onTouchStart() {

    }
    private onTouchMove(event: cc.Event.EventTouch) {
        let movePos = event.target.parent.convertToNodeSpaceAR(event.getLocation())
        // cc.log(movePos)
        let critical = cc.winSize.width / 2 - this.top_fruits.width / 2
        if (movePos.x > critical) {
            movePos.x = critical
        }
        if (movePos.x < - critical) {
            movePos.x = -critical
        }
        this.top_fruits.position = cc.v3(movePos.x, this.top_fruits.y)
    }
    private onTouchEnd() {
        this.createFruits(FruitType.草莓, this.top_fruits.position)
    }
    /**回收 */
    public recovery(node: cc.Node) {
        if (node) {
            // node.getComponent(cc.RigidBody).linearVelocity = cc.v2(0,0)
            this.nodePool.put(node)
        }
    }




    start() {

    }


    // update (dt) {}
}
