export enum CollisionType {
    None,
    CollisionEnter,
    CollisionStay,
    CollisionExit,
}
export class CollisionManagerEX {
    private static _instance: CollisionManagerEX = null;

    public static getInstance(): CollisionManagerEX {
        if (this._instance == null) {
            this._instance = new CollisionManagerEX();
        }
        return this._instance;
    }

    /**
     * 获取原版物理引擎的所有添加碰撞体的组件(不用手动删除,添加,creator自己管理)
     */
    getColliders() {
        return cc.director.getCollisionManager()._colliders;
    }

    getDebugDrawer() {
        return cc.director.getCollisionManager()._debugDrawer;

    }

    getEnabledDebugDraw() {
        return cc.director.getCollisionManager()._enabledDebugDraw;

    }

    check(collider: cc.Collider, oldContacts: [cc.Collider]) {
        const { retrieve, contacts } = globalThis.App.QuadtreeTest._quadCollision.check(cc.director.getCollisionManager()._colliders, collider); // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        for (let index = 0; index < contacts.length; index++) {
            const itemCollider = contacts[index];
            if (oldContacts.indexOf(itemCollider) != -1) {
                let contact = {
                    collider1: collider,
                    collider2: itemCollider
                }
                this._doCollide(CollisionType.CollisionStay, contact);
            } else { //之前没有
                let contact = {
                    collider1: collider,
                    collider2: itemCollider
                }
                this._doCollide(CollisionType.CollisionEnter, contact);
            }
        }
        for (let index = 0; index < oldContacts.length; index++) {
            const oldContact = oldContacts[index];
            if (contacts.indexOf(oldContact) == -1) {
                let contact = {
                    collider1: collider,
                    collider2: oldContact
                }
                this._doCollide(CollisionType.CollisionExit, contact);
            }
        }
        return { retrieve, contacts };
    }

    _doCollide(collisionType, contact) {
        let contactFunc;
        switch (collisionType) {
            case CollisionType.CollisionEnter:
                contactFunc = 'onCollisionEnter';
                break;
            case CollisionType.CollisionStay:
                contactFunc = 'onCollisionStay';
                break;
            case CollisionType.CollisionExit:
                contactFunc = 'onCollisionExit';
                break;
        }

        let collider1 = contact.collider1;
        let collider2 = contact.collider2;

        let comps1 = collider1.node._components;
        let comps2 = collider2.node._components;

        let i, l, comp;
        for (i = 0, l = comps1.length; i < l; i++) {
            comp = comps1[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider2, collider1);
            }
        }

        for (i = 0, l = comps2.length; i < l; i++) {
            comp = comps2[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider1, collider2);
            }
        }
    }


}