// author: http://lamyoung.com/

import { CollisionManagerEX } from "./CollisionManager";
import QuadtreeCollision from "./QuadtreeCollision";

const { ccclass, property } = cc._decorator;

@ccclass
export default class QuadtreeTest extends cc.Component {
    @property(cc.Collider)
    collider_role: cc.Collider = null;

    @property(cc.Prefab)
    collider_prefabs: cc.Prefab[] = [];

    @property(cc.Boolean)
    use_quadtree: Boolean = false;

    @property(cc.Integer)
    random_collider_size: Number = 0;

    private _all_collider: cc.Collider[] = [];
    private _quadCollision: QuadtreeCollision;

    createRandomCollider() {
        for (let i = 0; i < this.random_collider_size; ++i) {
            let node = cc.instantiate(this.collider_prefabs[Math.floor(Math.random() * 3)]);
            node.x = Math.random() * this.node.width - this.node.width / 2;
            node.y = Math.random() * this.node.height - this.node.height / 2;
            node.angle = Math.random() * 360;
            node.opacity = 30;
            node.parent = this.node;
        }
    }

    onLoad() {
        globalThis.App = {};
        globalThis.App.CollisionManagerEX = CollisionManagerEX.getInstance();

        this.createRandomCollider();
        if (this.use_quadtree) {
            cc.director.getCollisionManager().enabled = false; // 必须关闭原版物理引擎
            this._quadCollision = new QuadtreeCollision(this.node.getBoundingBoxToWorld()); // 初始化四叉树全局范围大小rect
            this._all_collider = this.node.getComponentsInChildren(cc.Collider); // 获取所有的碰撞体
        } else {
            cc.director.getCollisionManager().enabled = true;
        }
        globalThis.App.QuadtreeTest = this;

    }

    start() {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    }

    private onTouchMove(evt: cc.Touch) {
        const pos = this.collider_role.node.parent.convertToNodeSpaceAR(evt.getLocation());
        this.collider_role.node.x = pos.x;
        this.collider_role.node.y = pos.y;
    }

    lateUpdate() {
        // if (this.use_quadtree) {
        //     const { retrieve, contacts } = this._quadCollision.check(this._all_collider, this.collider_role); // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        //     // retrieve 准备测试的对象(预览图中的绿色)   cc.Collider[]
        //     // contacts 碰撞对象(预览图中的红色)   cc.Collider[]
        //     this._all_collider.forEach(c => c.node.color = cc.Color.WHITE);
        //     retrieve.forEach(c => c.node.color = cc.Color.GREEN);
        //     contacts.forEach(c => c.node.color = cc.Color.RED);
        // }
    }
}
