const { ccclass, property } = cc._decorator;

@ccclass
export default class Role extends cc.Component {
    private _all_collider: [];
    private _old_all_collider: [];
    collider: cc.BoxCollider;
    // 旧碰撞检测进入回调
    private onCollisionEnter(other, self) {
        // ...
        console.log('进入碰撞');

    }

    // // 新四叉树碰撞检测接触回调
    // private onQuadtreeCollisionContacts(other, self) {
    //     this.onCollisionEnter(other, self); // 转发旧回调函数即可
    // }


    onCollisionStay(other, self) {
        console.log('保持碰撞');
    }

    onCollisionExit(other, self) {
        console.log('退出碰撞');
    }

    onLoad() {
        this.collider = this.node.getComponent(cc.BoxCollider)
    }

    update(dt: number) {
        if(!this._old_all_collider) this._old_all_collider = [];
        const { retrieve, contacts } = globalThis.App.CollisionManagerEX.check(this.collider, this._old_all_collider);
        this._old_all_collider = contacts;
    }
}
