"use strict";
cc._RF.push(module, '5b1a19HSpJPK4FpoG3YPSYE', 'CollisionManager');
// src/CollisionManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CollisionManagerEX = exports.CollisionType = void 0;
var CollisionType;
(function (CollisionType) {
    CollisionType[CollisionType["None"] = 0] = "None";
    CollisionType[CollisionType["CollisionEnter"] = 1] = "CollisionEnter";
    CollisionType[CollisionType["CollisionStay"] = 2] = "CollisionStay";
    CollisionType[CollisionType["CollisionExit"] = 3] = "CollisionExit";
})(CollisionType = exports.CollisionType || (exports.CollisionType = {}));
var CollisionManagerEX = /** @class */ (function () {
    function CollisionManagerEX() {
    }
    CollisionManagerEX.getInstance = function () {
        if (this._instance == null) {
            this._instance = new CollisionManagerEX();
        }
        return this._instance;
    };
    /**
     * 获取原版物理引擎的所有添加碰撞体的组件(不用手动删除,添加,creator自己管理)
     */
    CollisionManagerEX.prototype.getColliders = function () {
        return cc.director.getCollisionManager()._colliders;
    };
    CollisionManagerEX.prototype.getDebugDrawer = function () {
        return cc.director.getCollisionManager()._debugDrawer;
    };
    CollisionManagerEX.prototype.getEnabledDebugDraw = function () {
        return cc.director.getCollisionManager()._enabledDebugDraw;
    };
    CollisionManagerEX.prototype.check = function (collider, oldContacts) {
        var _a = globalThis.App.QuadtreeTest._quadCollision.check(cc.director.getCollisionManager()._colliders, collider), retrieve = _a.retrieve, contacts = _a.contacts; // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        for (var index = 0; index < contacts.length; index++) {
            var itemCollider = contacts[index];
            if (oldContacts.indexOf(itemCollider) != -1) {
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionStay, contact);
            }
            else { //之前没有
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionEnter, contact);
            }
        }
        for (var index = 0; index < oldContacts.length; index++) {
            var oldContact = oldContacts[index];
            if (contacts.indexOf(oldContact) == -1) {
                var contact = {
                    collider1: collider,
                    collider2: oldContact
                };
                this._doCollide(CollisionType.CollisionExit, contact);
            }
        }
        return { retrieve: retrieve, contacts: contacts };
    };
    CollisionManagerEX.prototype._doCollide = function (collisionType, contact) {
        var contactFunc;
        switch (collisionType) {
            case CollisionType.CollisionEnter:
                contactFunc = 'onCollisionEnter';
                break;
            case CollisionType.CollisionStay:
                contactFunc = 'onCollisionStay';
                break;
            case CollisionType.CollisionExit:
                contactFunc = 'onCollisionExit';
                break;
        }
        var collider1 = contact.collider1;
        var collider2 = contact.collider2;
        var comps1 = collider1.node._components;
        var comps2 = collider2.node._components;
        var i, l, comp;
        for (i = 0, l = comps1.length; i < l; i++) {
            comp = comps1[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider2, collider1);
            }
        }
        for (i = 0, l = comps2.length; i < l; i++) {
            comp = comps2[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider1, collider2);
            }
        }
    };
    CollisionManagerEX._instance = null;
    return CollisionManagerEX;
}());
exports.CollisionManagerEX = CollisionManagerEX;

cc._RF.pop();