"use strict";
cc._RF.push(module, '91ca2XTzsdNMbLOGhBKtSdw', 'QuadtreeTest');
// src/QuadtreeTest.ts

"use strict";
// author: http://lamyoung.com/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var CollisionManager_1 = require("./CollisionManager");
var QuadtreeCollision_1 = require("./QuadtreeCollision");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var QuadtreeTest = /** @class */ (function (_super) {
    __extends(QuadtreeTest, _super);
    function QuadtreeTest() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collider_role = null;
        _this.collider_prefabs = [];
        _this.use_quadtree = false;
        _this.random_collider_size = 0;
        _this._all_collider = [];
        return _this;
    }
    QuadtreeTest.prototype.createRandomCollider = function () {
        for (var i = 0; i < this.random_collider_size; ++i) {
            var node = cc.instantiate(this.collider_prefabs[Math.floor(Math.random() * 3)]);
            node.x = Math.random() * this.node.width - this.node.width / 2;
            node.y = Math.random() * this.node.height - this.node.height / 2;
            node.angle = Math.random() * 360;
            node.opacity = 30;
            node.parent = this.node;
        }
    };
    QuadtreeTest.prototype.onLoad = function () {
        globalThis.App = {};
        globalThis.App.CollisionManagerEX = CollisionManager_1.CollisionManagerEX.getInstance();
        this.createRandomCollider();
        if (this.use_quadtree) {
            cc.director.getCollisionManager().enabled = false; // 必须关闭原版物理引擎
            this._quadCollision = new QuadtreeCollision_1.default(this.node.getBoundingBoxToWorld()); // 初始化四叉树全局范围大小rect
            this._all_collider = this.node.getComponentsInChildren(cc.Collider); // 获取所有的碰撞体
        }
        else {
            cc.director.getCollisionManager().enabled = true;
        }
        globalThis.App.QuadtreeTest = this;
    };
    QuadtreeTest.prototype.start = function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    QuadtreeTest.prototype.onTouchMove = function (evt) {
        var pos = this.collider_role.node.parent.convertToNodeSpaceAR(evt.getLocation());
        this.collider_role.node.x = pos.x;
        this.collider_role.node.y = pos.y;
    };
    QuadtreeTest.prototype.lateUpdate = function () {
        // if (this.use_quadtree) {
        //     const { retrieve, contacts } = this._quadCollision.check(this._all_collider, this.collider_role); // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        //     // retrieve 准备测试的对象(预览图中的绿色)   cc.Collider[]
        //     // contacts 碰撞对象(预览图中的红色)   cc.Collider[]
        //     this._all_collider.forEach(c => c.node.color = cc.Color.WHITE);
        //     retrieve.forEach(c => c.node.color = cc.Color.GREEN);
        //     contacts.forEach(c => c.node.color = cc.Color.RED);
        // }
    };
    __decorate([
        property(cc.Collider)
    ], QuadtreeTest.prototype, "collider_role", void 0);
    __decorate([
        property(cc.Prefab)
    ], QuadtreeTest.prototype, "collider_prefabs", void 0);
    __decorate([
        property(cc.Boolean)
    ], QuadtreeTest.prototype, "use_quadtree", void 0);
    __decorate([
        property(cc.Integer)
    ], QuadtreeTest.prototype, "random_collider_size", void 0);
    QuadtreeTest = __decorate([
        ccclass
    ], QuadtreeTest);
    return QuadtreeTest;
}(cc.Component));
exports.default = QuadtreeTest;

cc._RF.pop();