
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/__qc_index__.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}
require('./assets/src/CollisionManager');
require('./assets/src/QuadtreeCollision');
require('./assets/src/QuadtreeTest');
require('./assets/src/Role');
require('./assets/src/UseQuadtreeCollisoion');

                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/QuadtreeCollision.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '720406PXFBA0L0VTjPP9Yhj', 'QuadtreeCollision');
// src/QuadtreeCollision.ts

"use strict";
// author: http://lamyoung.com/
Object.defineProperty(exports, "__esModule", { value: true });
var QuadtreeCollision = /** @class */ (function () {
    function QuadtreeCollision(rect) {
        this._tree = new Quadtree(rect);
    }
    QuadtreeCollision.prototype.check = function (colliders, testCollider) {
        var ret = { retrieve: [], contacts: [] };
        if (this._tree) {
            // 四叉树清理
            this._tree.clear();
            var collisionManager = cc.director.getCollisionManager();
            collisionManager['updateCollider'](testCollider);
            for (var i = 0, l = colliders.length; i < l; i++) {
                var collider = colliders[i];
                // 更新碰撞体世界aabb
                collisionManager['updateCollider'](collider);
                var aabb = collider['world'].aabb;
                var rect = { x: aabb.x, y: aabb.y, height: aabb.height, width: aabb.width, collider: collider };
                // 四叉树插入
                this._tree.insert(rect);
            }
            // 四叉树抓出待检查的对象(属于那个块的所有节点)
            var retrieveObjects = this._tree.retrieve(testCollider['world'].aabb);
            retrieveObjects.forEach(function (element) {
                ret.retrieve.push();
                // 抓出来后检查碰撞
                if (testContact(element.collider, testCollider)) {
                    ret.contacts.push(element.collider);
                    // 相互执行碰撞函数
                    for (var _i = 0, _a = testCollider.node._components; _i < _a.length; _i++) {
                        var c = _a[_i];
                        if (c.onQuadtreeCollisionContacts) {
                            c.onQuadtreeCollisionContacts(element.collider, testCollider);
                        }
                    }
                    for (var _b = 0, _c = element.collider.node._components; _b < _c.length; _b++) {
                        var c = _c[_b];
                        if (c.onQuadtreeCollisionContacts) {
                            c.onQuadtreeCollisionContacts(testCollider, element.collider);
                        }
                    }
                }
            });
        }
        return ret;
    };
    return QuadtreeCollision;
}());
exports.default = QuadtreeCollision;
// 欢迎关注微信公众号[白玉无冰]
function testContact(collider1, collider2) {
    // 分组不通过
    if (!cc.director.getCollisionManager()['shouldCollide'](collider1, collider2)) {
        return false;
    }
    var world1 = collider1.world;
    var world2 = collider2.world;
    if (!world1.aabb.intersects(world2.aabb)) {
        return false;
    }
    var isCollider1Polygon = (collider1 instanceof cc.BoxCollider) || (collider1 instanceof cc.PolygonCollider);
    var isCollider2Polygon = (collider2 instanceof cc.BoxCollider) || (collider2 instanceof cc.PolygonCollider);
    var isCollider1Circle = collider1 instanceof cc.CircleCollider;
    var isCollider2Circle = collider2 instanceof cc.CircleCollider;
    if (isCollider1Polygon && isCollider2Polygon) {
        return cc.Intersection.polygonPolygon(world1.points, world2.points);
    }
    else if (isCollider1Circle && isCollider2Circle) {
        return cc.Intersection.circleCircle(world1, world2);
    }
    else if (isCollider1Polygon && isCollider2Circle) {
        return cc.Intersection.polygonCircle(world1.points, world2);
    }
    else if (isCollider1Circle && isCollider2Polygon) {
        return cc.Intersection.polygonCircle(world2.points, world1);
    }
    else {
        // cc.errorID(6601, cc.js.getClassName(collider1), cc.js.getClassName(collider2));
    }
    return false;
}
/**
 * quadtree-js
 * @version 1.2.2
 * @license MIT
 * @author Timo Hausmann
 */
/* https://github.com/timohausmann/quadtree-js.git v1.2.2 */
/**
     * Quadtree Constructor
     * @param Object bounds            bounds of the node { x, y, width, height }
     * @param Integer max_objects      (optional) max objects a node can hold before splitting into 4 subnodes (default: 10)
     * @param Integer max_levels       (optional) total max levels inside root Quadtree (default: 4)
     * @param Integer level            (optional) deepth level, required for subnodes (default: 0)
     */
function Quadtree(bounds, max_objects, max_levels, level) {
    this.max_objects = max_objects || 10;
    this.max_levels = max_levels || 4;
    this.level = level || 0;
    this.bounds = bounds;
    this.objects = [];
    this.nodes = [];
}
;
/**
 * Split the node into 4 subnodes
 */
Quadtree.prototype.split = function () {
    var nextLevel = this.level + 1, subWidth = this.bounds.width / 2, subHeight = this.bounds.height / 2, x = this.bounds.x, y = this.bounds.y;
    //top right node
    this.nodes[0] = new Quadtree({
        x: x + subWidth,
        y: y,
        width: subWidth,
        height: subHeight
    }, this.max_objects, this.max_levels, nextLevel);
    //top left node
    this.nodes[1] = new Quadtree({
        x: x,
        y: y,
        width: subWidth,
        height: subHeight
    }, this.max_objects, this.max_levels, nextLevel);
    //bottom left node
    this.nodes[2] = new Quadtree({
        x: x,
        y: y + subHeight,
        width: subWidth,
        height: subHeight
    }, this.max_objects, this.max_levels, nextLevel);
    //bottom right node
    this.nodes[3] = new Quadtree({
        x: x + subWidth,
        y: y + subHeight,
        width: subWidth,
        height: subHeight
    }, this.max_objects, this.max_levels, nextLevel);
};
/**
 * Determine which node the object belongs to
 * @param Object pRect      bounds of the area to be checked, with x, y, width, height
 * @return Array            an array of indexes of the intersecting subnodes
 *                          (0-3 = top-right, top-left, bottom-left, bottom-right / ne, nw, sw, se)
 */
Quadtree.prototype.getIndex = function (pRect) {
    var indexes = [], verticalMidpoint = this.bounds.x + (this.bounds.width / 2), horizontalMidpoint = this.bounds.y + (this.bounds.height / 2);
    var startIsNorth = pRect.y < horizontalMidpoint, startIsWest = pRect.x < verticalMidpoint, endIsEast = pRect.x + pRect.width > verticalMidpoint, endIsSouth = pRect.y + pRect.height > horizontalMidpoint;
    //top-right quad
    if (startIsNorth && endIsEast) {
        indexes.push(0);
    }
    //top-left quad
    if (startIsWest && startIsNorth) {
        indexes.push(1);
    }
    //bottom-left quad
    if (startIsWest && endIsSouth) {
        indexes.push(2);
    }
    //bottom-right quad
    if (endIsEast && endIsSouth) {
        indexes.push(3);
    }
    return indexes;
};
/**
 * Insert the object into the node. If the node
 * exceeds the capacity, it will split and add all
 * objects to their corresponding subnodes.
 * @param Object pRect        bounds of the object to be added { x, y, width, height }
 */
Quadtree.prototype.insert = function (pRect) {
    var i = 0, indexes;
    //if we have subnodes, call insert on matching subnodes
    if (this.nodes.length) {
        indexes = this.getIndex(pRect);
        for (i = 0; i < indexes.length; i++) {
            this.nodes[indexes[i]].insert(pRect);
        }
        return;
    }
    //otherwise, store object here
    this.objects.push(pRect);
    //max_objects reached
    if (this.objects.length > this.max_objects && this.level < this.max_levels) {
        //split if we don't already have subnodes
        if (!this.nodes.length) {
            this.split();
        }
        //add all objects to their corresponding subnode
        for (i = 0; i < this.objects.length; i++) {
            indexes = this.getIndex(this.objects[i]);
            for (var k = 0; k < indexes.length; k++) {
                this.nodes[indexes[k]].insert(this.objects[i]);
            }
        }
        //clean up this node
        this.objects = [];
    }
};
/**
 * Return all objects that could collide with the given object
 * @param Object pRect      bounds of the object to be checked { x, y, width, height }
 * @Return Array            array with all detected objects
 */
Quadtree.prototype.retrieve = function (pRect) {
    var indexes = this.getIndex(pRect), returnObjects = this.objects;
    //if we have subnodes, retrieve their objects
    if (this.nodes.length) {
        for (var i = 0; i < indexes.length; i++) {
            returnObjects = returnObjects.concat(this.nodes[indexes[i]].retrieve(pRect));
        }
    }
    //remove duplicates
    returnObjects = returnObjects.filter(function (item, index) {
        return returnObjects.indexOf(item) >= index;
    });
    return returnObjects;
};
/**
 * Clear the quadtree
 */
Quadtree.prototype.clear = function () {
    this.objects = [];
    for (var i = 0; i < this.nodes.length; i++) {
        if (this.nodes.length) {
            this.nodes[i].clear();
        }
    }
    this.nodes = [];
};

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/QuadtreeTest.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '91ca2XTzsdNMbLOGhBKtSdw', 'QuadtreeTest');
// src/QuadtreeTest.ts

"use strict";
// author: http://lamyoung.com/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var CollisionManager_1 = require("./CollisionManager");
var QuadtreeCollision_1 = require("./QuadtreeCollision");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var QuadtreeTest = /** @class */ (function (_super) {
    __extends(QuadtreeTest, _super);
    function QuadtreeTest() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collider_role = null;
        _this.collider_prefabs = [];
        _this.use_quadtree = false;
        _this.random_collider_size = 0;
        _this._all_collider = [];
        return _this;
    }
    QuadtreeTest.prototype.createRandomCollider = function () {
        for (var i = 0; i < this.random_collider_size; ++i) {
            var node = cc.instantiate(this.collider_prefabs[Math.floor(Math.random() * 3)]);
            node.x = Math.random() * this.node.width - this.node.width / 2;
            node.y = Math.random() * this.node.height - this.node.height / 2;
            node.angle = Math.random() * 360;
            node.opacity = 30;
            node.parent = this.node;
        }
    };
    QuadtreeTest.prototype.onLoad = function () {
        globalThis.App = {};
        globalThis.App.CollisionManagerEX = CollisionManager_1.CollisionManagerEX.getInstance();
        this.createRandomCollider();
        if (this.use_quadtree) {
            cc.director.getCollisionManager().enabled = false; // 必须关闭原版物理引擎
            this._quadCollision = new QuadtreeCollision_1.default(this.node.getBoundingBoxToWorld()); // 初始化四叉树全局范围大小rect
            this._all_collider = this.node.getComponentsInChildren(cc.Collider); // 获取所有的碰撞体
        }
        else {
            cc.director.getCollisionManager().enabled = true;
        }
        globalThis.App.QuadtreeTest = this;
    };
    QuadtreeTest.prototype.start = function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    QuadtreeTest.prototype.onTouchMove = function (evt) {
        var pos = this.collider_role.node.parent.convertToNodeSpaceAR(evt.getLocation());
        this.collider_role.node.x = pos.x;
        this.collider_role.node.y = pos.y;
    };
    QuadtreeTest.prototype.lateUpdate = function () {
        // if (this.use_quadtree) {
        //     const { retrieve, contacts } = this._quadCollision.check(this._all_collider, this.collider_role); // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        //     // retrieve 准备测试的对象(预览图中的绿色)   cc.Collider[]
        //     // contacts 碰撞对象(预览图中的红色)   cc.Collider[]
        //     this._all_collider.forEach(c => c.node.color = cc.Color.WHITE);
        //     retrieve.forEach(c => c.node.color = cc.Color.GREEN);
        //     contacts.forEach(c => c.node.color = cc.Color.RED);
        // }
    };
    __decorate([
        property(cc.Collider)
    ], QuadtreeTest.prototype, "collider_role", void 0);
    __decorate([
        property(cc.Prefab)
    ], QuadtreeTest.prototype, "collider_prefabs", void 0);
    __decorate([
        property(cc.Boolean)
    ], QuadtreeTest.prototype, "use_quadtree", void 0);
    __decorate([
        property(cc.Integer)
    ], QuadtreeTest.prototype, "random_collider_size", void 0);
    QuadtreeTest = __decorate([
        ccclass
    ], QuadtreeTest);
    return QuadtreeTest;
}(cc.Component));
exports.default = QuadtreeTest;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/Role.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'a7516OIbHFPj7W4oyYupY4g', 'Role');
// src/Role.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var Role = /** @class */ (function (_super) {
    __extends(Role, _super);
    function Role() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // 旧碰撞检测进入回调
    Role.prototype.onCollisionEnter = function (other, self) {
        // ...
        console.log('进入碰撞');
    };
    // // 新四叉树碰撞检测接触回调
    // private onQuadtreeCollisionContacts(other, self) {
    //     this.onCollisionEnter(other, self); // 转发旧回调函数即可
    // }
    Role.prototype.onCollisionStay = function (other, self) {
        console.log('保持碰撞');
    };
    Role.prototype.onCollisionExit = function (other, self) {
        console.log('退出碰撞');
    };
    Role.prototype.onLoad = function () {
        this.collider = this.node.getComponent(cc.BoxCollider);
    };
    Role.prototype.update = function (dt) {
        if (!this._old_all_collider)
            this._old_all_collider = [];
        var _a = globalThis.App.CollisionManagerEX.check(this.collider, this._old_all_collider), retrieve = _a.retrieve, contacts = _a.contacts;
        this._old_all_collider = contacts;
    };
    Role = __decorate([
        ccclass
    ], Role);
    return Role;
}(cc.Component));
exports.default = Role;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/UseQuadtreeCollisoion.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5eafflw+RxPgo4PyGxsrxVM', 'UseQuadtreeCollisoion');
// src/UseQuadtreeCollisoion.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.label = null;
        _this.text = 'hello';
        return _this;
        // update (dt) {}
    }
    NewClass.prototype.start = function () {
    };
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "label", void 0);
    __decorate([
        property
    ], NewClass.prototype, "text", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9zcmMvVXNlUXVhZHRyZWVDb2xsaXNvaW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFNLElBQUEsS0FBc0IsRUFBRSxDQUFDLFVBQVUsRUFBbEMsT0FBTyxhQUFBLEVBQUUsUUFBUSxjQUFpQixDQUFDO0FBRzFDO0lBQXNDLDRCQUFZO0lBQWxEO1FBQUEscUVBY0M7UUFYRyxXQUFLLEdBQWEsSUFBSSxDQUFDO1FBR3ZCLFVBQUksR0FBVyxPQUFPLENBQUM7O1FBT3ZCLGlCQUFpQjtJQUNyQixDQUFDO0lBTEcsd0JBQUssR0FBTDtJQUVBLENBQUM7SUFSRDtRQURDLFFBQVEsQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDOzJDQUNJO0lBR3ZCO1FBREMsUUFBUTswQ0FDYztJQU5OLFFBQVE7UUFENUIsT0FBTztPQUNhLFFBQVEsQ0FjNUI7SUFBRCxlQUFDO0NBZEQsQUFjQyxDQWRxQyxFQUFFLENBQUMsU0FBUyxHQWNqRDtrQkFkb0IsUUFBUSIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IHtjY2NsYXNzLCBwcm9wZXJ0eX0gPSBjYy5fZGVjb3JhdG9yO1xuXG5AY2NjbGFzc1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTmV3Q2xhc3MgZXh0ZW5kcyBjYy5Db21wb25lbnQge1xuXG4gICAgQHByb3BlcnR5KGNjLkxhYmVsKVxuICAgIGxhYmVsOiBjYy5MYWJlbCA9IG51bGw7XG5cbiAgICBAcHJvcGVydHlcbiAgICB0ZXh0OiBzdHJpbmcgPSAnaGVsbG8nO1xuXG5cbiAgICBzdGFydCAoKSB7XG5cbiAgICB9XG5cbiAgICAvLyB1cGRhdGUgKGR0KSB7fVxufVxuIl19
//------QC-SOURCE-SPLIT------

                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/CollisionManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5b1a19HSpJPK4FpoG3YPSYE', 'CollisionManager');
// src/CollisionManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CollisionManagerEX = exports.CollisionType = void 0;
var CollisionType;
(function (CollisionType) {
    CollisionType[CollisionType["None"] = 0] = "None";
    CollisionType[CollisionType["CollisionEnter"] = 1] = "CollisionEnter";
    CollisionType[CollisionType["CollisionStay"] = 2] = "CollisionStay";
    CollisionType[CollisionType["CollisionExit"] = 3] = "CollisionExit";
})(CollisionType = exports.CollisionType || (exports.CollisionType = {}));
var CollisionManagerEX = /** @class */ (function () {
    function CollisionManagerEX() {
    }
    CollisionManagerEX.getInstance = function () {
        if (this._instance == null) {
            this._instance = new CollisionManagerEX();
        }
        return this._instance;
    };
    /**
     * 获取原版物理引擎的所有添加碰撞体的组件(不用手动删除,添加,creator自己管理)
     */
    CollisionManagerEX.prototype.getColliders = function () {
        return cc.director.getCollisionManager()._colliders;
    };
    CollisionManagerEX.prototype.getDebugDrawer = function () {
        return cc.director.getCollisionManager()._debugDrawer;
    };
    CollisionManagerEX.prototype.getEnabledDebugDraw = function () {
        return cc.director.getCollisionManager()._enabledDebugDraw;
    };
    CollisionManagerEX.prototype.check = function (collider, oldContacts) {
        var _a = globalThis.App.QuadtreeTest._quadCollision.check(cc.director.getCollisionManager()._colliders, collider), retrieve = _a.retrieve, contacts = _a.contacts; // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        for (var index = 0; index < contacts.length; index++) {
            var itemCollider = contacts[index];
            if (oldContacts.indexOf(itemCollider) != -1) {
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionStay, contact);
            }
            else { //之前没有
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionEnter, contact);
            }
        }
        for (var index = 0; index < oldContacts.length; index++) {
            var oldContact = oldContacts[index];
            if (contacts.indexOf(oldContact) == -1) {
                var contact = {
                    collider1: collider,
                    collider2: oldContact
                };
                this._doCollide(CollisionType.CollisionExit, contact);
            }
        }
        return { retrieve: retrieve, contacts: contacts };
    };
    CollisionManagerEX.prototype._doCollide = function (collisionType, contact) {
        var contactFunc;
        switch (collisionType) {
            case CollisionType.CollisionEnter:
                contactFunc = 'onCollisionEnter';
                break;
            case CollisionType.CollisionStay:
                contactFunc = 'onCollisionStay';
                break;
            case CollisionType.CollisionExit:
                contactFunc = 'onCollisionExit';
                break;
        }
        var collider1 = contact.collider1;
        var collider2 = contact.collider2;
        var comps1 = collider1.node._components;
        var comps2 = collider2.node._components;
        var i, l, comp;
        for (i = 0, l = comps1.length; i < l; i++) {
            comp = comps1[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider2, collider1);
            }
        }
        for (i = 0, l = comps2.length; i < l; i++) {
            comp = comps2[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider1, collider2);
            }
        }
    };
    CollisionManagerEX._instance = null;
    return CollisionManagerEX;
}());
exports.CollisionManagerEX = CollisionManagerEX;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9zcmMvQ29sbGlzaW9uTWFuYWdlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxJQUFZLGFBS1g7QUFMRCxXQUFZLGFBQWE7SUFDckIsaURBQUksQ0FBQTtJQUNKLHFFQUFjLENBQUE7SUFDZCxtRUFBYSxDQUFBO0lBQ2IsbUVBQWEsQ0FBQTtBQUNqQixDQUFDLEVBTFcsYUFBYSxHQUFiLHFCQUFhLEtBQWIscUJBQWEsUUFLeEI7QUFDRDtJQUFBO0lBK0ZBLENBQUM7SUE1RmlCLDhCQUFXLEdBQXpCO1FBQ0ksSUFBSSxJQUFJLENBQUMsU0FBUyxJQUFJLElBQUksRUFBRTtZQUN4QixJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksa0JBQWtCLEVBQUUsQ0FBQztTQUM3QztRQUNELE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUMxQixDQUFDO0lBRUQ7O09BRUc7SUFDSCx5Q0FBWSxHQUFaO1FBQ0ksT0FBTyxFQUFFLENBQUMsUUFBUSxDQUFDLG1CQUFtQixFQUFFLENBQUMsVUFBVSxDQUFDO0lBQ3hELENBQUM7SUFFRCwyQ0FBYyxHQUFkO1FBQ0ksT0FBTyxFQUFFLENBQUMsUUFBUSxDQUFDLG1CQUFtQixFQUFFLENBQUMsWUFBWSxDQUFDO0lBRTFELENBQUM7SUFFRCxnREFBbUIsR0FBbkI7UUFDSSxPQUFPLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUJBQW1CLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQztJQUUvRCxDQUFDO0lBRUQsa0NBQUssR0FBTCxVQUFNLFFBQXFCLEVBQUUsV0FBMEI7UUFDN0MsSUFBQSxLQUF5QixVQUFVLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsbUJBQW1CLEVBQUUsQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLEVBQS9ILFFBQVEsY0FBQSxFQUFFLFFBQVEsY0FBNkcsQ0FBQyxDQUFDLGlEQUFpRDtRQUMxTCxLQUFLLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRSxLQUFLLEdBQUcsUUFBUSxDQUFDLE1BQU0sRUFBRSxLQUFLLEVBQUUsRUFBRTtZQUNsRCxJQUFNLFlBQVksR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDckMsSUFBSSxXQUFXLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO2dCQUN6QyxJQUFJLE9BQU8sR0FBRztvQkFDVixTQUFTLEVBQUUsUUFBUTtvQkFDbkIsU0FBUyxFQUFFLFlBQVk7aUJBQzFCLENBQUE7Z0JBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsYUFBYSxFQUFFLE9BQU8sQ0FBQyxDQUFDO2FBQ3pEO2lCQUFNLEVBQUUsTUFBTTtnQkFDWCxJQUFJLE9BQU8sR0FBRztvQkFDVixTQUFTLEVBQUUsUUFBUTtvQkFDbkIsU0FBUyxFQUFFLFlBQVk7aUJBQzFCLENBQUE7Z0JBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsY0FBYyxFQUFFLE9BQU8sQ0FBQyxDQUFDO2FBQzFEO1NBQ0o7UUFDRCxLQUFLLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRSxLQUFLLEdBQUcsV0FBVyxDQUFDLE1BQU0sRUFBRSxLQUFLLEVBQUUsRUFBRTtZQUNyRCxJQUFNLFVBQVUsR0FBRyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDdEMsSUFBSSxRQUFRLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO2dCQUNwQyxJQUFJLE9BQU8sR0FBRztvQkFDVixTQUFTLEVBQUUsUUFBUTtvQkFDbkIsU0FBUyxFQUFFLFVBQVU7aUJBQ3hCLENBQUE7Z0JBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsYUFBYSxFQUFFLE9BQU8sQ0FBQyxDQUFDO2FBQ3pEO1NBQ0o7UUFDRCxPQUFPLEVBQUUsUUFBUSxVQUFBLEVBQUUsUUFBUSxVQUFBLEVBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRUQsdUNBQVUsR0FBVixVQUFXLGFBQWEsRUFBRSxPQUFPO1FBQzdCLElBQUksV0FBVyxDQUFDO1FBQ2hCLFFBQVEsYUFBYSxFQUFFO1lBQ25CLEtBQUssYUFBYSxDQUFDLGNBQWM7Z0JBQzdCLFdBQVcsR0FBRyxrQkFBa0IsQ0FBQztnQkFDakMsTUFBTTtZQUNWLEtBQUssYUFBYSxDQUFDLGFBQWE7Z0JBQzVCLFdBQVcsR0FBRyxpQkFBaUIsQ0FBQztnQkFDaEMsTUFBTTtZQUNWLEtBQUssYUFBYSxDQUFDLGFBQWE7Z0JBQzVCLFdBQVcsR0FBRyxpQkFBaUIsQ0FBQztnQkFDaEMsTUFBTTtTQUNiO1FBRUQsSUFBSSxTQUFTLEdBQUcsT0FBTyxDQUFDLFNBQVMsQ0FBQztRQUNsQyxJQUFJLFNBQVMsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDO1FBRWxDLElBQUksTUFBTSxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBQ3hDLElBQUksTUFBTSxHQUFHLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1FBRXhDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRSxJQUFJLENBQUM7UUFDZixLQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUN2QyxJQUFJLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2pCLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFO2dCQUNuQixJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO2FBQzNDO1NBQ0o7UUFFRCxLQUFLLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUN2QyxJQUFJLEdBQUcsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2pCLElBQUksSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFO2dCQUNuQixJQUFJLENBQUMsV0FBVyxDQUFDLENBQUMsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO2FBQzNDO1NBQ0o7SUFDTCxDQUFDO0lBM0ZjLDRCQUFTLEdBQXVCLElBQUksQ0FBQztJQThGeEQseUJBQUM7Q0EvRkQsQUErRkMsSUFBQTtBQS9GWSxnREFBa0IiLCJmaWxlIjoiIiwic291cmNlUm9vdCI6Ii8iLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZW51bSBDb2xsaXNpb25UeXBlIHtcbiAgICBOb25lLFxuICAgIENvbGxpc2lvbkVudGVyLFxuICAgIENvbGxpc2lvblN0YXksXG4gICAgQ29sbGlzaW9uRXhpdCxcbn1cbmV4cG9ydCBjbGFzcyBDb2xsaXNpb25NYW5hZ2VyRVgge1xuICAgIHByaXZhdGUgc3RhdGljIF9pbnN0YW5jZTogQ29sbGlzaW9uTWFuYWdlckVYID0gbnVsbDtcblxuICAgIHB1YmxpYyBzdGF0aWMgZ2V0SW5zdGFuY2UoKTogQ29sbGlzaW9uTWFuYWdlckVYIHtcbiAgICAgICAgaWYgKHRoaXMuX2luc3RhbmNlID09IG51bGwpIHtcbiAgICAgICAgICAgIHRoaXMuX2luc3RhbmNlID0gbmV3IENvbGxpc2lvbk1hbmFnZXJFWCgpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB0aGlzLl9pbnN0YW5jZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiDojrflj5bljp/niYjniannkIblvJXmk47nmoTmiYDmnInmt7vliqDnorDmkp7kvZPnmoTnu4Tku7Yo5LiN55So5omL5Yqo5Yig6ZmkLOa3u+WKoCxjcmVhdG9y6Ieq5bex566h55CGKVxuICAgICAqL1xuICAgIGdldENvbGxpZGVycygpIHtcbiAgICAgICAgcmV0dXJuIGNjLmRpcmVjdG9yLmdldENvbGxpc2lvbk1hbmFnZXIoKS5fY29sbGlkZXJzO1xuICAgIH1cblxuICAgIGdldERlYnVnRHJhd2VyKCkge1xuICAgICAgICByZXR1cm4gY2MuZGlyZWN0b3IuZ2V0Q29sbGlzaW9uTWFuYWdlcigpLl9kZWJ1Z0RyYXdlcjtcblxuICAgIH1cblxuICAgIGdldEVuYWJsZWREZWJ1Z0RyYXcoKSB7XG4gICAgICAgIHJldHVybiBjYy5kaXJlY3Rvci5nZXRDb2xsaXNpb25NYW5hZ2VyKCkuX2VuYWJsZWREZWJ1Z0RyYXc7XG5cbiAgICB9XG5cbiAgICBjaGVjayhjb2xsaWRlcjogY2MuQ29sbGlkZXIsIG9sZENvbnRhY3RzOiBbY2MuQ29sbGlkZXJdKSB7XG4gICAgICAgIGNvbnN0IHsgcmV0cmlldmUsIGNvbnRhY3RzIH0gPSBnbG9iYWxUaGlzLkFwcC5RdWFkdHJlZVRlc3QuX3F1YWRDb2xsaXNpb24uY2hlY2soY2MuZGlyZWN0b3IuZ2V0Q29sbGlzaW9uTWFuYWdlcigpLl9jb2xsaWRlcnMsIGNvbGxpZGVyKTsgLy8g5omA5pyJ56Kw5pKe5L2T5LiO5Li76KeS5YGa56Kw5pKe5qOA5rWL77yM5Lya6Ieq5Yqo6LCD55Sob25RdWFkdHJlZUNvbGxpc2lvbkNvbnRhY3RzXG4gICAgICAgIGZvciAobGV0IGluZGV4ID0gMDsgaW5kZXggPCBjb250YWN0cy5sZW5ndGg7IGluZGV4KyspIHtcbiAgICAgICAgICAgIGNvbnN0IGl0ZW1Db2xsaWRlciA9IGNvbnRhY3RzW2luZGV4XTtcbiAgICAgICAgICAgIGlmIChvbGRDb250YWN0cy5pbmRleE9mKGl0ZW1Db2xsaWRlcikgIT0gLTEpIHtcbiAgICAgICAgICAgICAgICBsZXQgY29udGFjdCA9IHtcbiAgICAgICAgICAgICAgICAgICAgY29sbGlkZXIxOiBjb2xsaWRlcixcbiAgICAgICAgICAgICAgICAgICAgY29sbGlkZXIyOiBpdGVtQ29sbGlkZXJcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdGhpcy5fZG9Db2xsaWRlKENvbGxpc2lvblR5cGUuQ29sbGlzaW9uU3RheSwgY29udGFjdCk7XG4gICAgICAgICAgICB9IGVsc2UgeyAvL+S5i+WJjeayoeaciVxuICAgICAgICAgICAgICAgIGxldCBjb250YWN0ID0ge1xuICAgICAgICAgICAgICAgICAgICBjb2xsaWRlcjE6IGNvbGxpZGVyLFxuICAgICAgICAgICAgICAgICAgICBjb2xsaWRlcjI6IGl0ZW1Db2xsaWRlclxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB0aGlzLl9kb0NvbGxpZGUoQ29sbGlzaW9uVHlwZS5Db2xsaXNpb25FbnRlciwgY29udGFjdCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgZm9yIChsZXQgaW5kZXggPSAwOyBpbmRleCA8IG9sZENvbnRhY3RzLmxlbmd0aDsgaW5kZXgrKykge1xuICAgICAgICAgICAgY29uc3Qgb2xkQ29udGFjdCA9IG9sZENvbnRhY3RzW2luZGV4XTtcbiAgICAgICAgICAgIGlmIChjb250YWN0cy5pbmRleE9mKG9sZENvbnRhY3QpID09IC0xKSB7XG4gICAgICAgICAgICAgICAgbGV0IGNvbnRhY3QgPSB7XG4gICAgICAgICAgICAgICAgICAgIGNvbGxpZGVyMTogY29sbGlkZXIsXG4gICAgICAgICAgICAgICAgICAgIGNvbGxpZGVyMjogb2xkQ29udGFjdFxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB0aGlzLl9kb0NvbGxpZGUoQ29sbGlzaW9uVHlwZS5Db2xsaXNpb25FeGl0LCBjb250YWN0KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4geyByZXRyaWV2ZSwgY29udGFjdHMgfTtcbiAgICB9XG5cbiAgICBfZG9Db2xsaWRlKGNvbGxpc2lvblR5cGUsIGNvbnRhY3QpIHtcbiAgICAgICAgbGV0IGNvbnRhY3RGdW5jO1xuICAgICAgICBzd2l0Y2ggKGNvbGxpc2lvblR5cGUpIHtcbiAgICAgICAgICAgIGNhc2UgQ29sbGlzaW9uVHlwZS5Db2xsaXNpb25FbnRlcjpcbiAgICAgICAgICAgICAgICBjb250YWN0RnVuYyA9ICdvbkNvbGxpc2lvbkVudGVyJztcbiAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIGNhc2UgQ29sbGlzaW9uVHlwZS5Db2xsaXNpb25TdGF5OlxuICAgICAgICAgICAgICAgIGNvbnRhY3RGdW5jID0gJ29uQ29sbGlzaW9uU3RheSc7XG4gICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICBjYXNlIENvbGxpc2lvblR5cGUuQ29sbGlzaW9uRXhpdDpcbiAgICAgICAgICAgICAgICBjb250YWN0RnVuYyA9ICdvbkNvbGxpc2lvbkV4aXQnO1xuICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IGNvbGxpZGVyMSA9IGNvbnRhY3QuY29sbGlkZXIxO1xuICAgICAgICBsZXQgY29sbGlkZXIyID0gY29udGFjdC5jb2xsaWRlcjI7XG5cbiAgICAgICAgbGV0IGNvbXBzMSA9IGNvbGxpZGVyMS5ub2RlLl9jb21wb25lbnRzO1xuICAgICAgICBsZXQgY29tcHMyID0gY29sbGlkZXIyLm5vZGUuX2NvbXBvbmVudHM7XG5cbiAgICAgICAgbGV0IGksIGwsIGNvbXA7XG4gICAgICAgIGZvciAoaSA9IDAsIGwgPSBjb21wczEubGVuZ3RoOyBpIDwgbDsgaSsrKSB7XG4gICAgICAgICAgICBjb21wID0gY29tcHMxW2ldO1xuICAgICAgICAgICAgaWYgKGNvbXBbY29udGFjdEZ1bmNdKSB7XG4gICAgICAgICAgICAgICAgY29tcFtjb250YWN0RnVuY10oY29sbGlkZXIyLCBjb2xsaWRlcjEpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgZm9yIChpID0gMCwgbCA9IGNvbXBzMi5sZW5ndGg7IGkgPCBsOyBpKyspIHtcbiAgICAgICAgICAgIGNvbXAgPSBjb21wczJbaV07XG4gICAgICAgICAgICBpZiAoY29tcFtjb250YWN0RnVuY10pIHtcbiAgICAgICAgICAgICAgICBjb21wW2NvbnRhY3RGdW5jXShjb2xsaWRlcjEsIGNvbGxpZGVyMik7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9XG5cblxufSJdfQ==
//------QC-SOURCE-SPLIT------
