
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/CollisionManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '5b1a19HSpJPK4FpoG3YPSYE', 'CollisionManager');
// src/CollisionManager.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CollisionManagerEX = exports.CollisionType = void 0;
var CollisionType;
(function (CollisionType) {
    CollisionType[CollisionType["None"] = 0] = "None";
    CollisionType[CollisionType["CollisionEnter"] = 1] = "CollisionEnter";
    CollisionType[CollisionType["CollisionStay"] = 2] = "CollisionStay";
    CollisionType[CollisionType["CollisionExit"] = 3] = "CollisionExit";
})(CollisionType = exports.CollisionType || (exports.CollisionType = {}));
var CollisionManagerEX = /** @class */ (function () {
    function CollisionManagerEX() {
    }
    CollisionManagerEX.getInstance = function () {
        if (this._instance == null) {
            this._instance = new CollisionManagerEX();
        }
        return this._instance;
    };
    /**
     * 获取原版物理引擎的所有添加碰撞体的组件(不用手动删除,添加,creator自己管理)
     */
    CollisionManagerEX.prototype.getColliders = function () {
        return cc.director.getCollisionManager()._colliders;
    };
    CollisionManagerEX.prototype.getDebugDrawer = function () {
        return cc.director.getCollisionManager()._debugDrawer;
    };
    CollisionManagerEX.prototype.getEnabledDebugDraw = function () {
        return cc.director.getCollisionManager()._enabledDebugDraw;
    };
    CollisionManagerEX.prototype.check = function (collider, oldContacts) {
        var _a = globalThis.App.QuadtreeTest._quadCollision.check(cc.director.getCollisionManager()._colliders, collider), retrieve = _a.retrieve, contacts = _a.contacts; // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        for (var index = 0; index < contacts.length; index++) {
            var itemCollider = contacts[index];
            if (oldContacts.indexOf(itemCollider) != -1) {
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionStay, contact);
            }
            else { //之前没有
                var contact = {
                    collider1: collider,
                    collider2: itemCollider
                };
                this._doCollide(CollisionType.CollisionEnter, contact);
            }
        }
        for (var index = 0; index < oldContacts.length; index++) {
            var oldContact = oldContacts[index];
            if (contacts.indexOf(oldContact) == -1) {
                var contact = {
                    collider1: collider,
                    collider2: oldContact
                };
                this._doCollide(CollisionType.CollisionExit, contact);
            }
        }
        return { retrieve: retrieve, contacts: contacts };
    };
    CollisionManagerEX.prototype._doCollide = function (collisionType, contact) {
        var contactFunc;
        switch (collisionType) {
            case CollisionType.CollisionEnter:
                contactFunc = 'onCollisionEnter';
                break;
            case CollisionType.CollisionStay:
                contactFunc = 'onCollisionStay';
                break;
            case CollisionType.CollisionExit:
                contactFunc = 'onCollisionExit';
                break;
        }
        var collider1 = contact.collider1;
        var collider2 = contact.collider2;
        var comps1 = collider1.node._components;
        var comps2 = collider2.node._components;
        var i, l, comp;
        for (i = 0, l = comps1.length; i < l; i++) {
            comp = comps1[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider2, collider1);
            }
        }
        for (i = 0, l = comps2.length; i < l; i++) {
            comp = comps2[i];
            if (comp[contactFunc]) {
                comp[contactFunc](collider1, collider2);
            }
        }
    };
    CollisionManagerEX._instance = null;
    return CollisionManagerEX;
}());
exports.CollisionManagerEX = CollisionManagerEX;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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