
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/src/QuadtreeTest.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '91ca2XTzsdNMbLOGhBKtSdw', 'QuadtreeTest');
// src/QuadtreeTest.ts

"use strict";
// author: http://lamyoung.com/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var CollisionManager_1 = require("./CollisionManager");
var QuadtreeCollision_1 = require("./QuadtreeCollision");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var QuadtreeTest = /** @class */ (function (_super) {
    __extends(QuadtreeTest, _super);
    function QuadtreeTest() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.collider_role = null;
        _this.collider_prefabs = [];
        _this.use_quadtree = false;
        _this.random_collider_size = 0;
        _this._all_collider = [];
        return _this;
    }
    QuadtreeTest.prototype.createRandomCollider = function () {
        for (var i = 0; i < this.random_collider_size; ++i) {
            var node = cc.instantiate(this.collider_prefabs[Math.floor(Math.random() * 3)]);
            node.x = Math.random() * this.node.width - this.node.width / 2;
            node.y = Math.random() * this.node.height - this.node.height / 2;
            node.angle = Math.random() * 360;
            node.opacity = 30;
            node.parent = this.node;
        }
    };
    QuadtreeTest.prototype.onLoad = function () {
        globalThis.App = {};
        globalThis.App.CollisionManagerEX = CollisionManager_1.CollisionManagerEX.getInstance();
        this.createRandomCollider();
        if (this.use_quadtree) {
            cc.director.getCollisionManager().enabled = false; // 必须关闭原版物理引擎
            this._quadCollision = new QuadtreeCollision_1.default(this.node.getBoundingBoxToWorld()); // 初始化四叉树全局范围大小rect
            this._all_collider = this.node.getComponentsInChildren(cc.Collider); // 获取所有的碰撞体
        }
        else {
            cc.director.getCollisionManager().enabled = true;
        }
        globalThis.App.QuadtreeTest = this;
    };
    QuadtreeTest.prototype.start = function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    QuadtreeTest.prototype.onTouchMove = function (evt) {
        var pos = this.collider_role.node.parent.convertToNodeSpaceAR(evt.getLocation());
        this.collider_role.node.x = pos.x;
        this.collider_role.node.y = pos.y;
    };
    QuadtreeTest.prototype.lateUpdate = function () {
        // if (this.use_quadtree) {
        //     const { retrieve, contacts } = this._quadCollision.check(this._all_collider, this.collider_role); // 所有碰撞体与主角做碰撞检测，会自动调用onQuadtreeCollisionContacts
        //     // retrieve 准备测试的对象(预览图中的绿色)   cc.Collider[]
        //     // contacts 碰撞对象(预览图中的红色)   cc.Collider[]
        //     this._all_collider.forEach(c => c.node.color = cc.Color.WHITE);
        //     retrieve.forEach(c => c.node.color = cc.Color.GREEN);
        //     contacts.forEach(c => c.node.color = cc.Color.RED);
        // }
    };
    __decorate([
        property(cc.Collider)
    ], QuadtreeTest.prototype, "collider_role", void 0);
    __decorate([
        property(cc.Prefab)
    ], QuadtreeTest.prototype, "collider_prefabs", void 0);
    __decorate([
        property(cc.Boolean)
    ], QuadtreeTest.prototype, "use_quadtree", void 0);
    __decorate([
        property(cc.Integer)
    ], QuadtreeTest.prototype, "random_collider_size", void 0);
    QuadtreeTest = __decorate([
        ccclass
    ], QuadtreeTest);
    return QuadtreeTest;
}(cc.Component));
exports.default = QuadtreeTest;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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