import { _decorator, Component, Node, v3, Vec3, screen, view, log, TiledMap, clamp, director, Camera, UITransform } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CameraFollow')
export class CameraFollow extends Component {
    @property(Node)
    target: Node = null;

    @property(TiledMap)
    tileMap: TiledMap = null;

    @property(Camera)
    uiCamera: Camera = null;

    private camera: Camera = null;
    private cameraMoveSpeed = 2;

    private ratio: number = 1;
    private _mapWidth: number = 0;
    private _mapHeight: number = 0;
    private _cameraMaxX: number = 0;
    private _cameraMaxY: number = 0;

    private _cameraFollowPos = v3();
    private _cameraPos = v3();
    private _newCameraPos = v3();
    private _cameraMoveDir = v3();

    start() {
        let uiTransform = this.tileMap.getComponent(UITransform);
        this._mapWidth = uiTransform.width;
        this._mapHeight = uiTransform.height;

        this.camera = this.node.getComponent(Camera);
        log("地图尺寸：" + this._mapWidth + "," + this._mapHeight);
    }

    update(deltaTime: number) {
        
    }

    lateUpdate(deltaTime: number) {
        this.HandleMovement(deltaTime);
    }

    private HandleMovement(deltaTime: number) {
        this.target.getPosition(this._cameraFollowPos);
        this.node.getPosition(this._cameraPos);
        this._cameraFollowPos.z = this._cameraPos.z;

        Vec3.subtract(this._cameraMoveDir, this._cameraFollowPos, this._cameraPos);
        Vec3.normalize(this._cameraMoveDir, this._cameraMoveDir);

        let distance = Vec3.distance(this._cameraFollowPos, this._cameraPos);
        if (distance > 0.1) {
            Vec3.scaleAndAdd(this._newCameraPos, this._cameraPos, this._cameraMoveDir, distance * this.cameraMoveSpeed * deltaTime);

            let distanceAfterMoving = Vec3.distance(this._newCameraPos, this._cameraFollowPos);
            if (distanceAfterMoving > distance) {
                this._newCameraPos = this._cameraFollowPos;
            }

            this.updateCameraPosition();
        }
    }

    private updateCameraPosition() {
        
        this.ratio = this.camera.orthoHeight/this.uiCamera.orthoHeight;

        log("ratio:" + this.ratio)

        log("screen.windowSize:" + screen.windowSize);
        this._cameraMaxX = (this._mapWidth - screen.windowSize.width*this.ratio)/2;
        this._cameraMaxY = (this._mapHeight - screen.windowSize.height*this.ratio)/2;

        log("maxX:" + this._cameraMaxX + ";maxY:" + this._cameraMaxY);

        this._newCameraPos.x = clamp(this._newCameraPos.x, -this._cameraMaxX, this._cameraMaxX);
        this._newCameraPos.y = clamp(this._newCameraPos.y, -this._cameraMaxY, this._cameraMaxY);
        this.node.setPosition(this._newCameraPos);
    }
}

