import { _decorator, Component, Node, input, Input, EventKeyboard, KeyCode, Vec3, v3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('KeyboardMove')
export class KeyboardMove extends Component {
    @property({tooltip: "移动速度"})
    get MoveSpeed() {
        return this._moveSpeed;
    }
    set MoveSpeed(value: number) {
        this._moveSpeed = value;
    }
    @property
    private _moveSpeed: number = 1;
    
    get MoveDir() {
        return this._moveDir;
    }
    set MoveDir(value: Vec3) {
        this._moveDir.set(value);
    }
    private _moveDir: Vec3 = v3();

    private _temp_v3 = v3();

    start() {

    }

    onEnable() {
        input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.on(Input.EventType.KEY_PRESSING, this.onKeyPressing, this);
        input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
    }
    onDisable() {
        input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
        input.off(Input.EventType.KEY_PRESSING, this.onKeyPressing, this);
        input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
    }

    update(deltaTime: number) {
        // 计算要移动的目标位置
        Vec3.scaleAndAdd(this._temp_v3, this.node.worldPosition, this._moveDir, this._moveSpeed);
        // 插值计算
        Vec3.lerp(this._temp_v3, this.node.worldPosition, this._temp_v3, deltaTime * this._moveSpeed);
        // 移动节点
        this.node.setWorldPosition(this._temp_v3);
    }

    private onKeyDown(event: EventKeyboard) {
        this.handleKeyMove(event);
    }

    private onKeyPressing(event: EventKeyboard) {
        this.handleKeyMove(event);
    }

    private onKeyUp(event: EventKeyboard) {
        Vec3.zero(this._moveDir);
    }

    private handleKeyMove(event: EventKeyboard) {
        switch (event.keyCode) {
            case KeyCode.KEY_W:
            case KeyCode.ARROW_UP:
                this._moveDir.y = 1;
                break;
            case KeyCode.KEY_S:
            case KeyCode.ARROW_DOWN:
                this._moveDir.y = -1;
                break;
            case KeyCode.KEY_A:
            case KeyCode.ARROW_LEFT:
                this._moveDir.x = -1;
                break;
            case KeyCode.KEY_D:
            case KeyCode.ARROW_RIGHT:
                this._moveDir.x = 1;
                break;
        
            default:
                break;
        }
    }
}

