#LM & MCV
#coding=utf-8
#版本: 1.2
import os,sys
import os.path
import shutil
import json
import hashlib
import socket
import platform
import time
import importlib
from ftplib import FTP            #加载ftp模块
from mimetypes import guess_type, add_type
importlib.reload(sys)
#sys.setdefaultencoding('utf8') 

isCode 	= ('gbk' if (platform.system() == "Windows") else 'utf-8')



#---------------------------------------------------
#-- 				通用方法

#创建路径下的文件夹
def createDir(paht):
	if len(os.path.split(paht)) > 1:
		if not os.path.isdir(os.path.split(paht)[0]):
			os.makedirs(os.path.split(paht)[0])
	elif not os.path.isdir(paht):
		os.makedirs(paht)


#获得目录下所有文件列表
def getFileList(dir,fileList):
	if os.path.isfile(dir):
		fileList.append(dir)
	elif os.path.isdir(dir):  
		for s in os.listdir(dir):
			newDir=os.path.join(dir,s)
			getFileList(newDir, fileList)  
	return fileList

#保存Json
def saveJson(filePath,data):
	createDir(filePath)
	json_file = open(filePath,"wb")
	text = json.dumps(data,indent=4)
	json_file.write(text)
	json_file.close()

#读取Json
def loadJson(filePath):
	if os.path.exists(filePath) :
		json_file = open(filePath,'r',encoding='utf-8')
		data = json.load(json_file)
		json_file.close()
		return data
	else:
		return False


#读取文件
def readFile(file_path):
	text = None
	if os.path.isfile(file_path):
		f = open(file_path,'rb')
		text = f.read()
		f.close()
	return text

#写文件
def writeFile(file_path,text):
	createDir(file_path)
	json_file = open(file_path,"wb")
	json_file.write(text)
	json_file.close()


#获取MD5
def getMD5(file_path):
	md5 = None
	if os.path.isfile(file_path):
		f = open(file_path,'rb')
		md5_obj = hashlib.md5()
		md5_obj.update(f.read())
		hash_code = md5_obj.hexdigest()
		f.close()
		md5 = str(hash_code).lower()
	return md5

#文件夹对比
def fc(new_dir,old_dir):
	c_list = []
	fileList = getFileList(new_dir,[])
	for n_file in fileList:
		o_file = old_dir + n_file.split(new_dir)[1]
		if not os.path.isfile(o_file) or getMD5(n_file) != getMD5(o_file) :
			c_list.append(n_file)
	return c_list #差异的文件

	
#复制文件到指定目录
def copyFileTo(fileList,rDir,tDir):
	for r_file in fileList:
		if r_file.find("DS_Store") != -1 :
			continue
		t_file = tDir + r_file.split(rDir)[1]
		createDir(t_file)
		shutil.copyfile(r_file,t_file)

#是否文本文件
def isTextKind(file, trace=False):
	add_type('text/x-python-win', '.pyw')
	mimetype, encoding = guess_type(file, strict=False)
	mimetype = mimetype or '?/?'
	maintype = mimetype.split('/')[0]
	if trace: print(maintype, encoding or '')
	return maintype == 'text' and encoding == None


def getUUID(filePath):
	md5_obj = hashlib.md5()
	md5_obj.update((filePath+str(time.time())).encode('utf8'))
	hash_code = md5_obj.hexdigest()
	text = str(hash_code).lower()
	uuid = text[0:8]+"-"+text[9:13]+"-"+text[14:18]+"-"+text[18:22]+"-"+text[23:]
	return uuid


# 输入配置信息
def init():
	inPath = input(str("请输入assets下的文件夹路径(路径不能有空格):\n"))
	print(inPath)
	fileList = getFileList(inPath,[])
	if len(fileList) == 0:
		input(str("该路径不存在文件,或为错误路径\n"))

	fileContent = {}
	otherFile = []
	metaContent = []

	# 读取配置
	for file in fileList:
		prx = file.split(".");
		prx = prx[len(prx)-1]
		#读取uuid
		if prx == "meta" :
			data = loadJson(file)
			uuid = data["uuid"];
			metaContent.append([ uuid ,  getUUID(file+"type:path") ])
			if 'subMetas' in data:
				for temp in data["subMetas"].items() :
					if 'uuid' in temp[1]:
						uuid = temp[1]["uuid"]
						metaContent.append([ uuid , getUUID(file+"type:"+temp[0]) ])


		# 读取工程文件缓存
		if prx == "meta" or prx == "prefab" or prx == "anim" or prx == "fire":
			fileContent[file] = readFile(file);
		else:
			otherFile.append(file)
		
	#修改uuid
	for uuids in metaContent :
		for temp in fileContent.items():
			text = temp[1]	
			print("Generate new uuid... :",temp[0],uuids[0],uuids[1])
			fileContent[temp[0]] = text.replace(uuids[0].encode('utf8'),uuids[1].encode('utf8'))

	#复制文件
	for temp in fileContent.items() :
		path = temp[0]
		path = path.replace(inPath,inPath+"_copy")
		print("copy: ",path)
		writeFile(path,temp[1]);

	for path in otherFile :
		toPath = path.replace(inPath,inPath+"_copy")
		print("copy: ",toPath)
		shutil.copyfile(path,toPath)      

	print("完成")



init()













