
const {ccclass, property, executeInEditMode, menu, help, inspector} = cc._decorator;
@ccclass
@menu('i18n:MAIN_MENU.component.ui/ButtonPlus')
@executeInEditMode
@help('i18n:COMPONENT.help_url.button')
@inspector('packages://buttonplus/inspector.js')
export default class ButtonPlus extends cc.Button {
    @property
    openContinuous = true;
    @property
    continuousTime = 1;
    continuous: boolean = false;
    _continuousTimer = null;
    
    @property
    openLongPress = false;
    @property
    longPressTime = 1;
    longPressFlag = false;

    private longPressTimer = null;
    
    onEnable() {
        this.continuous = false;
        super.onEnable();
        if (!CC_EDITOR) {
        }
    }
    onDisable() {
        if (this._continuousTimer) {
            clearTimeout(this._continuousTimer);
            this._continuousTimer = null;
        }
        if(this.longPressTimer) {
            clearTimeout(this.longPressTimer);
            this.longPressTimer = null;
        }
        super.onDisable();
    }
    _onTouchBegan (event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
 
        if(this.openLongPress && !this.longPressFlag) {
            if(this.longPressTimer) clearTimeout(this.longPressTimer);
            this.longPressTimer = setTimeout(function() {
                if(this["_pressed"]) {
                    this.node.emit('longclickStart', this);
                    this.longPressFlag = true;
                }
            }.bind(this), this.longPressTime * 1000);
        }

        this["_pressed"] = true;
        this["_updateState"]();
        event.stopPropagation();
    }
    _onTouchEnded(event) {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if(this["_pressed"] && this.longPressFlag) {
            this.node.emit('longclickEnd', this);
            this.longPressFlag = false;
        } else if (this["_pressed"] && !this.continuous) {
            this.continuous = this.openContinuous ? true : false;
            cc.Component.EventHandler.emitEvents(this.clickEvents, event);
            this.node.emit('click', event);
            if (this.openContinuous) {
               this._continuousTimer = setTimeout(function(){
                    this.continuous = false;
                }.bind(this), this.continuousTime * 1000);
            }
        }
        this["_pressed"] = false;
        this["_updateState"]();
        event.stopPropagation();
    }
    _onTouchCancel () {
        if (!this.interactable || !this.enabledInHierarchy) return;
        if(this["_pressed"] && this.longPressFlag) {
            this.node.emit('longclickEnd', this);
            this.longPressFlag = false;
        }
        this["_pressed"] = false;
        this["_updateState"]();
    }
    addClick(callback: Function, target: Object) {
        this.node.off('click');
        this.node.on('click', callback, target);
    }
    addLongClick(startFunc: Function, endFunc: Function, target: Object) {
        this.node.off('longclickStart');
        this.node.off('longclickEnd');
        this.node.on('longclickStart', startFunc, target);
        this.node.on('longclickEnd', endFunc, target);
    }
}