System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, input, Input, KeyCode, Vec3, RigidBody, MeshCollider, director, _dec, _class, _crd, ccclass, property, TestCollision;

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      input = _cc.input;
      Input = _cc.Input;
      KeyCode = _cc.KeyCode;
      Vec3 = _cc.Vec3;
      RigidBody = _cc.RigidBody;
      MeshCollider = _cc.MeshCollider;
      director = _cc.director;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "689c0IGOMdBxryY8QixIzYE", "TestCollision", undefined);

      __checkObsolete__(['_decorator', 'BoxCollider', 'Component', 'CylinderCollider', 'ITriggerEvent', 'Node', 'input', 'Input', 'EventKeyboard', 'KeyCode', 'Vec3', 'RigidBody2D', 'RigidBody', 'MeshCollider', 'director']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("TestCollision", TestCollision = (_dec = ccclass('TestCollision'), _dec(_class = class TestCollision extends Component {
        constructor() {
          super(...arguments);
          this.collider = null;
          this.rb = null;
          this.aDown = false;
          this.dDown = false;
        }

        start() {
          this.collider = this.getComponent(MeshCollider);
          this.rb = this.getComponent(RigidBody);
          this.collider.on('onTriggerEnter', this.onTriggerEnter, this);
          this.collider.on('onTriggerExit', this.onTriggerExit, this);
          input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
          input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
        }

        update(deltaTime) {
          if (this.aDown) {
            console.log('aDown'); //this.node.position = this.node.position.add();

            this.rb.applyForce(new Vec3(-1000 * deltaTime, 0, 0));
          }

          if (this.dDown) {
            console.log('dDown'); //this.node.position = this.node.position.add(new Vec3(1 * deltaTime, 0, 0));

            this.rb.applyForce(new Vec3(1000 * deltaTime, 0, 0));
          }
        }

        onTriggerEnter(event) {
          console.log(this.node.name + ' onTriggerEnter'); //console.log(this.node.name + ' selfCollider is ' + event.selfCollider.node.name);
          //console.log(this.node.name + ' otherCollider is ' + event.otherCollider.node.name);
        }

        onTriggerExit(event) {
          console.log(this.node.name + ' onTriggerExit'); //console.log(this.node.name + ' selfCollider is ' + event.selfCollider.node.name);
          //console.log(this.node.name + ' otherCollider is ' + event.otherCollider.node.name);
        }

        onKeyDown(event) {
          if (event.keyCode == KeyCode.KEY_A) {
            this.aDown = true;
          }

          if (event.keyCode == KeyCode.KEY_D) {
            this.dDown = true;
          }
        }

        onKeyUp(event) {
          if (event.keyCode == KeyCode.KEY_A) {
            this.aDown = false;
          }

          if (event.keyCode == KeyCode.KEY_D) {
            this.dDown = false;
          }

          if (event.keyCode == KeyCode.KEY_R) {
            director.loadScene("test");
          }
        }

      }) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=a2dd11d7c3cf71531e83715761b8e890b633e9fc.js.map