System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, Node, input, Input, KeyCode, Vec3, RigidBody, MeshCollider, director, _dec, _dec2, _class, _class2, _descriptor, _crd, ccclass, property, TestCollision;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      Node = _cc.Node;
      input = _cc.input;
      Input = _cc.Input;
      KeyCode = _cc.KeyCode;
      Vec3 = _cc.Vec3;
      RigidBody = _cc.RigidBody;
      MeshCollider = _cc.MeshCollider;
      director = _cc.director;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "689c0IGOMdBxryY8QixIzYE", "TestCollision", undefined);

      __checkObsolete__(['_decorator', 'BoxCollider', 'Component', 'CylinderCollider', 'ITriggerEvent', 'Node', 'input', 'Input', 'EventKeyboard', 'KeyCode', 'Vec3', 'RigidBody2D', 'RigidBody', 'MeshCollider', 'director']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("TestCollision", TestCollision = (_dec = ccclass('TestCollision'), _dec2 = property(Node), _dec(_class = (_class2 = class TestCollision extends Component {
        constructor() {
          super(...arguments);
          this.collider = null;
          this.rb = null;
          this.aDown = false;
          this.dDown = false;

          _initializerDefineProperty(this, "cylinder", _descriptor, this);
        }

        start() {
          this.collider = this.getComponent(MeshCollider);
          this.rb = this.getComponent(RigidBody);
          this.collider.on('onTriggerEnter', this.onTriggerEnter, this);
          this.collider.on('onTriggerExit', this.onTriggerExit, this);
          input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
          input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
        }

        update(deltaTime) {
          if (this.aDown) {
            console.log('aDown');
            this.node.position = this.node.position.add(new Vec3(-1 * deltaTime, 0, 0)); //this.rb.applyForce(new Vec3(-1000 * deltaTime, 0, 0));

            this.cylinder.getComponent(RigidBody).applyForce(new Vec3(1000 * deltaTime, 0, 0));
          }

          if (this.dDown) {
            console.log('dDown');
            this.node.position = this.node.position.add(new Vec3(1 * deltaTime, 0, 0)); //this.rb.applyForce(new Vec3(1000 * deltaTime, 0, 0));

            this.cylinder.getComponent(RigidBody).applyForce(new Vec3(-1000 * deltaTime, 0, 0));
          }
        }

        onTriggerEnter(event) {
          console.log(this.node.name + ' onTriggerEnter'); //console.log(this.node.name + ' selfCollider is ' + event.selfCollider.node.name);
          //console.log(this.node.name + ' otherCollider is ' + event.otherCollider.node.name);
        }

        onTriggerExit(event) {
          console.log(this.node.name + ' onTriggerExit'); //console.log(this.node.name + ' selfCollider is ' + event.selfCollider.node.name);
          //console.log(this.node.name + ' otherCollider is ' + event.otherCollider.node.name);
        }

        onKeyDown(event) {
          if (event.keyCode == KeyCode.KEY_A) {
            this.aDown = true;
          }

          if (event.keyCode == KeyCode.KEY_D) {
            this.dDown = true;
          }
        }

        onKeyUp(event) {
          if (event.keyCode == KeyCode.KEY_A) {
            this.aDown = false;
          }

          if (event.keyCode == KeyCode.KEY_D) {
            this.dDown = false;
          }

          if (event.keyCode == KeyCode.KEY_R) {
            director.loadScene("test");
          }
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "cylinder", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=f961946bf0b21860079932adee3c6e24d7d222e8.js.map