'use strict';

const path = require('path');
const fs = require('fs');
const cp = require('child_process');
const os = require('os');

function onBuildStart(options, callback) {
    Editor.log('onBuildStart')
    callback();
}

function onBeforeBuildFinish(options, callback) {
    Editor.log('onBeforeBuildFinish')
    setTimeout(callback, 5000);
}

function onBuildFinish(options, callback) {
    Editor.log('onBuildFinish')
    callback();
}

module.exports = {
    load() {
        Editor.Builder.on('build-start', onBuildStart);
        Editor.Builder.on('before-change-files', onBeforeBuildFinish);
        Editor.Builder.on('build-finished', onBuildFinish);
    },

    unload() {
        Editor.Builder.removeListener('build-start', onBuildStart);
        Editor.Builder.removeListener('before-change-files', onBeforeBuildFinish);
        Editor.Builder.removeListener('build-finished', onBuildFinish);
    }
};