import * as fs from "fs"

export default class FileList {

    _data = null;
    _allPath = [];

    constructor(){
        this._data = null;
    }

    /**
     * {
     *    name: "",
     *    dir: [],
     *    files: []
     * }
     */
    getDirData( dir ){
        const self = this;
        const name = dir.substr( dir.lastIndexOf( '/' ) + 1 );

        const ret = {
            name: name,
            dir: [],
            files: [],
        };

        const files = fs.readdirSync( dir );
        for( const nameTmp of files ){
            const stat = fs.statSync( dir + "/" + nameTmp );
            if( stat.isFile() ){
                ret.files.push( nameTmp );
            }else if( stat.isDirectory() ){
                ret.dir.push( self.getDirData( dir + "/" + nameTmp ) );
            }
        }
        return ret;
    }

    addFile2Data( fileName ){

    }

    removeFileFromData( fileName ){

    }

    dirData2String( obj, dir ){
        const self = this;
        const baseStr = dir ? (dir + "/" + obj.name) : ".";
        let str = "";
        for( const name of obj.files ){
            str += baseStr + "/" + name + "\n";
        }
    
        for( const d of obj.dir ){
            str += self.dirData2String( d, baseStr );
        }
    
        return str;
    }

    /**
     * 初始化Data
     * @param {string} dir 目录
     * @param {Array<string>} arrExclude 要排除的目录
     */
    initData( dir, arrExclude = [] ){
        const self = this;
        self._data = self.getDirData( dir, "" );
        for( const exName of arrExclude ){
            for( let i=0; i<self._data.dir.length; ++i ){
                const name = self._data.dir[i].name;
                if( name == exName ){
                    self._data.dir.splice( i, 1 );
                    break;
                }
            }
        }
    }

    getAllFilePath(){
        const self = this;
        if( self._allPath.length == 0 ){
            self._allPath = self.getAllPathInData( self._data );
        }
        return self._allPath;
    }

    getAllPathInData( data, basePath = null ){
        const self = this;
        const arrPath = [];
        for( const fileName of data.files ){
            arrPath.push( basePath ? basePath + "/" + data.name + "/" + fileName : data.name + "/" + fileName );
        }

        for( const dir of data.dir ){
            const basePathTmp = basePath ? basePath + "/" + data.name : data.name;
            const dirPath = self.getAllPathInData( dir, basePathTmp );
            for( const pathTmp of dirPath ){
                arrPath.push( pathTmp );
            }
        }
        return arrPath;
    }

    getFirstRepeatName(){
        const self = this;
        if( self._data == null ) return null;

        const arrNames = [];
        return self.getFirstRepeatNameInData( self._data, arrNames );
    }

    getFirstRepeatNameInData( data, arrExistNames ){
        const self = this;
        for( const fileName of data.files ){
            const nameTmp = fileName.substr( fileName.lastIndexOf("/") + 1 );
            if( arrExistNames.indexOf(nameTmp) == -1 ){
                arrExistNames.push( nameTmp );
            }else{
                return nameTmp;
            }
        }
        
        for( const dir of data.dir ){
            const repeatName = self.getFirstRepeatNameInData( dir, arrExistNames );
            if( repeatName ){
                return repeatName;
            }
        }

        return null;
    }

    getAllRepeatPath(){
        const self = this;
        self.getAllFilePath();
        const mapPath = new Map();
        for( const path of self._allPath ){
            const name = path.substr( path.lastIndexOf("/") + 1 );
            if( FileList.getFileType( name ) == "meta" ) continue;

            let arrPath = mapPath.get( name );
            if( arrPath == null ){
                arrPath = [];
                mapPath.set( name, arrPath );
            }
            arrPath.push( path );
        }

        const mapRepeatPath = new Map();
        mapPath.forEach((arrPath, name)=>{
            if( arrPath.length > 1 ){
                mapRepeatPath.set( name, arrPath );
            }
        });

        return mapRepeatPath;
    }

    getRepeatFilePathInData( data, arrExistNames, arrRepeatPath ){
        const self = this;
        for( const fileName of data.files ){
            const nameTmp = fileName.substr( fileName.lastIndexOf("/") + 1 );
            if( arrExistNames.indexOf(nameTmp) != -1 ){
                arrRepeatPath.push( self.getFilePath( nameTmp ) );
            }else{
                arrExistNames.push( nameTmp );
            }
        }

        for( const dir of data.dir ){
            self.getRepeatFilePathInData( dir, arrExistNames, arrRepeatPath );
        }
    }

    getFilePath( fileName ){
        const self = this;
        return self.getFilePath2( fileName, self._data, null );
    }

    filterByType( typeName ){
        const self = this;
        const allPath = [];
        self.filterByTypeInData( null, typeName, self._data, allPath );
        return allPath;
    }

    filterByTypeInData( basePath, typeName, data, arrPath ){
        const self = this;
        for( const fn of data.files ){
            if( FileList.getFileType( fn ) == typeName ){
                if( basePath == null ){
                    arrPath.push( fn );
                }else{
                    arrPath.push( basePath + fn );
                }
            }
        }
        
        for( const dir of data.dir ){
            const newDir = basePath ? (basePath + dir.name + "/") : (dir.name + "/");
            self.filterByTypeInData( newDir, typeName, dir, arrPath );
        }
    }

    filterByStr( str ){
        const self = this;
        const allPath = [];
        self.filterByStrInData( null, str, self._data, allPath );
        return allPath;
    }

    filterByStrInData( basePath, str, data, arrPath ){
        const self = this;
        for( const fn of data.files ){
            if( fn.endsWith( str ) ){
                if( basePath == null ){
                    arrPath.push( fn );
                }else{
                    arrPath.push( basePath + fn );
                }
            }
        }
        
        for( const dir of data.dir ){
            const newDir = basePath ? (basePath + dir.name + "/") : (dir.name + "/");
            self.filterByStrInData( newDir, str, dir, arrPath );
        }
    }

    getFilePath2( fileName, data, basePath ){
        const self = this;
        for( const fn of data.files ){
            if( fn == fileName ){
                //return basePath + "/" + FileList.getShortFileName(fn);
                return basePath;
            }
        }

        for( const dir of data.dir ){
            const basePathTmp = basePath ? basePath + "/" + dir.name : dir.name;
            const ret = self.getFilePath2( fileName, dir, basePathTmp );
            if( ret != null ){
                return ret;
            }
        }

        return null;
    }

    writeData2File( fileName ){
        const self = this;
        fs.writeFileSync( fileName, self.dirData2String( self._data ) );
    }

    getShortName(){
        const self = this;
        if( self._data == null ){
            return [];
        }

        const arrName = [];
        self.getDataShortName( self._data, arrName );

        return arrName;
    }

    getDataShortName( data, outNames ){
        const self = this;
        if( data == null ) return;

        for( const fileName of data.files ){
            const name = FileList.getShortFileName( fileName );

            if( outNames.indexOf(fileName) == -1 ){
                outNames.push( fileName );
            }else{
                console.error( `repeat name! dir:${data.name} file:${fileName}` );
            }
        }

        for( const dir of data.dir ){
            self.getDataShortName( dir, outNames );
        }
    }

    static getFileType( fileName ){
        return fileName.substr( fileName.lastIndexOf( "." ) + 1 );
    }

    static getShortFileName( fileName ){
        const startIdx = fileName.lastIndexOf( "/" );
        const endIdx = fileName.lastIndexOf( "." );
        return fileName.substr( startIdx+1, endIdx - startIdx - 1 );
    }

}