import FileTool from "./FileTool.js";
import FileList from "./FileList.js";

const editorKey = "zzz___editor_txt___";

export class I18ChangeTxtBundle {

    _assetDir = "";
    _defaultTxtFileName = "";
    _newTxtFileName = "";

    _assetFile = [];
    _mapTxt = new Map();

    _modifyFile = [];

    constructor( assetDir, defaultTxtFileName, newTxtFileName ){
        const self = this;
        self._assetDir = assetDir;
        self._defaultTxtFileName = defaultTxtFileName;
        self._newTxtFileName = newTxtFileName;
    }

    initTxt( defaultTxtFileName, newTxtFileName ){
        console.log( "-------init txt-------" );
        const self = this;

        self._mapTxt.clear();
        const mapDefaultTxt = self.readTxt( defaultTxtFileName );
        if( !mapDefaultTxt ) return false;

        const mapNewTxt = self.readTxt( newTxtFileName );
        if( !mapNewTxt ) return false;

        for( const k in mapDefaultTxt ){
            const newTxt = mapNewTxt[ k ];
            if( newTxt == null ){
                console.log( `cant find k:${k} in newTxt !` );
                return false;
            }

            self._mapTxt.set( mapDefaultTxt[k], newTxt );
        }
        return true;
    }

    readTxt( fileName ){
        console.log( "read txt file:" + fileName );
        const jsonData = FileTool.readJsonInFile( fileName );
        if( jsonData == null ){
            console.log( "read json failt: " + fullName );
            return null;
        }

        if( jsonData[ editorKey ] == null ){
            console.log( `read jsonData key:${editorKey} fault !` );
            return null;
        }

        return jsonData[ editorKey ];
    }

    initAsset(){
        console.log( "-------init asset-------" );
        const self = this;

        const fl = new FileList();
        fl.initData( self._assetDir );
        self._assetFile = [];

        const allScene = fl.filterByType( "scene" );
        allScene.forEach((fileName)=>{
            self._assetFile.push( self._assetDir + fileName );
        });

        const allPrefab = fl.filterByType( "prefab" );
        allPrefab.forEach((fileName)=>{
            self._assetFile.push( self._assetDir + fileName );
        });
    }

    checkLabel( jsonData ){
        if( jsonData[ "__type__" ] == null ) return false;
        if( jsonData[ "__type__" ] == "cc.Label" ) return true;
        if( jsonData[ "__type__" ] == "cc.RichText" ) return true;
        return false;
    }

    getLabelString( jsonData ){
        const self = this;
        if( !self.checkLabel(jsonData) ) return null;
        return jsonData[ "_string" ];
    }

    checkChinese( str ){
        const pattern = /[\u4E00-\u9FA5]/;
        return pattern.test(str);
    }

    changeTxt(){
        console.log( "-------change txt-------" );
        const self = this;
        self._modifyFile = [];
        for( const fullName of self._assetFile ){
            console.log( "handle file: " + fullName );
            const jsonData = FileTool.readJsonInFile( fullName );
            if( jsonData == null || !Array.isArray(jsonData) ){
                bError = true;
                console.log( "read json failt: " + fullName );
                break;
            }
            
            let bModify = false;
            for( const jsData of jsonData ){
                const str = self.getLabelString( jsData );
                if( str == null || str == "" ) continue;

                const newTxt = self._mapTxt.get( str );
                if( newTxt == null ){
                    if( self.checkChinese(str) ){
                        console.log( "cant find defaultTxt in newTxt. defaultTxt:" + str );
                    }
                    continue;
                }

                jsData[ "_string" ] = newTxt;
                bModify = true;
            }

            if( bModify ){
                FileTool.writeJsonToFile( fullName, jsonData );
                self._modifyFile.push( fullName );
            }
        }
    }

    logModifyFile(){
        console.log("\n--------modify file list--------");
        const self = this;
        self._modifyFile.forEach((fullName)=>{
            console.log( fullName );
        });
    }

    run(){
        console.log( "===========start change txt bundle===========" );

        const self = this;
        if( !self.initTxt( self._defaultTxtFileName, self._newTxtFileName ) ){
            console.log( "please check error then try again !" );
            return [];
        }

        self.initAsset();
        self.changeTxt();
        self.logModifyFile();
        
        console.log( "===========change txt bundle finished===========" );

        return self._modifyFile;
    }
}