import FileTool from "./FileTool.js";

export class I18CheckTxt {

    _txtJson1 = null;
    _txtJson2 = null;

    _keyLost = [];
    _keyAdapter = [];

    constructor( txtFile1, txtFile2 ){
        const self = this;

        self._txtJson1 = FileTool.readJsonInFile( txtFile1 );
        self._txtJson2 = FileTool.readJsonInFile( txtFile2 );
    }

    checkByObj( obj1, obj2, bCheckAdapter = true ){
        if( obj1 == null ) obj1 = {};
        if( obj2 == null ) obj2 = {};

        const self = this
        const keys1 = Object.keys( obj1 );
        const keys2 = Object.keys( obj2 );
        // if( keys1.length != keys2.length ){
        //     console.warn( `key count diff ! keys1=${keys1.length} keys2=${keys2.length}` );
        // }

        const mapKey = new Map();
        for( const k of keys1 ){
            let info = mapKey.get( k );
            if( info == null ){
                info = [ 0, 0 ];
                mapKey.set( k, info );
            }
            info[ 0 ] = 1;
        }

        for( const k of keys2 ){
            let info = mapKey.get( k );
            if( info == null ){
                info = [ 0, 0 ];
                mapKey.set( k, info );
            }
            info[ 1 ] = 1;
        }

        mapKey.forEach(( info, key )=>{
            if( info[1] == 0 ){
                self._keyLost.push( key );
            }
        });

        if( bCheckAdapter ){
            mapKey.forEach( ( info, k )=>{
                if( (info[0] != 1) || (info[0] != info[1]) ) return;                
                const count1 = self.getAdapterCount( obj1[k] );
                const count2 = self.getAdapterCount( obj2[k] );
                if( count1 != count2 ){
                    self._keyAdapter.push( k );
                }
            } );
        }
    }

    getAdapterCount( str ){
        if( str == null ) return 0;
        if( typeof str != "string" ) return 0;

        let count = 0;
        let idx = -1;
        do{
            idx = str.indexOf( `{${count+1}}` );
            if( idx != -1 ){
                ++count;
            }
        }while( idx != -1 );

        return count;
    }

    getContent( obj, key ){
        if( obj == null ) return null;
        if( obj[key] != null ){
            return obj[ key ];
        }else if( obj[ "zzz___editor_txt___" ] ){
            return obj[ "zzz___editor_txt___" ][ key ];
        }
        return null;
    }

    run(){
        console.log( "===========start check txt===========" );
        const self = this;
        self.checkByObj( self._txtJson1["zzz___editor_txt___"], self._txtJson2["zzz___editor_txt___"], false );     
        self.checkByObj( self._txtJson1, self._txtJson2 );

        if( self._keyLost.length > 0 ){
            console.log( "--------key lost--------" );
            for( const k of self._keyLost ){
                console.log( k );
            }
        }

        if( self._keyAdapter.length > 0 ){
            console.log( "\n--------adapter diff--------" );
            for( const k of self._keyAdapter ){
                console.log( k );
                console.log( "----------------" );

                const str1 = self.getContent( self._txtJson1, k );
                console.log( str1 );

                const str2 = self.getContent( self._txtJson2, k );
                console.log( str2 );

                console.log( "" );
            }
        }

        console.log( "===========check txt end===========\n" );
    }


}