import FileList from "./FileList.js";
import FileTool from "./FileTool.js";

export default class I18DeleteCmpt {

    _dir = "";
    _cmptType = "";
    _outFileName = "";

    _arrMate = [];
    _arrDeleteKey = [];
    _arrModifyFile = [];

    constructor( dir, cmptType ){
        const self = this;
        self._dir = dir;
        self._cmptType = cmptType;
        self._arrDeleteKey = [];
        self._arrModifyFile = [];
        self.initData( self._dir );
    }

    initData( dir ){
        const self = this;
        const fl = new FileList();
        fl.initData( dir );

        const allScene = fl.filterByType( "scene" );
        for( const name of allScene ){
            self._arrMate.push( self._dir + name );
        }

        const allPrefab = fl.filterByType( "prefab" );
        for( const name of allPrefab ){
            self._arrMate.push( self._dir + name );
        }
    }

    pushDeleteKey( key ){
        if( key == null ) return;

        const self = this;
        if( self._arrDeleteKey.indexOf( key ) != -1 ) return;
        self._arrDeleteKey.push( key );
    }

    deleteInFile( fileName ){
        const self = this;
        const jsonData = FileTool.readJsonInFile( fileName );
        if( jsonData == null ) return;

        console.log( "\nhand file:" + fileName );

        let bModify = false;
        for( let jsIndex=0; jsIndex<jsonData.length; ++jsIndex ){
            const jsData = jsonData[ jsIndex ];
            if( jsData[ "__type__" ] != self._cmptType ) continue;

            console.log( `find cmpt __id__:${jsIndex}` );
            if( jsData[ "node" ] == null ){
                console.warn( "node is null" );
                continue;
            } 
            if( jsData[ "node" ][ "__id__" ] == null ){
                console.warn( `[ "node" ][ "__id__" ] is null` );
                continue;
            }

            const nodeId = jsData[ "node" ][ "__id__" ];
            const nodeData = jsonData[ nodeId ];
            if( nodeData == null ){
                console.warn(`not found node `);
                continue;
            }

            if( nodeData[ "__type__" ] != "cc.Node" ){
                console.warn( '[ "__type__" ] is not cc.Node' );
                continue;
            }

            const components = nodeData[ "_components" ];
            if( !Array.isArray(components) ){
                console.warn( `[ "_components" ] not a array` );
                continue;
            }
            for( let i=0; i<components.length; ++i ){
                const cmptObj = components[ i ];
                if( cmptObj[ "__id__" ] == null ){
                    console.warn( `cmpt["__id__"] is null` );
                    continue;
                }
                const cmptId = cmptObj[ "__id__" ];
                if( cmptId != jsIndex ) continue;

                const cmptData = jsonData[ cmptId ];
                if( cmptData == null ){
                    console.warn( `cmptData is null, cmptId:${cmptId}` );
                    continue;
                }

                if( cmptData != jsData ){
                    console.warn( `cmptData not this jsData` );
                    break;
                }

                self.pushDeleteKey( jsData[ "_key" ] );
                console.log( "remove cmpt" );
                jsonData[cmptId] = {};
                components.splice( i, 1 );
                bModify = true;
                break;
            }
        }

        if( bModify ){
            self._arrModifyFile.push( fileName );
            FileTool.writeJsonToFile( fileName, jsonData );
            console.log( "write file:" + fileName );
        }
    }

    writeOutDelete(){
        const self = this;
        // if( self._outFileName != null && self._outFileName != "" ){
        //     FileTool.writeJsonToFile( self._outFileName, JSON.parse( self._arrDeleteKey ) );
        // }else{
            console.log( "\n--------delete key list--------" );
            for( const key of self._arrDeleteKey ){
                console.log( key );
            }
        // }

        console.log( "\n--------modify file list--------" );
        for( const fileName of self._arrModifyFile ){
            console.log( fileName );
        }
    }

    run(){
        console.log( "==============start delete cmpt==============" );
        const self = this;
        for( const fileName of self._arrMate ){
            self.deleteInFile( fileName );
        }
        self.writeOutDelete();
        
        console.log( "==============delete cmpt finished==============" );
    }
}