import FileList from "./FileList.js";
import * as fs from "fs";

export default class I18FindI18Key{

    _projectAssetsPath = "";
    _i18CmptType = "";
    _i18Key = "";
    _editorFilePath = [];

    constructor( dir, key ){
        const self = this;
        self._projectAssetsPath = dir;
        self._i18Key = key;
        self.initData();
    }

    setI18CmptType( typeStr ){
        const self = this;
        self._i18CmptType = typeStr;
    }

    initData(){
        console.log( "\n----------init file in editor----------" );
        const self = this;
        const fl = new FileList();
        fl.initData( self._projectAssetsPath );

        const allScene = fl.filterByType( "scene" );
        for( let name of allScene ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
        const allPrefab = fl.filterByType( "prefab" );
        for( let name of allPrefab ){
            self._editorFilePath.push( self._projectAssetsPath + name );
        }
    }

    readJsonInFile( fileName ){
        const str = fs.readFileSync( fileName, "utf8" );
        let jsonData = null;
        try {        
            jsonData = JSON.parse( str );
        } catch (error) {
            console.error( "JSON parse file error, file:" + fileName );
            console.error( error );
            return null;
        }
        return jsonData;
    }

    checkChinese( str ){
        const pattern = /[\u4E00-\u9FA5]/;
        return pattern.test(str);
    }

    run(){
        console.log( "\n----------start find i18Key txt----------" );
        const self = this;
        const arrFile = [];
        for( const fileName of self._editorFilePath ){
            const jsonData = self.readJsonInFile( fileName );
            if( jsonData == null ) continue;

            for( const data of jsonData ){                
                if( data[ "__type__" ] != self._i18CmptType ) continue;
                if( data[ "_key" ] != self._i18Key ) continue;
                arrFile.push( fileName );
                break;
            }
        }

        for( const name of arrFile ){
            console.log( name );
        }

        console.log( "\n----------find i18Key end----------" );
    }

}