
//图片自动放入后可能存在类型问题,默认为texture
//将目录下所有的图片类型从texture转成spriteFrame

import * as fs from "fs";
import FileList from "./FileList.js";

export default class I18Texture2SpriteFrame{

    _dir = "";
    _allMetaPath = [];

    constructor( dir ){
        const self = this;
        self._dir = dir;
        self.initData();
    }

    initData(){
        const self = this;
        const fl = new FileList();
        fl.initData( self._dir );

        self._allMetaPath = fl.filterByStr( ".png.meta" );
    }

    readJsonInFile( fileName ){
        const str = fs.readFileSync( fileName, "utf8" );
        let jsonData = null;
        try {        
            jsonData = JSON.parse( str );
        } catch (error) {
            console.error( "JSON parse file error, file:" + fileName );
            console.error( error );
            return null;
        }
        return jsonData;
    }

    run(){
        const self = this;
        console.log( "=========start change texture to spriteFrame=========" );
        self._allMetaPath.forEach((metaPath)=>{
            const jsonData = self.readJsonInFile( self._dir + metaPath );
            if( jsonData == null ) return;

            if( jsonData[ "userData" ] == null ) return;
            if( jsonData[ "userData" ][ "type" ] != "texture" ) return;

            jsonData[ "userData" ][ "type" ] = "sprite-frame"
            fs.writeFileSync( self._dir + metaPath, JSON.stringify(jsonData, null, 2) );
            console.log( "modify meta file:" + self._dir + metaPath );
        });

        console.log( "=========change texture to spriteFrame finished=========\n\n" );
    }

}