import { _decorator, Component, EventTouch, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {

    @property({ type: Node })
    placeRoot: Node;

    @property({ type: Node })
    dragRoot: Node;

    @property({ type: Node })
    node1: Node;

    @property({ type: Node })
    node2: Node;

    protected start(): void {
        this.node1.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node1.on(Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node1.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node1.on(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);

        this.node2.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node2.on(Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.node2.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node2.on(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);
    }

    private _curTarget: Node = null;;

    private onTouchStart(event: EventTouch) {
        this._curTarget = event.currentTarget;
        this._curTarget.setParent(this.dragRoot);
    }

    private onTouchMove(event: EventTouch) {
        let pos = this._curTarget.getPosition();
        pos.x += event.getUIDelta().x;
        pos.y += event.getUIDelta().y;
        this._curTarget.setPosition(pos);
    }

    private onTouchEnd(event: EventTouch) {
        if (!this._curTarget) {
            return;
        }
        this._curTarget.setParent(this.placeRoot);
    }

    private onTouchCancel(event: EventTouch) {
        if (!this._curTarget) {
            return;
        }
        this._curTarget.setParent(this.placeRoot);
    }





}


