
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/AutoScroll.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b71dbmHabZDYbp1mKiWyuvs', 'AutoScroll');
// Script/AutoScroll.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var EPSILON = 1e-4;
var MOVEMENT_FACTOR = .7;
var quintEaseOut = function (time) {
    time -= 1;
    return (time * time * time * time * time + 1);
};
var AutoScroll = /** @class */ (function (_super) {
    __extends(AutoScroll, _super);
    function AutoScroll() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.maxScale = 1.5;
        _this.minScale = .5;
        _this.zoomSpace = 1;
        _this.bigMap = null;
        _this._touchMovePreviousTimestamp = 0;
        //是否在自动滚动
        _this._autoScrolling = false;
        _this._touchMoveDisplacements = [];
        _this._touchMoveTimeDeltas = [];
        _this.brake = 0.75;
        _this._autoScrollAccumulatedTime = 0;
        _this._autoScrollTotalTime = 0;
        _this._autoScrollStartPosition = cc.v2(0, 0);
        _this._autoScrollTargetDelta = cc.Vec2.ZERO;
        _this._isHandleMultiTouch = false;
        //是否在手动聚焦坐标
        _this._isOnDestScrolling = false;
        return _this;
    }
    AutoScroll.prototype.onLoad = function () {
        this.bigMap.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.bigMap.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.bigMap.on(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.bigMap.on(cc.Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);
    };
    AutoScroll.prototype.onDestroy = function () {
        this.bigMap.off(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.bigMap.off(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.bigMap.off(cc.Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.bigMap.off(cc.Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);
    };
    AutoScroll.prototype.start = function () {
    };
    AutoScroll.prototype.onTouchStart = function (e) {
        this.resetTouchInfos();
    };
    AutoScroll.prototype.onTouchMove = function (e) {
        if (this._isOnDestScrolling) {
            return;
        }
        var touches = e.getTouches();
        if (touches.length == 1) {
            var deltaMove = e.getDelta();
            this.moveContent(deltaMove);
            this.gatherTouchMove(deltaMove);
        }
        else {
            this._isHandleMultiTouch = true;
            var t0 = touches[0];
            var t1 = touches[1];
            var preSpace = t0.getPreviousLocation().sub(t1.getPreviousLocation()).mag();
            var curSpace = t0.getLocation().sub(t1.getLocation()).mag();
            var space = curSpace - preSpace;
            if (true) {
                var center = t0.getStartLocation().add(t1.getStartLocation()).divide(2);
                var n = this.node.convertToNodeSpaceAR(center);
                var w = this.node.convertToWorldSpaceAR(n);
                var nb = this.bigMap.convertToNodeSpaceAR(w);
                var targetScale = this.bigMap.scale + (space >= 0 ? this.zoomSpace : -this.zoomSpace);
                if (targetScale > this.maxScale) {
                    targetScale = this.maxScale;
                }
                else if (targetScale < this.minScale) {
                    targetScale = this.minScale;
                }
                var scaleSpace = targetScale - this.bigMap.scale;
                var v = nb.mul(-scaleSpace);
                //缩放后地图需要反向移动
                this.bigMap.scale = targetScale;
                this.moveContent(v);
            }
        }
    };
    AutoScroll.prototype.onTouchEnd = function (e) {
        if (this._isOnDestScrolling) {
            return;
        }
        if (!this._isHandleMultiTouch) {
            this.gatherTouchMove(e.getDelta());
            this.startInertiaScroll();
        }
        this._isHandleMultiTouch = false;
    };
    AutoScroll.prototype.onTouchCancel = function (e) {
        if (this._isOnDestScrolling) {
            return;
        }
        if (!this._isHandleMultiTouch) {
            this.gatherTouchMove(e.getDelta());
            this.startInertiaScroll();
        }
        this._isHandleMultiTouch = false;
    };
    AutoScroll.prototype.update = function (dt) {
        if (this._autoScrolling) {
            this.processAutoScrolling(dt);
        }
    };
    AutoScroll.prototype.calculateTouchMoveVelocity = function () {
        var totalTime = 0;
        totalTime = this._touchMoveTimeDeltas.reduce(function (a, b) {
            return a + b;
        }, totalTime);
        if (totalTime <= 0 || totalTime >= 0.5) {
            return cc.v2(0, 0);
        }
        var totalMovement = cc.v2(0, 0);
        totalMovement = this._touchMoveDisplacements.reduce(function (a, b) {
            return a.add(b);
        }, totalMovement);
        return cc.v2(totalMovement.x * (1 - this.brake) / totalTime, totalMovement.y * (1 - this.brake) / totalTime);
    };
    AutoScroll.prototype.processAutoScrolling = function (dt) {
        this._autoScrollAccumulatedTime += dt;
        var percentage = Math.min(1, this._autoScrollAccumulatedTime / this._autoScrollTotalTime);
        percentage = quintEaseOut(percentage);
        var newPosition = this._autoScrollStartPosition.add(this._autoScrollTargetDelta.mul(percentage));
        var reachedEnd = Math.abs(percentage - 1) <= EPSILON;
        if (reachedEnd) {
            this._autoScrolling = false;
        }
        var deltaMove = newPosition.sub(this.bigMap.getPosition());
        this.moveContent(this._clampDelta(deltaMove));
    };
    AutoScroll.prototype.startAttenuatingAutoScroll = function (deltaMove, initialVelocity) {
        var time = Math.sqrt(Math.sqrt(initialVelocity.mag() / 5));
        var targetDelta = deltaMove.normalize();
        var contentSize = this.bigMap.getContentSize();
        var scrollviewSize = this.node.getContentSize();
        var totalMoveWidth = (contentSize.width - scrollviewSize.width);
        var totalMoveHeight = (contentSize.height - scrollviewSize.height);
        var attenuatedFactorX = this.calculateAttenuatedFactor(totalMoveWidth);
        var attenuatedFactorY = this.calculateAttenuatedFactor(totalMoveHeight);
        targetDelta = cc.v2(targetDelta.x * totalMoveWidth * (1 - this.brake) * attenuatedFactorX, targetDelta.y * totalMoveHeight * attenuatedFactorY * (1 - this.brake));
        var originalMoveLength = deltaMove.mag();
        var factor = targetDelta.mag() / originalMoveLength;
        targetDelta = targetDelta.add(deltaMove);
        if (this.brake > 0 && factor > 7) {
            factor = Math.sqrt(factor);
            targetDelta = deltaMove.mul(factor).add(deltaMove);
        }
        if (this.brake > 0 && factor > 3) {
            factor = 3;
            time = time * factor;
        }
        if (this.brake === 0 && factor > 1) {
            time = time * factor;
        }
        this.startAutoScroll(targetDelta, time);
    };
    AutoScroll.prototype.calculateAttenuatedFactor = function (distance) {
        if (this.brake <= 0) {
            return (1 - this.brake);
        }
        return (1 - this.brake) * (1 / (1 + distance * 0.000014 + distance * distance * 0.000000008));
    };
    AutoScroll.prototype.startInertiaScroll = function () {
        var touchMoveVelocity = this.calculateTouchMoveVelocity();
        if (!touchMoveVelocity.fuzzyEquals(cc.v2(0, 0), EPSILON) && this.brake < 1) {
            var inertiaTotalMovement = touchMoveVelocity.mul(MOVEMENT_FACTOR);
            this.startAttenuatingAutoScroll(inertiaTotalMovement, touchMoveVelocity);
        }
    };
    AutoScroll.prototype.startAutoScroll = function (deltaMove, timeInSecond) {
        this._autoScrolling = true;
        this._autoScrollTargetDelta = deltaMove;
        this._autoScrollStartPosition = this.bigMap.getPosition();
        this._autoScrollTotalTime = timeInSecond;
        this._autoScrollAccumulatedTime = 0;
    };
    AutoScroll.prototype._clampDelta = function (delta) {
        var contentSize = this.bigMap.getContentSize();
        var scrollViewSize = this.node.getContentSize();
        if (contentSize.width < scrollViewSize.width) {
            delta.x = 0;
        }
        if (contentSize.height < scrollViewSize.height) {
            delta.y = 0;
        }
        return delta;
    };
    AutoScroll.prototype.moveContent = function (deltaMove, duration) {
        var _this = this;
        if (duration === void 0) { duration = 0; }
        return new Promise(function (resolve) {
            var adjustedMove = deltaMove;
            var newPosition = _this.bigMap.getPosition().add(adjustedMove);
            if (newPosition.x > _this.boundX) {
                newPosition.x = _this.boundX;
                _this._autoScrolling = false;
            }
            else if (newPosition.x < -_this.boundX) {
                newPosition.x = -_this.boundX;
                _this._autoScrolling = false;
            }
            if (newPosition.y > _this.boundY) {
                newPosition.y = _this.boundY;
                _this._autoScrolling = false;
            }
            else if (newPosition.y < -_this.boundY) {
                newPosition.y = -_this.boundY;
                _this._autoScrolling = false;
            }
            if (duration > 0) {
                cc.tween(_this.bigMap)
                    .to(duration, { position: cc.v3(newPosition.x, newPosition.y) })
                    .call(function () {
                    resolve();
                })
                    .start();
            }
            else {
                _this.bigMap.setPosition(newPosition);
                resolve();
            }
        });
    };
    AutoScroll.prototype.getTimeInMilliseconds = function () {
        var currentTime = new Date();
        return currentTime.getMilliseconds();
    };
    AutoScroll.prototype.gatherTouchMove = function (delta) {
        delta = this._clampDelta(delta);
        while (this._touchMoveDisplacements.length >= 5) {
            this._touchMoveDisplacements.shift();
            this._touchMoveTimeDeltas.shift();
        }
        this._touchMoveDisplacements.push(delta);
        var timeStamp = this.getTimeInMilliseconds();
        this._touchMoveTimeDeltas.push((timeStamp - this._touchMovePreviousTimestamp) / 1000);
        this._touchMovePreviousTimestamp = timeStamp;
    };
    Object.defineProperty(AutoScroll.prototype, "boundY", {
        get: function () {
            return this.bigMap.height * this.bigMap.scaleY / 2 - this.node.height / 2;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AutoScroll.prototype, "boundX", {
        get: function () {
            return this.bigMap.width * this.bigMap.scaleX / 2 - this.node.width / 2;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 地图滚动
     * @param dest 目标地点
     * @param duration 动画时间
     */
    AutoScroll.prototype.scrollTo = function (dest, duration) {
        var _this = this;
        if (duration === void 0) { duration = 0; }
        this._isOnDestScrolling = true;
        this.resetTouchInfos();
        return new Promise(function (resolve) {
            _this.moveContent(dest.mul(-1), duration).then(function () {
                _this._isOnDestScrolling = false;
                resolve();
            });
        });
    };
    AutoScroll.prototype.resetTouchInfos = function () {
        this._autoScrolling = false;
        this._touchMovePreviousTimestamp = this.getTimeInMilliseconds();
        this._touchMoveDisplacements.length = 0;
        this._touchMoveTimeDeltas.length = 0;
        this._isHandleMultiTouch = false;
    };
    __decorate([
        property({
            tooltip: '最大可放大倍数'
        })
    ], AutoScroll.prototype, "maxScale", void 0);
    __decorate([
        property({
            tooltip: '最小可缩小倍数'
        })
    ], AutoScroll.prototype, "minScale", void 0);
    __decorate([
        property({ tooltip: '多点触摸缩放增量' })
    ], AutoScroll.prototype, "zoomSpace", void 0);
    __decorate([
        property(cc.Node)
    ], AutoScroll.prototype, "bigMap", void 0);
    AutoScroll = __decorate([
        ccclass
    ], AutoScroll);
    return AutoScroll;
}(cc.Component));
exports.default = AutoScroll;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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