cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        camera_part:{
            default: null,
            type: cc.Camera
        },
        texture_sp:{
            default: null,
            type: cc.Sprite
        },
        testNode:{
            default: null,
            type: cc.Node
        }
    },

    // use this for initialization
    onLoad: function () {
        
    },
    start(){
        this.m_partTexture = new cc.RenderTexture();
        this.m_partTexture.setPremultiplyAlpha(true);
        this.m_partTexture.initWithSize(cc.view.getVisibleSize().width, cc.view.getVisibleSize().height,cc.RenderTexture.DepthStencilFormat.RB_FMT_S8);
        let camera = this.camera_part.getComponent(cc.Camera);
        camera.targetTexture =  this.m_partTexture;
    },
    // called every frame
    update: function (dt) {
        this.camera_part.getComponent(cc.Camera).render();
        let camera = this.camera_part.getComponent(cc.Camera);
        let texture = camera.targetTexture;
        let spriteFrame = new cc.SpriteFrame();
        spriteFrame.setTexture(texture);
        this.texture_sp.node.scaleY = -1;
        this.texture_sp.spriteFrame = spriteFrame;
        if(this.direction){
            this.testNode.x-= 3;
        }else{
            this.testNode.x+= 3;
        }
    },
    btnBack(tag,data){
        if(data == "1"){
            this.direction = true;
            
        }else{
            this.direction = false;
        }
    }
});
