
import { _decorator, Component, Node, systemEvent, SystemEventType, Vec2, v2, EventAcceleration } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {

    start() {
        systemEvent.setAccelerometerEnabled(true);
        systemEvent.setAccelerometerInterval(1 / 60);
        systemEvent.on(SystemEventType.DEVICEMOTION, this._onDeviceMotion, this);
    }

    onDestory() {
        systemEvent.off(SystemEventType.DEVICEMOTION, this._onDeviceMotion, this);
        systemEvent.setAccelerometerEnabled(false);
    }

    private _acc: Vec2 = v2(0, 0);

    private _direction: number = 0;

    private _onDeviceMotion(event: EventAcceleration) {
        this._acc.x = event.acc.x;
        this._acc.y = event.acc.y;
        this._direction = event.acc.x < 0 ? 1 : 2;
        console.log("重力感应事件", this._acc.x, this._direction);
    }
}
