!function(){"use strict";class e{constructor(e){this.tooltip=null,this.tooltipTimer=null,this.parent=e,this.applyStyles()}applyStyles(){const e=document.createElement("style");e.textContent="\n            .global-inspector-tooltip {\n                position: fixed; /* 使用 fixed 定位，相对于视口 */\n                background-color: rgba(0, 0, 0, 0.8);\n                color: white;\n                padding: 8px 12px;\n                border-radius: 5px;\n                font-size: 12px;\n                z-index: 9999; /* 确保在最顶层 */\n                pointer-events: none;\n                opacity: 0;\n                transition: opacity 0.3s ease;\n                white-space: nowrap; /* 防止文本换行 */\n            }\n\n            .global-inspector-tooltip.show {\n                opacity: 1;\n            }\n        ",document.head.appendChild(e)}show(e,t){this.tooltipTimer&&clearTimeout(this.tooltipTimer),this.tooltip||(this.tooltip=document.createElement("div"),this.tooltip.className="global-inspector-tooltip",this.parent.appendChild(this.tooltip)),this.tooltip.textContent=e;const n=t.getBoundingClientRect(),i=this.tooltip.getBoundingClientRect(),o=n.top-40,r=n.left+n.width/2-i.width/2;this.tooltip.style.top=`${o}px`,this.tooltip.style.left=`${r}px`,this.tooltip.offsetWidth,this.tooltip.classList.add("show"),this.tooltipTimer=window.setTimeout((()=>{this.tooltip&&this.tooltip.classList.remove("show")}),2e3)}}class t{constructor(){this.container=null,this.content=null,this.toggleButton=null,this.resizeHandle=null,this.isOpen=!1,this.toggleCallback=null,this.isResizing=!1,this.startX=0,this.startWidth=0,this.minWidth=150,this.maxWidth=800,this.defaultWidth=300,this.tooltipManager=null}create(){this.createContainer(),this.createToggleButton(),this.createContent(),this.createResizeHandle(),this.applyStyles(),this.bindEvents(),this.bindResizeEvents(),this.setInitialState(),this.tooltipManager=new e(this.container)}createContainer(){this.container=document.createElement("div"),this.container.id="node-inspector-drawer",this.container.style.width=`${this.defaultWidth}px`,document.body.appendChild(this.container)}createToggleButton(){this.toggleButton=document.createElement("div"),this.toggleButton.id="node-inspector-toggle",this.toggleButton.innerHTML="节<br>点<br>树",this.toggleButton.title="切换节点调试器",this.container.appendChild(this.toggleButton)}createContent(){this.content=document.createElement("div"),this.content.id="node-inspector-content",this.container.appendChild(this.content)}createResizeHandle(){this.resizeHandle=document.createElement("div"),this.resizeHandle.id="node-inspector-resize-handle",this.container.appendChild(this.resizeHandle)}applyStyles(){const e=document.createElement("style");e.textContent=`\n            #node-inspector-drawer {\n                position: fixed;\n                top: 0;\n                left: 0;\n                height: 100vh;\n                background: #2d2d2d;\n                border-right: 1px solid #444;\n                z-index: 10000;\n                transition: transform 0.3s ease;\n                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n                font-size: 12px;\n                color: #fff;\n                box-shadow: 2px 0 10px rgba(0,0,0,0.3);\n                min-width: ${this.minWidth}px;\n                max-width: ${this.maxWidth}px;\n            }\n\n            #node-inspector-drawer.closed {\n                transform: translateX(-100%);\n            }\n\n            #node-inspector-toggle {\n                position: absolute;\n                top: calc(50vh - 100px);\n                right: -30px;\n                transform: translateY(-50%);\n                width: 30px;\n                height: 160px;\n                background: #2d2d2d;\n                border: 1px solid #444;\n                border-left: none;\n                border-radius: 0 5px 5px 0;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                cursor: pointer;\n                font-size: 14px;\n                color: #fff;\n                user-select: none;\n                transition: background 0.2s ease;\n            }\n\n            #node-inspector-toggle:hover {\n                background: #3d3d3d;\n            }\n\n            #node-inspector-resize-handle {\n                position: absolute;\n                top: 0;\n                right: 0;\n                width: 4px;\n                height: 100%;\n                background: transparent;\n                cursor: col-resize;\n                z-index: 1001;\n                transition: background 0.2s ease;\n            }\n\n            #node-inspector-resize-handle:hover {\n                background: #0078d4;\n            }\n\n            #node-inspector-content {\n                width: 100%;\n                height: 100%;\n                overflow: hidden;\n                display: flex;\n                flex-direction: column;\n                padding-right: 4px;\n            }\n\n            .node-inspector-panel {\n                background: #2d2d2d;\n                border-bottom: 1px solid #444;\n                overflow: auto;\n            }\n\n            .node-inspector-panel h3 {\n                margin: 0;\n                padding: 10px;\n                font-size: 14px;\n                font-weight: bold;\n            }\n\n            .node-tree {\n                flex: 1;\n                min-height: 200px;\n                display: flex;\n                flex-direction: column;\n                overflow: auto;\n            }\n\n            .property-panel {\n                flex: 0 0 auto;\n                min-height: auto;\n            }\n\n            /* 滚动条样式 */\n            .node-inspector-panel::-webkit-scrollbar {\n                width: 8px;\n            }\n\n            .node-inspector-panel::-webkit-scrollbar-track {\n                background: #1e1e1e;\n            }\n\n            .node-inspector-panel::-webkit-scrollbar-thumb {\n                background: #555;\n                border-radius: 4px;\n            }\n\n            .node-inspector-panel::-webkit-scrollbar-thumb:hover {\n                background: #666;\n            }\n\n            /* 拖拽时的样式 */\n            body.resizing-drawer {\n                user-select: none;\n                cursor: col-resize !important;\n            }\n\n            body.resizing-drawer * {\n                pointer-events: none !important;\n            }\n\n            body.resizing-drawer #node-inspector-drawer {\n                pointer-events: auto !important;\n            }\n\n            body.resizing-drawer #node-inspector-resize-handle {\n                pointer-events: auto !important;\n            }\n\n            /* 防止iframe或canvas干扰 */\n            body.resizing-drawer iframe,\n            body.resizing-drawer canvas,\n            body.resizing-drawer embed,\n            body.resizing-drawer object {\n                pointer-events: none !important;\n            }\n        `,document.head.appendChild(e)}bindEvents(){this.toggleButton&&this.toggleButton.addEventListener("click",(()=>{this.toggle()}))}toggle(){this.container&&(this.isOpen=!this.isOpen,this.isOpen?this.container.classList.remove("closed"):(this.container.classList.add("closed"),window.selectNode=void 0),this.toggleCallback&&this.toggleCallback(this.isOpen))}onToggle(e){this.toggleCallback=e}getContentContainer(){return this.content}destroy(){this.container&&this.container.parentNode&&this.container.parentNode.removeChild(this.container),this.container=null,this.content=null,this.toggleButton=null,this.resizeHandle=null}setInitialState(){this.container&&this.container.classList.add("closed")}bindResizeEvents(){this.resizeHandle&&(this.resizeHandle.addEventListener("mousedown",(e=>{this.startResize(e)})),document.addEventListener("mousemove",(e=>{this.handleResize(e)}),{capture:!0}),document.addEventListener("mouseup",(e=>{this.stopResize()}),{capture:!0}),document.addEventListener("mouseleave",(()=>{this.stopResize()})),window.addEventListener("blur",(()=>{this.stopResize()})))}startResize(e){this.isResizing=!0,this.startX=e.clientX,this.startWidth=this.container.clientWidth,document.body.classList.add("resizing-drawer"),this.resizeHandle.style.background="#0078d4",e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()}handleResize(e){if(!this.isResizing)return;const t=e.clientX-this.startX,n=Math.max(this.minWidth,Math.min(this.maxWidth,this.startWidth+t));this.container.style.width=`${n}px`,e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()}stopResize(){this.isResizing&&(this.isResizing=!1,document.body.classList.remove("resizing-drawer"),this.resizeHandle.style.background="")}showTooltip(e,t){this.tooltipManager&&this.tooltipManager.show(e,t)}resetWidth(){this.container&&(this.container.style.width=`${this.defaultWidth}px`)}}class n{static calculate(e){return this.calculateAnimationSize(e)}static calculateAnimationSize(e){try{let t=0;t+=1024;const n=e._duration||e.duration||0,i=e.sample||e.frameRate||60,o=Math.ceil(n*i);if(e.curveData&&e.curveData.paths){const n=e.curveData.paths;let i=0,o=0;for(const e in n){const r=n[e];if(r.props)for(const e in r.props){o++;const n=r.props[e];Array.isArray(n)&&(i+=n.length,n.forEach((e=>{t+=32,Array.isArray(e.value)?t+=8*e.value.length:"number"==typeof e.value?t+=8:"string"==typeof e.value&&(t+=2*e.value.length),e.curve&&(t+=16)})))}}}if(e.events&&Array.isArray(e.events)&&e.events.forEach((e=>{t+=64,e.func&&"string"==typeof e.func&&(t+=2*e.func.length),e.params&&Array.isArray(e.params)&&(t+=16*e.params.length)})),o>300?t+=4096:o>100&&(t+=2048),t<2048){const n=(e._name||"").toLowerCase();t=n.includes("ui")||n.includes("button")?4096:n.includes("character")||n.includes("walk")||n.includes("run")?16384:n.includes("effect")||n.includes("particle")?8192:n.includes("camera")||n.includes("scene")?12288:6144}return t}catch(e){return console.warn("计算动画大小时出错:",e),6144}}}class i{static calculate(e){return this.calculateAudioSize(e)}static calculateAudioSize(e){var t,n,i,o,r,s,a,l,c,d,h,u;try{const p=null===(n=null===(t=null==e?void 0:e._player)||void 0===t?void 0:t._player)||void 0===n?void 0:n._audioBuffer;if(p&&p.length&&p.numberOfChannels){const e=Math.max(0,Math.min(p.length,6912e5)),t=e*Math.max(1,Math.min(p.numberOfChannels,8))*4;if(t>0&&t<1073741824){p.sampleRate,p.duration;return t}}if(e._audio&&e._audio instanceof AudioBuffer){const t=e._audio,n=Math.max(0,Math.min(t.length,6912e5)),i=n*Math.max(1,Math.min(t.numberOfChannels,8))*4;if(i>0&&i<1073741824){t.sampleRate,t.duration;return i}}if(e._audioBuffer){const t=e._audioBuffer;if(t.length&&t.numberOfChannels){const e=Math.max(0,Math.min(t.length,6912e5)),n=e*Math.max(1,Math.min(t.numberOfChannels,8))*4;if(n>0&&n<1073741824)return n}if(t.byteLength&&t.byteLength>0&&t.byteLength<1073741824)return t.byteLength}let g=0;if("number"==typeof e._duration&&e._duration>0?g=e._duration:"number"==typeof e.duration&&e.duration>0?g=e.duration:"number"==typeof(null===(o=null===(i=null==e?void 0:e._player)||void 0===i?void 0:i._player)||void 0===o?void 0:o.duration)&&e._player._player.duration>0?g=e._player._player.duration:"number"==typeof(null===(r=e._meta)||void 0===r?void 0:r.duration)&&e._meta.duration>0&&(g=e._meta.duration),g>0&&g<3600){let t=44100,n=2;"number"==typeof e.sampleRate&&e.sampleRate>0&&e.sampleRate<=192e3?t=e.sampleRate:"number"==typeof(null===(a=null===(s=null==e?void 0:e._player)||void 0===s?void 0:s._player)||void 0===a?void 0:a.sampleRate)&&e._player._player.sampleRate>0&&e._player._player.sampleRate<=192e3&&(t=e._player._player.sampleRate),"number"==typeof e.channels&&e.channels>0&&e.channels<=8?n=e.channels:"number"==typeof(null===(c=null===(l=null==e?void 0:e._player)||void 0===l?void 0:l._player)||void 0===c?void 0:c.channels)&&e._player._player.channels>0&&e._player._player.channels<=8&&(n=e._player._player.channels);const i=g*t*n*4;if(i>0&&i<1073741824)return i}let m="";if("string"==typeof e._nativeUrl?m=e._nativeUrl.toLowerCase():"string"==typeof e.url?m=e.url.toLowerCase():"string"==typeof(null===(d=e._meta)||void 0===d?void 0:d.url)?m=e._meta.url.toLowerCase():"string"==typeof(null===(u=null===(h=null==e?void 0:e._player)||void 0===h?void 0:h._player)||void 0===u?void 0:u.src)&&(m=e._player._player.src.toLowerCase()),m){if(m.includes(".mp3"))return 131072;if(m.includes(".wav"))return 524288;if(m.includes(".ogg"))return 204800;if(m.includes(".m4a")||m.includes(".aac"))return 153600}return 131072}catch(e){return console.warn("计算音频大小时出错:",e),131072}}}class o{static calculate(e){return this.calculateBufferSize(e)}static calculateBufferSize(e){try{if(e._buffer&&e._buffer instanceof ArrayBuffer){return e._buffer.byteLength}if(e.buffer&&e.buffer instanceof ArrayBuffer)return e.buffer.byteLength;if(void 0!==e.byteLength)return e.byteLength;if(void 0!==e.length)return e.length;if(e._serialized&&e._serialized.data){if(e._serialized.data.byteLength)return e._serialized.data.byteLength;if(e._serialized.data.length)return e._serialized.data.length}const t=(e._nativeUrl||e.url||"").toLowerCase();return t.includes(".bin")?51200:t.includes(".dat")?30720:10240}catch(e){return console.warn("计算BufferAsset大小时出错:",e),10240}}}class r{static calculate(e){return this.calculateAssetSize(e)}static calculateAssetSize(e){var t,n;try{if(".atlas"===e._native||(null===(n=null===(t=e._native)||void 0===t?void 0:t.endsWith)||void 0===n?void 0:n.call(t,".atlas")))return this.calculateSpineAtlasSize(e);if(e._file&&"string"==typeof e._file){return new Blob([e._file]).size}return 1024}catch(e){return console.warn("计算Asset大小时出错:",e),1024}}static calculateSpineAtlasSize(e){try{const t=e._file||e.nativeAsset||"";return new Blob([t]).size}catch(e){return console.warn("计算Spine Atlas大小时出错:",e),2048}}}class s{static calculate(e){return this.calculateEffectSize(e)}static calculateEffectSize(e){try{let t=0;if(e.shaders&&Array.isArray(e.shaders)&&e.shaders.forEach((e=>{e.glsl3&&(e.glsl3.vert&&(t+=2*e.glsl3.vert.length),e.glsl3.frag&&(t+=2*e.glsl3.frag.length)),e.glsl1&&(e.glsl1.vert&&(t+=2*e.glsl1.vert.length),e.glsl1.frag&&(t+=2*e.glsl1.frag.length)),e.defines&&Array.isArray(e.defines)&&(t+=50*e.defines.length),e.builtins&&(t+=2*JSON.stringify(e.builtins).length)})),e.techniques&&Array.isArray(e.techniques)&&e.techniques.forEach((e=>{e.passes&&Array.isArray(e.passes)&&e.passes.forEach((e=>{t+=1024,e.blendState&&(t+=256),e.rasterizerState&&(t+=128),e.properties&&(t+=2*JSON.stringify(e.properties).length),e.program&&(t+=2*e.program.length)}))})),e._effect&&(t+=2048),e.properties)try{t+=2*JSON.stringify(e.properties).length}catch(e){t+=512}if(0===t){const n=e._name||"";t=n.includes("builtin")?8192:n.includes("ui")||n.includes("sprite")?4096:n.includes("particle")||n.includes("effect")?16384:12288}return t}catch(e){return console.warn("计算特效大小时出错:",e),8192}}}class a{static calculate(e){return this.calculateImageAssetSize(e)}static calculateImageAssetSize(e){try{const t=e._width||e.width||0,n=e._height||e.height||0;if(t>0&&n>0){const i=Math.max(1,Math.min(t,8192)),o=Math.max(1,Math.min(n,8192));let r=4,s="RGBA8888",a=e._format||e.format;const l=this.getFormatInfoFrom3x(a);return r=l.bytesPerPixel,s=l.name,i*o*r}return console.warn("3.x中未取到图像尺寸，使用默认值"),65536}catch(e){return console.warn("计算图像资源大小时出错:",e),65536}}static getFormatInfoFrom3x(e){return{0:{bytesPerPixel:4,name:"UNKNOWN"},1:{bytesPerPixel:1,name:"A8"},2:{bytesPerPixel:1,name:"L8"},3:{bytesPerPixel:2,name:"LA8"},4:{bytesPerPixel:1,name:"R8"},5:{bytesPerPixel:1,name:"R8SN"},6:{bytesPerPixel:1,name:"R8UI"},7:{bytesPerPixel:1,name:"R8I"},8:{bytesPerPixel:2,name:"R16F"},9:{bytesPerPixel:2,name:"R16UI"},10:{bytesPerPixel:2,name:"R16I"},11:{bytesPerPixel:4,name:"R32F"},12:{bytesPerPixel:4,name:"R32UI"},13:{bytesPerPixel:4,name:"R32I"},14:{bytesPerPixel:2,name:"RG8"},15:{bytesPerPixel:2,name:"RG8SN"},16:{bytesPerPixel:2,name:"RG8UI"},17:{bytesPerPixel:2,name:"RG8I"},18:{bytesPerPixel:4,name:"RG16F"},19:{bytesPerPixel:4,name:"RG16UI"},20:{bytesPerPixel:4,name:"RG16I"},21:{bytesPerPixel:8,name:"RG32F"},22:{bytesPerPixel:8,name:"RG32UI"},23:{bytesPerPixel:8,name:"RG32I"},24:{bytesPerPixel:3,name:"RGB8"},25:{bytesPerPixel:3,name:"SRGB8"},26:{bytesPerPixel:3,name:"RGB8SN"},27:{bytesPerPixel:3,name:"RGB8UI"},28:{bytesPerPixel:3,name:"RGB8I"},29:{bytesPerPixel:6,name:"RGB16F"},30:{bytesPerPixel:6,name:"RGB16UI"},31:{bytesPerPixel:6,name:"RGB16I"},32:{bytesPerPixel:12,name:"RGB32F"},33:{bytesPerPixel:12,name:"RGB32UI"},34:{bytesPerPixel:12,name:"RGB32I"},35:{bytesPerPixel:4,name:"RGBA8"},36:{bytesPerPixel:4,name:"BGRA8"},37:{bytesPerPixel:4,name:"SRGB8_A8"},38:{bytesPerPixel:4,name:"RGBA8SN"},39:{bytesPerPixel:4,name:"RGBA8UI"},40:{bytesPerPixel:4,name:"RGBA8I"},41:{bytesPerPixel:8,name:"RGBA16F"},42:{bytesPerPixel:8,name:"RGBA16UI"},43:{bytesPerPixel:8,name:"RGBA16I"},44:{bytesPerPixel:16,name:"RGBA32F"},45:{bytesPerPixel:16,name:"RGBA32UI"},46:{bytesPerPixel:16,name:"RGBA32I"},47:{bytesPerPixel:2,name:"R5G6B5"},48:{bytesPerPixel:4,name:"R11G11B10F"},49:{bytesPerPixel:2,name:"RGB5A1"},50:{bytesPerPixel:2,name:"RGBA4"},51:{bytesPerPixel:4,name:"RGB10A2"},52:{bytesPerPixel:4,name:"RGB10A2UI"},53:{bytesPerPixel:4,name:"RGB9E5"},54:{bytesPerPixel:4,name:"DEPTH"},55:{bytesPerPixel:4,name:"DEPTH_STENCIL"},56:{bytesPerPixel:.5,name:"BC1"},57:{bytesPerPixel:.5,name:"BC1_ALPHA"},58:{bytesPerPixel:.5,name:"BC1_SRGB"},59:{bytesPerPixel:.5,name:"BC1_SRGB_ALPHA"},60:{bytesPerPixel:1,name:"BC2"},61:{bytesPerPixel:1,name:"BC2_SRGB"},62:{bytesPerPixel:1,name:"BC3"},63:{bytesPerPixel:1,name:"BC3_SRGB"},64:{bytesPerPixel:.5,name:"BC4"},65:{bytesPerPixel:.5,name:"BC4_SNORM"},66:{bytesPerPixel:1,name:"BC5"},67:{bytesPerPixel:1,name:"BC5_SNORM"},68:{bytesPerPixel:1,name:"BC6H_UF16"},69:{bytesPerPixel:1,name:"BC6H_SF16"},70:{bytesPerPixel:1,name:"BC7"},71:{bytesPerPixel:1,name:"BC7_SRGB"},72:{bytesPerPixel:.5,name:"ETC_RGB8"},73:{bytesPerPixel:.5,name:"ETC2_RGB8"},74:{bytesPerPixel:.5,name:"ETC2_SRGB8"},75:{bytesPerPixel:.5,name:"ETC2_RGB8_A1"},76:{bytesPerPixel:.5,name:"ETC2_SRGB8_A1"},77:{bytesPerPixel:1,name:"ETC2_RGBA8"},78:{bytesPerPixel:1,name:"ETC2_SRGB8_A8"},79:{bytesPerPixel:.5,name:"EAC_R11"},80:{bytesPerPixel:.5,name:"EAC_R11SN"},81:{bytesPerPixel:1,name:"EAC_RG11"},82:{bytesPerPixel:1,name:"EAC_RG11SN"},83:{bytesPerPixel:.25,name:"PVRTC_RGB2"},84:{bytesPerPixel:.25,name:"PVRTC_RGBA2"},85:{bytesPerPixel:.5,name:"PVRTC_RGB4"},86:{bytesPerPixel:.5,name:"PVRTC_RGBA4"},87:{bytesPerPixel:.25,name:"PVRTC2_2BPP"},88:{bytesPerPixel:.5,name:"PVRTC2_4BPP"},89:{bytesPerPixel:1,name:"ASTC_RGBA_4X4"},90:{bytesPerPixel:.8,name:"ASTC_RGBA_5X4"},91:{bytesPerPixel:.64,name:"ASTC_RGBA_5X5"},92:{bytesPerPixel:16/30,name:"ASTC_RGBA_6X5"},93:{bytesPerPixel:16/36,name:"ASTC_RGBA_6X6"},94:{bytesPerPixel:.4,name:"ASTC_RGBA_8X5"},95:{bytesPerPixel:16/48,name:"ASTC_RGBA_8X6"},96:{bytesPerPixel:.25,name:"ASTC_RGBA_8X8"},97:{bytesPerPixel:.32,name:"ASTC_RGBA_10X5"},98:{bytesPerPixel:16/60,name:"ASTC_RGBA_10X6"},99:{bytesPerPixel:.2,name:"ASTC_RGBA_10X8"},100:{bytesPerPixel:.16,name:"ASTC_RGBA_10X10"},101:{bytesPerPixel:16/120,name:"ASTC_RGBA_12X10"},102:{bytesPerPixel:16/144,name:"ASTC_RGBA_12X12"},103:{bytesPerPixel:1,name:"ASTC_SRGBA_4X4"},104:{bytesPerPixel:.8,name:"ASTC_SRGBA_5X4"},105:{bytesPerPixel:.64,name:"ASTC_SRGBA_5X5"},106:{bytesPerPixel:16/30,name:"ASTC_SRGBA_6X5"},107:{bytesPerPixel:16/36,name:"ASTC_SRGBA_6X6"},108:{bytesPerPixel:.4,name:"ASTC_SRGBA_8X5"},109:{bytesPerPixel:16/48,name:"ASTC_SRGBA_8X6"},110:{bytesPerPixel:.25,name:"ASTC_SRGBA_8X8"},111:{bytesPerPixel:.32,name:"ASTC_SRGBA_10X5"},112:{bytesPerPixel:16/60,name:"ASTC_SRGBA_10X6"},113:{bytesPerPixel:.2,name:"ASTC_SRGBA_10X8"},114:{bytesPerPixel:.16,name:"ASTC_SRGBA_10X10"},115:{bytesPerPixel:16/120,name:"ASTC_SRGBA_12X10"},116:{bytesPerPixel:16/144,name:"ASTC_SRGBA_12X12"}}[e]||{bytesPerPixel:4,name:"Unknown"}}}class l{static calculate(e){return this.calculateJSONSize(e)}static calculateJSONSize(e,t=0){try{if(t>50)return console.warn("JSON递归深度超过限制，停止计算"),1024;if(null==e)return 4;let n=0;if("string"==typeof e){return 2*Math.min(e.length,1e7)}if("number"==typeof e)return 8;if("boolean"==typeof e)return 1;if(Array.isArray(e)){n+=24;for(let i=0;i<Math.min(e.length,1e5);i++)n+=this.calculateJSONSize(e[i],t+1);return n}if("object"==typeof e){n+=24;let i=0;for(let o in e)if(e.hasOwnProperty(o)){if(i++,i>1e4){console.warn("JSON对象属性数量超过限制，停止计算");break}n+=2*Math.min(o.length,1e3),n+=this.calculateJSONSize(e[o],t+1),n+=16}return n}return 8}catch(e){return console.warn("计算JSON大小时出错:",e),10240}}}class c{static calculate(e){return this.calculateMaterialSize(e)}static calculateMaterialSize(e){try{let t=0;if(t+=1024,e._effect?t+=s.calculate(e._effect):e._effectAsset&&(t+=s.calculate(e._effectAsset)),e._props)try{t+=2*JSON.stringify(e._props).length}catch(e){t+=1024}if(e._defines)try{t+=2*JSON.stringify(e._defines).length}catch(e){t+=512}if(e._states&&(t+=256),t<=2048){const n=(e._name||"").toLowerCase();t=n.includes("builtin")?8192:n.includes("ui")||n.includes("sprite")?4096:n.includes("particle")||n.includes("effect")?12288:n.includes("3d")||n.includes("pbr")?16384:6144}return(e.refCount||e._ref||1)>5&&(t+=2048),t}catch(e){return console.warn("计算材质大小时出错:",e),6144}}}class d{static calculate(e){return this.calculateMeshSize(e)}static calculateMeshSize(e){try{if(e.vertexCount&&"number"==typeof e.vertexCount){const t=32*Math.max(0,Math.min(e.vertexCount,1e7));return t>1073741824?1048576:t}if(e._vertexCount&&"number"==typeof e._vertexCount){return 32*Math.max(0,Math.min(e._vertexCount,1e7))}if(e._vertexBuffer&&e._vertexBuffer.byteLength){return Math.min(e._vertexBuffer.byteLength,1073741824)}return 1048576}catch(e){return console.warn("计算网格大小时出错:",e),1048576}}}class h{static calculate(e){return this.calculatePrefabSize(e)}static calculatePrefabSize(e){try{let t=0;if(t+=2048,e.data&&(t+=this.calculateNodeTreeSize(e.data)),t<=2048&&e._data&&(t+=this.calculateNodeTreeSize(e._data)),t<=2048){const n=(e._name||"").toLowerCase(),i=(e._nativeUrl||"").toLowerCase();t=n.includes("ui")||i.includes("ui")||n.includes("button")?51200:n.includes("character")||n.includes("player")||i.includes("character")?153600:n.includes("effect")||n.includes("particle")||i.includes("effect")?81920:n.includes("scene")||n.includes("level")?204800:30720}return t}catch(e){return console.warn("计算预制体大小时出错:",e),30720}}static calculateNodeTreeSize(e){if(!e)return 0;let t=0;try{t+=1024,e._components&&Array.isArray(e._components)&&e._components.forEach((e=>{t+=this.calculateComponentSize(e)})),e._trs&&e._trs.byteLength&&(t+=e._trs.byteLength),e._worldMatrix&&(t+=64),e._children&&Array.isArray(e._children)&&e._children.forEach((e=>{t+=this.calculateNodeTreeSize(e)}))}catch(e){console.warn("计算节点树大小时出错:",e),t=1024}return t}static calculateComponentSize(e){var t;if(!e)return 0;try{switch((null===(t=e.constructor)||void 0===t?void 0:t.name)||""){case"cc_Sprite":case"Sprite":return 2048;case"cc_Label":case"Label":case"cc_RigidBody":case"RigidBody":return 1024;case"cc_Button":case"Button":return 1536;case"cc_Animation":case"Animation":return 4096;case"cc_Collider":case"Collider":default:return 512;case"cc_AudioSource":case"AudioSource":return 768;case"cc_ParticleSystem":case"ParticleSystem":return 8192}}catch(e){return 512}}}class u{static calculate(e){return this.calculateSkeletonDataSize(e)}static calculateSkeletonDataSize(e){try{let t=0;if(t+=2048,e._buffer&&e._buffer instanceof ArrayBuffer&&(t+=e._buffer.byteLength),e._atlasText&&(t+=2*e._atlasText.length),e.textures&&Array.isArray(e.textures)&&e.textures.forEach((e=>{e&&(t+=64)})),e._skeletonJson)try{t+=2*JSON.stringify(e._skeletonJson).length}catch(e){t+=10240}else e.skeletonJsonStr&&(t+=2*e.skeletonJsonStr.length);const n=e.textureNames?e.textureNames.length:0,i=e.scale||1;n>5?t+=8192:n>2&&(t+=4096),i>1.5&&(t+=6144);if((e.refCount||e._ref||1)>3&&(t+=4096),t<5120){const n=(e._name||"").toLowerCase();t=n.includes("character")||n.includes("hero")?51200:n.includes("effect")||n.includes("fx")?30720:n.includes("ui")||n.includes("button")?15360:25600}return t}catch(e){return console.warn("计算骨骼数据大小时出错:",e),25600}}}class p{static calculate(e){return this.calculateTextAssetSize(e)}static calculateTextAssetSize(e){try{let t="";if(e.text?t=e.text:e._text?t=e._text:e.nativeAsset&&"string"==typeof e.nativeAsset?t=e.nativeAsset:e._file&&"string"==typeof e._file&&(t=e._file),t&&"string"==typeof t){const e=2*t.length;return e+100}return console.warn("TextAsset没有找到文本内容，使用默认大小"),1024}catch(e){return console.warn("计算TextAsset大小时出错:",e),1024}}}class g{static calculate(e){return this.calculateTextureSize(e)}static calculateTextureSize(e){try{const t=e.width||e._width||0,n=e.height||e._height||0;if(t>0&&n>0){const i=Math.max(1,Math.min(t,8192)),o=Math.max(1,Math.min(n,8192));let r=e._format||e.format;return i*o*this.getFormatInfoFrom2x(r).bytesPerPixel}return console.warn("2.x中未取到纹理尺寸，使用默认值"),16384}catch(e){return console.warn("计算纹理大小时出错:",e),16384}}static getFormatInfoFrom2x(e){if(void 0===e)return console.warn("2.x中未取到纹理格式，使用默认值"),{bytesPerPixel:4,name:"RGBA8888"};return{0:{bytesPerPixel:.5,name:"RGB_DXT1"},1:{bytesPerPixel:.5,name:"RGBA_DXT1"},2:{bytesPerPixel:1,name:"RGBA_DXT3"},3:{bytesPerPixel:1,name:"RGBA_DXT5"},4:{bytesPerPixel:.5,name:"RGB_ETC1"},5:{bytesPerPixel:.25,name:"RGB_PVRTC_2BPPV1"},6:{bytesPerPixel:.25,name:"RGBA_PVRTC_2BPPV1"},7:{bytesPerPixel:.5,name:"RGB_PVRTC_4BPPV1"},8:{bytesPerPixel:.5,name:"RGBA_PVRTC_4BPPV1"},9:{bytesPerPixel:1,name:"A8"},10:{bytesPerPixel:1,name:"L8"},11:{bytesPerPixel:2,name:"L8_A8"},12:{bytesPerPixel:2,name:"R5_G6_B5"},13:{bytesPerPixel:2,name:"R5_G5_B5_A1"},14:{bytesPerPixel:2,name:"R4_G4_B4_A4"},15:{bytesPerPixel:3,name:"RGB8"},16:{bytesPerPixel:4,name:"RGBA8"},17:{bytesPerPixel:6,name:"RGB16F"},18:{bytesPerPixel:8,name:"RGBA16F"},19:{bytesPerPixel:12,name:"RGB32F"},20:{bytesPerPixel:16,name:"RGBA32F"},21:{bytesPerPixel:4,name:"R32F"},22:{bytesPerPixel:4,name:"111110F"},23:{bytesPerPixel:3,name:"SRGB"},24:{bytesPerPixel:4,name:"SRGBA"},25:{bytesPerPixel:2,name:"D16"},26:{bytesPerPixel:4,name:"D32"},27:{bytesPerPixel:4,name:"D24S8"},28:{bytesPerPixel:.5,name:"RGB_ETC2"},29:{bytesPerPixel:1,name:"RGBA_ETC2"},30:{bytesPerPixel:1,name:"RGBA_ASTC_4X4"},31:{bytesPerPixel:.8,name:"RGBA_ASTC_5X4"},32:{bytesPerPixel:.64,name:"RGBA_ASTC_5X5"},33:{bytesPerPixel:.533,name:"RGBA_ASTC_6X5"},34:{bytesPerPixel:.444,name:"RGBA_ASTC_6X6"},35:{bytesPerPixel:.4,name:"RGBA_ASTC_8X5"},36:{bytesPerPixel:.333,name:"RGBA_ASTC_8X6"},37:{bytesPerPixel:.25,name:"RGBA_ASTC_8X8"},38:{bytesPerPixel:.32,name:"RGBA_ASTC_10X5"},39:{bytesPerPixel:.267,name:"RGBA_ASTC_10X6"},40:{bytesPerPixel:.2,name:"RGBA_ASTC_10X8"},41:{bytesPerPixel:.16,name:"RGBA_ASTC_10X10"},42:{bytesPerPixel:.133,name:"RGBA_ASTC_12X10"},43:{bytesPerPixel:.111,name:"RGBA_ASTC_12X12"},44:{bytesPerPixel:1,name:"SRGBA_ASTC_4X4"},45:{bytesPerPixel:.8,name:"SRGBA_ASTC_5X4"},46:{bytesPerPixel:.64,name:"SRGBA_ASTC_5X5"},47:{bytesPerPixel:.533,name:"SRGBA_ASTC_6X5"},48:{bytesPerPixel:.444,name:"SRGBA_ASTC_6X6"},49:{bytesPerPixel:.4,name:"SRGBA_ASTC_8X5"},50:{bytesPerPixel:.333,name:"SRGBA_ASTC_8X6"},51:{bytesPerPixel:.25,name:"SRGBA_ASTC_8X8"},52:{bytesPerPixel:.32,name:"SRGBA_ASTC_10X5"},53:{bytesPerPixel:.267,name:"SRGBA_ASTC_10X6"},54:{bytesPerPixel:.2,name:"SRGBA_ASTC_10X8"},55:{bytesPerPixel:.16,name:"SRGBA_ASTC_10X10"},56:{bytesPerPixel:.133,name:"SRGBA_ASTC_12X10"},57:{bytesPerPixel:.111,name:"SRGBA_ASTC_12X12"}}[e]||{bytesPerPixel:4,name:"RGBA8888"}}}class m{static calculate(e){return this.calculateFontSize(e)}static calculateFontSize(e){try{let t=0;const n=(e._name||"").toLowerCase(),i=(e._native||"").toLowerCase();e._fontFamily;t=i.includes(".ttf")?n.includes("chinese")||n.includes("cn")||n.includes("zh")?8388608:n.includes("english")||n.includes("en")||n.includes("latin")?204800:n.includes("icon")||n.includes("symbol")?153600:n.includes("emoji")?2097152:512e3:i.includes(".otf")?614400:i.includes(".woff")||i.includes(".woff2")?307200:409600;t+=1048576;t+=65536;return(e.refCount||e._ref||1)>3&&(t+=524288),t}catch(e){return console.warn("计算字体大小时出错:",e),512e3}}}class b{static calculate(e){return-1}}class y{static calculate(e){var t;try{let y=0;switch((null===(t=e.__classname__)||void 0===t?void 0:t.replace("cc.",""))||e.constructor.name){case"Texture2D":case"cc_Texture2D":y=g.calculate(e);break;case"ImageAsset":case"cc_ImageAsset":y=a.calculate(e);break;case"AudioClip":case"cc_AudioClip":y=i.calculate(e);break;case"VideoClip":case"cc_VideoClip":y=b.calculate(e);break;case"Prefab":case"cc_Prefab":y=h.calculate(e);break;case"Material":case"cc_Material":y=c.calculate(e);break;case"Mesh":case"cc_Mesh":y=d.calculate(e);break;case"AnimationClip":case"cc_AnimationClip":y=n.calculate(e);break;case"EffectAsset":case"cc_EffectAsset":y=s.calculate(e);break;case"TTFFont":case"cc_TTFFont":y=m.calculate(e);break;case"JsonAsset":case"cc_JsonAsset":y=l.calculate(e.json);break;case"BufferAsset":case"cc_BufferAsset":y=o.calculate(e);break;case"sp_SkeletonData":case"sp.SkeletonData":case"SkeletonData":y=u.calculate(e);break;case"TextAsset":case"cc_TextAsset":y=p.calculate(e);break;case"Asset":case"cc_Asset":y=r.calculate(e);break;default:y=-1}return y}catch(e){return console.warn("计算资源大小时出错:",e),102400}}static formatBytes(e){if(-1===e)return"未计算";if(0===e)return"0 B";const t=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,t)).toFixed(2))+" "+["B","KB","MB","GB"][t]}}function f(){const e=window.cc,t=(null==e?void 0:e.ENGINE_VERSION)||"";return t.startsWith("3.")||t.startsWith("4.")}class x{static log(...e){console.log(...e)}}class v{static getTotalMemory(){try{const e=window.cc;if(e&&e.sys){if(e.sys.getTotalMemory)return e.sys.getTotalMemory();if(e.sys.totalMemory)return e.sys.totalMemory}return performance.memory?performance.memory.jsHeapSizeLimit:1073741824}catch(e){return 1073741824}}static getUsedMemory(){return this._totalSize}static getTotalCount(){return this._totalCount}static getBundleInfo(){this._unknown_assets.length=0,v.parseBundleInfos(),this._unknown_assets.length>0&&console.warn("资源缓存中未查到的资源:",this._unknown_assets);const e=[];return this._bundleInfos.forEach((t=>{e.push(t)})),e.sort(((e,t)=>(t.size||0)-(e.size||0))),e}static getBundleDirectoryInfo(){this._unknown_assets.length=0,v.parseBundleInfos();const e=[];return this._bundleDirectoryInfos.forEach((t=>{e.push(t)})),e.sort(((e,t)=>(t.size||0)-(e.size||0))),e}static getAssetInfo(e){return this._assets.get(e)}static parseBundleInfos(){var e,t;try{const n=window.cc;n&&n.assetManager&&n.assetManager.bundles||console.warn("cc.assetManager.bundles is not available");const i=n.assetManager.bundles,o=null==i?void 0:i._map;if(!o)return;for(const n in o){const i=o[n],r=i.name||i._config.base,s=(null===(e=i.config)||void 0===e?void 0:e.assetInfos)||(null===(t=i._config)||void 0===t?void 0:t.assetInfos);s._count;for(const e in s._map){const{path:t}=s._map[e];this.addAssetInfo(e,t,r)}}}catch(e){console.warn("获取bundle分组资源分类失败:",e)}this.parseLoadedAssets()}static parseLoadedAssets(){var e;this._bundleInfos.clear(),this._bundleDirectoryInfos.clear();try{const t=window.cc.assetManager.assets;if(t){this._totalCount=t._count,this._totalSize=0;for(const n in t._map){const i=t._map[n],o=(null===(e=i.__classname__)||void 0===e?void 0:e.replace("cc.",""))||i.constructor.name;this._assets.has(n)||this.addLooseAsset(n,i,o),this.addLoadedAssets(o,n,i),this.addLoadedAssetsToDirectory(o,n,i)}}}catch(e){console.warn("解析已加载资源失败:",e)}this.sortBundleAssetGroups(),this.sortBundleDirectoryGroups()}static sortBundleAssetGroups(){this._bundleInfos.forEach((e=>{for(const t in e.groups){e.groups[t].uuids.sort(((e,t)=>{const n=this._assets.get(e);return(this._assets.get(t).size||0)-(n.size||0)}))}}))}static sortBundleDirectoryGroups(){this._bundleDirectoryInfos.forEach((e=>{for(const t in e.directories){e.directories[t].uuids.sort(((e,t)=>{const n=this._assets.get(e);return(this._assets.get(t).size||0)-(n.size||0)}))}}))}static addAssetInfo(e,t,n){if(this._assets.has(e)){const i=this._assets.get(e);i.bundleName=n,i.path=t}else this._assets.set(e,{path:t,bundleName:n,size:0})}static addLooseAsset(e,t,n){try{let n=this.getAssetName(t,e),i="不在bundle中或bundle未加载";this._assets.set(e,{path:n,bundleName:i,size:0})}catch(t){console.warn(`处理非bundle资源失败 ${e}:`,t)}}static getAssetName(e,t){try{return e.name&&"string"==typeof e.name&&e.name.trim()?e.name:e._path&&"string"==typeof e._path&&e._path.trim()?e._path:e.nativeUrl&&"string"==typeof e.nativeUrl&&e.nativeUrl.trim()?e.nativeUrl:t}catch(e){return t}}static addLoadedAssets(e,t,n){if(!this._assets.has(t))return void this._unknown_assets.push(t);const i=this._assets.get(t);let{bundleName:o,path:r,size:s}=i;if(this.shouldSkipMemoryCalculation(e,n))return;s=s||y.calculate(n),i.size=s,this._bundleInfos.has(o)||this._bundleInfos.set(o,{name:o,count:0,size:0,groups:{}});const a=this._bundleInfos.get(o);a.count++,-1!==s&&(this._totalSize+=s,a.size+=s);const l=a.groups[e];l?(l.count++,-1!==s&&(l.size+=s),l.uuids=l.uuids||[],l.uuids.push(t)):a.groups[e]={type:e,count:1,size:s,uuids:[t]}}static shouldSkipMemoryCalculation(e,t){return f()?!!(e.includes("SpriteFrame")||e.includes("Texture2D")||e.includes("TextureCube")):!!e.includes("SpriteFrame")}static addLoadedAssetsToDirectory(e,t,n){if(!this._assets.has(t))return;const i=this._assets.get(t);i.extension||(i.extension=this.getExtension(e,n._native));let{bundleName:o,path:r,size:s}=i;o=o||"未知";if(this.shouldSkipMemoryCalculation(e,n))return;const a=this.getDirectoryPath(r);this._bundleDirectoryInfos.has(o)||this._bundleDirectoryInfos.set(o,{name:o,count:0,size:0,directories:{}});const l=this._bundleDirectoryInfos.get(o);l.count++,-1!==s&&(l.size+=s);const c=l.directories[a];c?(c.count++,-1!==s&&(c.size+=s),c.uuids=c.uuids||[],c.uuids.push(t)):l.directories[a]={path:a,count:1,size:s,uuids:[t]}}static getExtension(e,t){let n="UNKNOWN";if(t&&"string"==typeof t)if(t.includes(".")){const e=t.split(".");n=e[e.length-1].toLowerCase()}else n=t.startsWith(".")?t.substring(1).toLowerCase():t.toLowerCase();else n=e.toLowerCase();return n.length>10&&(n=e.toLowerCase()),this._log_set.has(n)||this._log_set.add(n),n}static getDirectoryPath(e){if(!e)return"/";const t=e.replace(/\\/g,"/"),n=t.lastIndexOf("/");if(-1===n)return"/";return t.substring(0,n)||"/"}}v._totalCount=0,v._totalSize=0,v._assets=new Map,v._bundleInfos=new Map,v._bundleDirectoryInfos=new Map,v._unknown_assets=[],v._log_set=new Set;class C{constructor(){this.container=null,this.updateInterval=null,this.isMonitoring=!1,this.scrollHandler=null,this.displayMode="type",this.filterConditions={memorySize:null,resourceTypes:[]},this.isFilterPanelVisible=!1}create(e){this.createContainer(e),this.applyStyles(),this.startMonitoring()}createContainer(e){this.container=document.createElement("div"),this.container.className="node-inspector-right-panel resource-memory-panel",this.container.innerHTML='\n            <div class="resource-memory-header">\n                <h3>资源内存监控</h3>\n                <div class="memory-stats">\n                    <div class="stat-item">\n                        <span class="stat-label">已用内存:</span>\n                        <span class="stat-value" id="used-memory">--</span>\n                    </div>\n                    <div class="stat-item">\n                        <span class="stat-label">已加载资源数量:</span>\n                        <span class="stat-value" id="loaded-assets-count">--</span>\n                    </div>\n                </div>\n            </div>\n            <div class="resource-memory-filter">\n                <button class="filter-toggle-button" id="filter-toggle-btn">\n                    <span class="filter-icon">🔍</span>\n                    筛选条件\n                    <span class="filter-count" id="filter-count" style="display: none;"></span>\n                </button>\n                <div class="filter-panel" id="filter-panel" style="display: none;">\n                    <div class="filter-section">\n                        <h4>按内存大小筛选</h4>\n                        <div class="filter-size-controls">\n                            <label>最小值:</label>\n                            <input type="number" id="filter-min-size-input" placeholder="输入数值" min="0" step="1" value="">\n                            <select id="filter-size-unit">\n                                <option value="1">B</option>\n                                <option value="1024" selected>KB</option>\n                                <option value="1048576">MB</option>\n                                <option value="1073741824">GB</option>\n                            </select>\n                        </div>\n                    </div>\n                    <div class="filter-section">\n                        <h4>按资源类型筛选</h4>\n                        <div class="filter-type-controls" id="filter-type-list">\n                            \x3c!-- 动态生成资源类型复选框 --\x3e\n                        </div>\n                    </div>\n                    <div class="filter-actions">\n                        <button class="filter-apply-btn" id="filter-apply-btn">应用筛选</button>\n                        <button class="filter-clear-btn" id="filter-clear-btn">清除筛选</button>\n                    </div>\n                </div>\n            </div>\n            <div class="resource-memory-content">\n                <div id="resource-type-list">\n                    \x3c!-- 动态生成资源类型分块 --\x3e\n                </div>\n            </div>\n            <div class="resource-memory-mode-selector">\n                <div class="mode-selector-label">显示模式:</div>\n                <div class="mode-selector-options">\n                    <label class="mode-option">\n                        <input type="radio" name="display-mode" value="type" checked>\n                        <span class="radio-label">资源类型模式</span>\n                    </label>\n                    <label class="mode-option">\n                        <input type="radio" name="display-mode" value="directory">\n                        <span class="radio-label">目录模式</span>\n                    </label>\n                </div>\n            </div>\n            <div class="resource-memory-footer">\n                <button class="refresh-button-container" id="refresh-memory-btn">\n                    <span class="refresh-icon">🔄</span>\n                    刷新数据\n                </button>\n                <div class="last-update" id="last-update-time">\n                    最后更新: 未更新\n                </div>\n                <div class="memory-tips">\n                    tips: 由于creator未提供资源内存占用的接口，本插件中的内存是插件自主计算获得，不保证一定准确！！！\n                </div>\n            </div>\n        ',e.appendChild(this.container)}applyStyles(){const e=document.createElement("style");e.textContent='\n            .resource-memory-panel {\n                display: flex;\n                flex-direction: column;\n                height: 100%;\n                overflow: hidden;\n            }\n\n            .resource-memory-header {\n                flex-shrink: 0;\n                padding: 10px;\n                padding-right: 15px;\n                background: #1a1a1a;\n                border-bottom: 1px solid #444;\n            }\n\n            .resource-memory-header h3 {\n                margin: 0 0 10px 0;\n                color: #fff;\n                font-size: 14px;\n                font-weight: bold;\n            }\n\n            .resource-memory-content {\n                flex: 1;\n                overflow-y: scroll;\n                padding: 0px 15px 0px 10px;\n            }\n\n            /* 滚动条样式 - 参考左侧抽屉 */\n            .resource-memory-content::-webkit-scrollbar {\n                width: 8px;\n            }\n\n            .resource-memory-content::-webkit-scrollbar-track {\n                background: #1e1e1e;\n            }\n\n            .resource-memory-content::-webkit-scrollbar-thumb {\n                background: #555;\n                border-radius: 4px;\n            }\n\n            .resource-memory-content::-webkit-scrollbar-thumb:hover {\n                background: #666;\n            }\n\n            .resource-memory-mode-selector {\n                flex-shrink: 0;\n                padding: 10px;\n                padding-right: 15px;\n                background: #1a1a1a;\n                border-top: 1px solid #444;\n                border-bottom: 1px solid #444;\n            }\n\n            .mode-selector-label {\n                color: #ccc;\n                font-size: 12px;\n                margin-bottom: 8px;\n            }\n\n            .mode-selector-options {\n                display: flex;\n                gap: 20px;\n            }\n\n            .mode-option {\n                display: flex;\n                align-items: center;\n                gap: 6px;\n                cursor: pointer;\n                font-size: 12px;\n                color: #ccc;\n                user-select: none;\n            }\n\n            .mode-option input[type="radio"] {\n                margin: 0;\n                accent-color: #007acc;\n            }\n\n            .mode-option:hover {\n                color: #fff;\n            }\n\n            .radio-label {\n                cursor: pointer;\n            }\n\n            .resource-type {\n                margin-right: 10px;\n                color: #888;\n                font-size: 11px;\n                font-style: italic;\n                white-space: nowrap;\n                flex-shrink: 0;\n            }\n\n            .resource-memory-footer {\n                flex-shrink: 0;\n                padding: 10px;\n                padding-right: 15px;\n                background: #1a1a1a;\n                border-top: 1px solid #444;\n                text-align: center;\n            }\n\n            .memory-stats {\n                background: #1e1e1e;\n                border: 1px solid #444;\n                border-radius: 4px;\n                padding: 10px;\n                margin-bottom: 0;\n            }\n\n            .stat-item {\n                display: flex;\n                justify-content: space-between;\n                align-items: center;\n                padding: 5px 0;\n                border-bottom: 1px solid #333;\n            }\n\n            .stat-item:last-child {\n                border-bottom: none;\n            }\n\n            .stat-label {\n                color: #ccc;\n                font-size: 12px;\n            }\n\n            .stat-value {\n                color: #fff;\n                font-weight: bold;\n                font-size: 12px;\n            }\n\n            .resource-categories,\n            .texture-info,\n            .audio-info {\n                background: #1e1e1e;\n                border: 1px solid #444;\n                border-radius: 4px;\n                padding: 10px;\n                margin-bottom: 15px;\n            }\n\n            .resource-categories h4,\n            .texture-info h4,\n            .audio-info h4 {\n                margin: 0 0 10px 0;\n                color: #fff;\n                font-size: 13px;\n                font-weight: bold;\n                border-bottom: 1px solid #444;\n                padding-bottom: 5px;\n                cursor: pointer;\n                user-select: none;\n                display: flex;\n                align-items: center;\n            }\n\n            .bundle-group-block {\n                background: #2a2a2a;\n                border: 2px solid #555;\n                border-radius: 6px;\n                padding: 0;\n                margin: 15px 0;\n            }\n\n            .bundle-group-block:first-child {\n                margin-top: 10px;\n            }\n\n            .bundle-group-block:last-child {\n                margin-bottom: 10px;\n            }\n\n            .bundle-group-header {\n                margin: 0;\n                color: #fff;\n                font-size: 14px;\n                font-weight: bold;\n                background: #333;\n                border-bottom: 1px solid #555;\n                padding: 12px 15px;\n                cursor: pointer;\n                user-select: none;\n                display: flex;\n                align-items: center;\n            }\n\n            .bundle-group-header:hover {\n                background: #3a3a3a;\n            }\n\n            .bundle-content {\n                max-height: 0;\n                overflow: hidden;\n                transition: max-height 0.3s ease;\n                position: relative;\n            }\n\n            .bundle-content.expanded {\n                max-height: none;\n                overflow: visible;\n            }\n\n            /* 移除bundle内容区域滚动条样式 */\n\n            .resource-type-block {\n                border-bottom: 1px solid #444;\n            }\n\n            .resource-type-block:last-child {\n                border-bottom: none;\n            }\n\n            .resource-type-header {\n                margin: 0;\n                color: #fff;\n                font-size: 13px;\n                font-weight: bold;\n                background: #2a2a2a;\n                padding: 10px 15px;\n                cursor: pointer;\n                user-select: none;\n                display: flex;\n                align-items: center;\n                border-bottom: 1px solid #444;\n                transition: background-color 0.2s ease;\n            }\n\n            .resource-type-header:hover {\n                background: #3a3a3a;\n            }\n\n            /* Bundle标题粘性样式 */\n            .bundle-group-header {\n                position: sticky;\n                top: 0;\n                z-index: 20;\n                background: #333;\n            }\n\n            .bundle-group-header.is-sticky {\n                background: #3a3a3a !important;\n                box-shadow: 0 2px 4px rgba(0,0,0,0.3);\n            }\n\n            /* 资源类型标题粘性样式 */\n            .resource-type-header.sticky-header {\n                position: sticky;\n                z-index: 10;\n                background: #2a2a2a;\n                border-bottom: 2px solid #555;\n            }\n\n            .resource-type-header.is-sticky {\n                background: #3a3a3a !important;\n                box-shadow: 0 2px 4px rgba(0,0,0,0.3);\n            }\n\n            .resource-details {\n                max-height: 0;\n                overflow: hidden;\n                transition: max-height 0.3s ease;\n                background: #1e1e1e;\n            }\n\n            .resource-details.expanded {\n                max-height: none;\n                overflow: visible;\n            }\n\n            .resource-detail-item {\n                display: flex;\n                justify-content: space-between;\n                align-items: center;\n                padding: 8px 20px;\n                border-bottom: 1px solid #333;\n                font-size: 12px;\n                cursor: pointer;\n            }\n\n            .resource-detail-item:last-child {\n                border-bottom: none;\n            }\n\n            .resource-detail-item:hover {\n                background: #333;\n            }\n\n            .resource-detail-item:hover .inspect-icon {\n                opacity: 1;\n            }\n\n            .resource-detail-name {\n                color: #ccc;\n                flex: 1;\n                margin-right: 10px;\n                overflow: hidden;\n                text-overflow: ellipsis;\n                white-space: nowrap;\n                text-align: left;\n            }\n\n            .resource-detail-size {\n                color: #fff;\n                font-weight: bold;\n                flex-shrink: 0;\n            }\n\n            .inspect-icon {\n                margin-left: 8px;\n                color: #888;\n                font-size: 14px;\n                opacity: 0;\n                transition: opacity 0.2s ease;\n                cursor: pointer;\n                flex-shrink: 0;\n            }\n\n            .inspect-icon:hover {\n                color: #0078d4;\n            }\n\n            .expand-toggle {\n                color: #888;\n                font-size: 12px;\n                margin-right: 8px;\n                transition: transform 0.2s ease;\n                display: inline-block;\n                width: 16px;\n                text-align: center;\n                flex-shrink: 0;\n            }\n\n            .expand-toggle.expanded {\n                transform: rotate(90deg);\n                color: #fff;\n            }\n\n            .bundle-count,\n            .category-count {\n                color: #888;\n                font-weight: normal;\n                font-size: 12px;\n                margin-left: auto;\n                flex-shrink: 0;\n            }\n\n            .bundle-title,\n            .category-title {\n                flex: 1;\n                margin-right: 10px;\n                white-space: nowrap;\n                overflow: hidden;\n                text-overflow: ellipsis;\n                min-width: 0;\n                text-align: left;\n            }\n\n            /* 当文本过长时自动缩小字号 */\n            .category-title {\n                font-size: 13px;\n                display: flex;\n                align-items: center;\n                transition: font-size 0.1s ease;\n            }\n\n            .category-title.text-overflow {\n                font-size: 11px;\n            }\n\n            .category-title.text-overflow-small {\n                font-size: 9px;\n            }\n\n            .no-data {\n                text-align: center;\n                color: #888;\n                padding: 40px 20px;\n                font-style: italic;\n            }\n\n            .category-summary {\n                display: flex;\n                justify-content: space-between;\n                align-items: center;\n                padding: 5px 0;\n                border-bottom: 1px solid #333;\n                font-weight: bold;\n            }\n\n            .category-summary:last-child {\n                border-bottom: none;\n            }\n\n            .refresh-button-container {\n                background: #0078d4;\n                color: white;\n                border: none;\n                padding: 8px 16px;\n                border-radius: 4px;\n                cursor: pointer;\n                font-size: 12px;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                margin: 0 auto 8px auto;\n                transition: background 0.2s ease;\n            }\n\n            .refresh-button-container:hover {\n                background: #106ebe;\n            }\n\n            .refresh-button-container:active {\n                background: #005a9e;\n            }\n\n            .refresh-icon {\n                margin-right: 6px;\n                font-size: 14px;\n            }\n\n            .refresh-button-container.loading .refresh-icon {\n                animation: spin 1s linear infinite;\n            }\n\n            @keyframes spin {\n                from { transform: rotate(0deg); }\n                to { transform: rotate(360deg); }\n            }\n\n            .last-update {\n                color: #888;\n                font-size: 10px;\n            }\n\n            .memory-tips {\n                color: #f39c12;\n                font-size: 9px;\n                margin-top: 8px;\n                padding: 6px 8px;\n                background: rgba(243, 156, 18, 0.1);\n                border: 1px solid rgba(243, 156, 18, 0.3);\n                border-radius: 3px;\n                text-align: left;\n                line-height: 1.4;\n            }\n\n            /* 筛选相关样式 */\n            .resource-memory-filter {\n                flex-shrink: 0;\n                padding: 8px 10px;\n                background: #1a1a1a;\n                border-bottom: 1px solid #444;\n            }\n\n            .filter-toggle-button {\n                width: 100%;\n                background: #2a2a2a;\n                color: #fff;\n                border: 1px solid #555;\n                padding: 8px 12px;\n                border-radius: 4px;\n                cursor: pointer;\n                font-size: 12px;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                transition: background 0.2s ease;\n                position: relative;\n            }\n\n            .filter-toggle-button:hover {\n                background: #3a3a3a;\n            }\n\n            .filter-icon {\n                margin-right: 6px;\n                font-size: 14px;\n            }\n\n            .filter-count {\n                background: #e74c3c;\n                color: white;\n                border-radius: 10px;\n                padding: 2px 6px;\n                margin-left: 8px;\n                font-size: 10px;\n                font-weight: bold;\n            }\n\n            .filter-panel {\n                margin-top: 8px;\n                background: #1e1e1e;\n                border: 1px solid #444;\n                border-radius: 4px;\n                padding: 12px;\n                animation: slideDown 0.2s ease;\n            }\n\n            @keyframes slideDown {\n                from {\n                    opacity: 0;\n                    transform: translateY(-10px);\n                }\n                to {\n                    opacity: 1;\n                    transform: translateY(0);\n                }\n            }\n\n            .filter-section {\n                margin-bottom: 12px;\n            }\n\n            .filter-section:last-child {\n                margin-bottom: 0;\n            }\n\n            .filter-section h4 {\n                margin: 0 0 8px 0;\n                color: #fff;\n                font-size: 12px;\n                font-weight: bold;\n            }\n\n            .filter-size-controls {\n                display: grid;\n                grid-template-columns: auto 1fr auto;\n                gap: 8px;\n                align-items: center;\n            }\n\n            .filter-size-controls label {\n                color: #ccc;\n                font-size: 11px;\n            }\n\n            .filter-size-controls input,\n            .filter-size-controls select {\n                background: #333;\n                color: #fff;\n                border: 1px solid #555;\n                border-radius: 3px;\n                padding: 4px 6px;\n                font-size: 11px;\n            }\n\n            .filter-size-controls input:focus {\n                outline: none;\n                border-color: #0078d4;\n            }\n\n            .filter-type-controls {\n                max-height: 120px;\n                overflow-y: auto;\n                border: 1px solid #333;\n                border-radius: 3px;\n                padding: 6px;\n                background: #333;\n            }\n\n            .filter-type-item {\n                display: flex;\n                align-items: center;\n                padding: 4px 0;\n                color: #ccc;\n                font-size: 11px;\n            }\n\n            .filter-type-item input[type="checkbox"] {\n                margin-right: 6px;\n            }\n\n            .filter-actions {\n                display: flex;\n                gap: 8px;\n                margin-top: 12px;\n            }\n\n            .filter-apply-btn,\n            .filter-clear-btn {\n                flex: 1;\n                padding: 6px 12px;\n                border: none;\n                border-radius: 3px;\n                font-size: 11px;\n                cursor: pointer;\n                transition: background 0.2s ease;\n            }\n\n            .filter-apply-btn {\n                background: #27ae60;\n                color: white;\n            }\n\n            .filter-apply-btn:hover {\n                background: #2ecc71;\n            }\n\n            .filter-clear-btn {\n                background: #e74c3c;\n                color: white;\n            }\n\n            .filter-clear-btn:hover {\n                background: #c0392b;\n            }\n        ',document.head.appendChild(e)}bindEvents(){this.container.addEventListener("click",(e=>{const t=e.target;if(t.classList.contains("inspect-icon")){e.stopPropagation();const n=t.getAttribute("data-uuid");return void(n&&this.inspectAssetInDevTools(n))}if(t.classList.contains("resource-detail-item")||t.closest(".resource-detail-item")){const e=t.classList.contains("resource-detail-item")?t:t.closest(".resource-detail-item"),n=null==e?void 0:e.getAttribute("data-uuid");return void(n&&this.inspectAssetInDevTools(n))}const n=t.closest(".bundle-group-header");if(n){const e=n.getAttribute("data-target");return void(e&&this.toggleExpand(e))}const i=t.closest(".resource-type-header");if(i){const e=i.getAttribute("data-target");e&&this.toggleExpand(e)}else;}));this.container.querySelectorAll('input[name="display-mode"]').forEach((e=>{e.addEventListener("change",(e=>{const t=e.target;t.checked&&(this.displayMode=t.value,this.updateResourceTypeList())}))}));const e=this.container.querySelector("#refresh-memory-btn");e&&e.addEventListener("click",(()=>{this.refreshData()})),this.bindFilterEvents()}bindFilterEvents(){const e=this.container.querySelector("#filter-toggle-btn");e&&e.addEventListener("click",(()=>{this.toggleFilterPanel()}));const t=this.container.querySelector("#filter-apply-btn");t&&t.addEventListener("click",(()=>{this.applyFilter()}));const n=this.container.querySelector("#filter-clear-btn");n&&n.addEventListener("click",(()=>{this.clearFilter()}))}toggleFilterPanel(){const e=this.container.querySelector("#filter-panel");e&&(this.isFilterPanelVisible=!this.isFilterPanelVisible,e.style.display=this.isFilterPanelVisible?"block":"none",this.isFilterPanelVisible&&this.updateFilterTypeList())}updateFilterTypeList(){const e=this.container.querySelector("#filter-type-list");if(!e)return;e.innerHTML="";const t=v.getBundleInfo(),n=new Set;t.forEach((e=>{Object.keys(e.groups).forEach((e=>{n.add(e)}))})),Array.from(n).sort().forEach((t=>{const n=document.createElement("div");n.className="filter-type-item";const i=document.createElement("input");i.type="checkbox",i.id=`filter-type-${t}`,i.value=t,i.checked=this.filterConditions.resourceTypes.includes(t);const o=document.createElement("label");o.htmlFor=`filter-type-${t}`,o.textContent=t,n.appendChild(i),n.appendChild(o),e.appendChild(n)}))}applyFilter(){const e=this.container.querySelector("#filter-min-size-input"),t=this.container.querySelector("#filter-size-unit"),n=parseFloat(e.value)||0,i=parseInt(t.value)||1;if(n>0){const e=n*i;this.filterConditions.memorySize={min:e,max:Number.MAX_SAFE_INTEGER}}else this.filterConditions.memorySize=null;const o=this.container.querySelectorAll('#filter-type-list input[type="checkbox"]:checked');this.filterConditions.resourceTypes=Array.from(o).map((e=>e.value)),this.updateFilterCount(),this.isFilterPanelVisible=!1;const r=this.container.querySelector("#filter-panel");r&&(r.style.display="none"),this.updateResourceTypeList(),x.log("应用筛选条件:",this.filterConditions)}clearFilter(){this.filterConditions.memorySize=null,this.filterConditions.resourceTypes=[];const e=this.container.querySelector("#filter-min-size-input"),t=this.container.querySelector("#filter-size-unit");e&&(e.value=""),t&&(t.value="1024");this.container.querySelectorAll('#filter-type-list input[type="checkbox"]').forEach((e=>e.checked=!1)),this.updateFilterCount(),this.isFilterPanelVisible=!1;const n=this.container.querySelector("#filter-panel");n&&(n.style.display="none"),this.updateResourceTypeList(),x.log("清除筛选条件")}inspectAssetInDevTools(e){var t,n,i,o,r;try{const s=window.cc,a=null===(i=null===(n=null===(t=null==s?void 0:s.assetManager)||void 0===t?void 0:t.assets)||void 0===n?void 0:n.get)||void 0===i?void 0:i.call(n,e);if(!a)return console.warn(`无法找到UUID为 ${e} 的资源`),void this.showInspectFeedback("资源未找到或已被释放");const l=this.getAssetUrl(a);l?(this.openResourceInGrayWindow(l),this.showInspectFeedback("已在新窗口中打开资源"),console.group(`🔍 资源定位信息 - ${(null===(o=a.constructor)||void 0===o?void 0:o.name)||"Unknown"}`),console.log(`📋 资源UUID: ${e}`),console.log(`🔗 资源URL: ${l}`),console.log("📄 资源对象:",a),console.groupEnd()):(console.group(`🔍 资源信息 - ${(null===(r=a.constructor)||void 0===r?void 0:r.name)||"Unknown"}`),console.log(`📋 资源UUID: ${e}`),console.log("📄 资源对象:",a),console.groupEnd(),this.showInspectFeedback("已在控制台打印资源信息"))}catch(e){console.error("定位资源时发生错误:",e),this.showInspectFeedback("定位资源失败，请查看控制台")}}openResourceInGrayWindow(e){const t=new Blob([`\n            <!DOCTYPE html>\n            <html>\n            <head>\n                <meta charset="UTF-8">\n                <title>资源预览</title>\n                <style>\n                    body {\n                        background-color: #808080;\n                        margin: 0;\n                        padding: 20px;\n                        display: flex;\n                        justify-content: center;\n                        align-items: center;\n                        min-height: 100vh;\n                        font-family: Arial, sans-serif;\n                    }\n                    .resource-container {\n                        background: white;\n                        border-radius: 8px;\n                        padding: 20px;\n                        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);\n                        max-width: 90%;\n                        max-height: 90%;\n                        overflow: auto;\n                    }\n                    img {\n                        max-width: 100%;\n                        max-height: 100%;\n                        object-fit: contain;\n                        display: block;\n                        margin: 0 auto;\n                    }\n                    .resource-info {\n                        text-align: center;\n                        margin-top: 10px;\n                        color: #666;\n                        font-size: 14px;\n                    }\n                </style>\n            </head>\n            <body>\n                <div class="resource-container">\n                    <img src="${e}" alt="资源预览" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">\n                    <div class="resource-info" style="display: none;">\n                        <p>无法显示资源预览</p>\n                        <p><a href="${e}" target="_blank">点击此处访问原始资源</a></p>\n                    </div>\n                    <div class="resource-info">\n                        <p>资源地址: ${e}</p>\n                    </div>\n                </div>\n            </body>\n            </html>\n        `],{type:"text/html"}),n=URL.createObjectURL(t);window.open(n,"_blank","width=900,height=700,scrollbars=yes,resizable=yes"),setTimeout((()=>{URL.revokeObjectURL(n)}),1e3)}getAssetUrl(e){try{if(!e||!e.nativeUrl)return null;let t=e.nativeUrl;const n=t.split(".").pop();if(n&&!["png","jpg","jpeg","gif","webp","svg","ico","bmp","tiff","tif","raw","heic","heif"].includes(n))return null;if(t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//"))return t;if(t.startsWith("./")||t.startsWith("/")||!t.includes("://")){const e=window.location.origin+window.location.pathname.replace(/\/[^\/]*$/,"/");return new URL(t,e).href}return null}catch(e){return console.warn("获取资源URL失败:",e),null}}showInspectFeedback(e){const t=document.createElement("div");t.style.cssText="\n            position: fixed;\n            top: 20px;\n            right: 20px;\n            background: #0078d4;\n            color: white;\n            padding: 10px 15px;\n            border-radius: 4px;\n            font-size: 12px;\n            z-index: 10000;\n            box-shadow: 0 2px 8px rgba(0,0,0,0.3);\n            animation: slideInRight 0.3s ease;\n        ",t.textContent=e;const n=document.createElement("style");n.textContent="\n            @keyframes slideInRight {\n                from { transform: translateX(100%); opacity: 0; }\n                to { transform: translateX(0); opacity: 1; }\n            }\n            @keyframes slideOutRight {\n                from { transform: translateX(0); opacity: 1; }\n                to { transform: translateX(100%); opacity: 0; }\n            }\n        ",document.head.appendChild(n),document.body.appendChild(t),setTimeout((()=>{t.style.animation="slideOutRight 0.3s ease",setTimeout((()=>{t.parentNode&&t.parentNode.removeChild(t),n.parentNode&&n.parentNode.removeChild(n)}),300)}),3e3)}updateFilterCount(){const e=this.container.querySelector("#filter-count");if(!e)return;let t=0;this.filterConditions.memorySize&&t++,this.filterConditions.resourceTypes.length>0&&t++,t>0?(e.textContent=`${t}`,e.style.display="inline"):e.style.display="none"}applyFilterToData(e){if(!this.filterConditions.memorySize&&0===this.filterConditions.resourceTypes.length)return e;const t=[];return e.forEach((e=>{const n={};let i=!1;if(Object.keys(e.groups).forEach((t=>{const o=e.groups[t];if(!(this.filterConditions.resourceTypes.length>0)||this.filterConditions.resourceTypes.includes(t)){if(this.filterConditions.memorySize){const e=o.size||0;if(e<this.filterConditions.memorySize.min||e>this.filterConditions.memorySize.max)return}if(this.filterConditions.memorySize&&o.uuids){const e=[];let r=0,s=0;o.uuids.forEach((t=>{const n=v.getAssetInfo(t);if(n){const i=n.size||0;i>=this.filterConditions.memorySize.min&&i<=this.filterConditions.memorySize.max&&(e.push(t),r+=i,s++)}})),e.length>0&&(n[t]=Object.assign(Object.assign({},o),{uuids:e,size:r,count:s}),i=!0)}else n[t]=o,i=!0}})),i){let i=0,o=0;Object.values(n).forEach((e=>{i+=e.size||0,o+=e.count||0})),t.push(Object.assign(Object.assign({},e),{groups:n,size:i,count:o}))}})),t}applyFilterToDirectoryData(e){if(!this.filterConditions.memorySize&&0===this.filterConditions.resourceTypes.length)return e;const t=[];return e.forEach((e=>{const n={};let i=!1;if(Object.keys(e.directories).forEach((t=>{const o=e.directories[t];if(o.uuids){const e=[];let r=0,s=0;o.uuids.forEach((t=>{var n,i,o,a;const l=v.getAssetInfo(t);if(l){const c=window.cc,d=null===(o=null===(i=null===(n=null==c?void 0:c.assetManager)||void 0===n?void 0:n.assets)||void 0===i?void 0:i._map)||void 0===o?void 0:o[t],h=(null===(a=null==d?void 0:d.constructor)||void 0===a?void 0:a.name)||"Unknown";if(this.filterConditions.resourceTypes.length>0&&!this.filterConditions.resourceTypes.includes(h))return;const u=l.size||0;if(this.filterConditions.memorySize&&(u<this.filterConditions.memorySize.min||u>this.filterConditions.memorySize.max))return;e.push(t),r+=u,s++}})),e.length>0&&(n[t]=Object.assign(Object.assign({},o),{uuids:e,size:r,count:s}),i=!0)}})),i){let i=0,o=0;Object.values(n).forEach((e=>{i+=e.size||0,o+=e.count||0})),t.push(Object.assign(Object.assign({},e),{directories:n,size:i,count:o}))}})),t}refreshData(){const e=this.container.querySelector("#refresh-memory-btn");e&&(e.classList.add("loading"),e.textContent="刷新中..."),setTimeout((()=>{this.updateMemoryInfo(),this.updateLastUpdateTime(),e&&(e.classList.remove("loading"),e.innerHTML='<span class="refresh-icon">🔄</span>刷新数据')}),500)}updateLastUpdateTime(){const e=this.container.querySelector("#last-update-time");if(e){const t=(new Date).toLocaleTimeString("zh-CN",{hour:"2-digit",minute:"2-digit",second:"2-digit"});e.textContent=`最后更新: ${t}`}}toggleExpand(e){const t=this.container.querySelector(`#${e}`);if(!t)return void console.warn(`无法找到目标元素: ${e}`);const n=this.container.querySelector(`[data-target="${e}"]`),i=null==n?void 0:n.querySelector(".expand-toggle");t.classList.contains("expanded")?(t.classList.remove("expanded"),i&&i.classList.remove("expanded")):(t.classList.add("expanded"),i&&i.classList.add("expanded")),setTimeout((()=>{this.addStickyHeaderBehavior()}),50)}startMonitoring(){this.isMonitoring||(this.isMonitoring=!0,this.bindEvents(),this.updateMemoryInfo(),this.updateLastUpdateTime(),console.log("资源内存监控已开始（手动刷新模式）"))}stopMonitoring(){this.updateInterval&&(clearInterval(this.updateInterval),this.updateInterval=null),this.isMonitoring=!1,console.log("资源内存监控已停止")}updateMemoryInfo(){try{this.updateResourceTypeList(),this.updateSystemMemory()}catch(e){console.warn("更新内存信息失败:",e)}}updateSystemMemory(){const e=v.getUsedMemory(),t=v.getTotalCount();this.updateElement("used-memory",y.formatBytes(e)),this.updateElement("loaded-assets-count",t.toString())}updateResourceTypeList(){const e=this.container.querySelector("#resource-type-list");e&&("type"===this.displayMode?this.renderResourceTypeMode(e):this.renderDirectoryMode(e))}renderResourceTypeMode(e){const t=new Map;e.querySelectorAll(".expanded").forEach((e=>{e.id&&t.set(e.id,!0)})),e.innerHTML="";let n=v.getBundleInfo();0!==n.length?(n=this.applyFilterToData(n),0!==n.length?(n.forEach((n=>{const i=document.createElement("div");i.className="bundle-group-block";const o=this.escapeSelector(n.name),r=document.createElement("h3");r.className="bundle-group-header",r.setAttribute("data-target",`bundle-${o}`),r.innerHTML=`\n                <span class="expand-toggle">▶</span>\n                <span class="bundle-title">${n.name}</span>\n                <span class="bundle-count">${n.count||0} 个资源 / ${y.formatBytes(n.size||0)}</span>\n            `,i.appendChild(r);const s=document.createElement("div");if(s.className="bundle-content",s.id=`bundle-${o}`,t.get(s.id)){s.classList.add("expanded");const e=r.querySelector(".expand-toggle");e&&e.classList.add("expanded")}const a=n.groups;Object.keys(a).sort(((e,t)=>(a[t].size||0)-(a[e].size||0))).forEach((e=>{const n=a[e],i=document.createElement("div");i.className="resource-type-block";const r=this.escapeSelector(e),l=document.createElement("h4");if(l.className="resource-type-header sticky-header",l.setAttribute("data-target",`type-${o}-${r}`),l.innerHTML=`\n                    <span class="expand-toggle">▶</span>\n                    <span class="category-title">${e}</span>\n                    <span class="category-count">${n.count} 个 / ${y.formatBytes(n.size)}</span>\n                `,i.appendChild(l),n.uuids&&n.uuids.length>0){const e=document.createElement("div");if(e.className="resource-details",e.id=`type-${o}-${r}`,t.get(e.id)){e.classList.add("expanded");const t=l.querySelector(".expand-toggle");t&&t.classList.add("expanded")}const s=[];n.uuids.forEach((e=>{const t=v.getAssetInfo(e);t&&s.push({name:t.path||e,size:t.size||0,uuid:e})})),s.sort(((e,t)=>t.size-e.size)),s.forEach((t=>{const n=document.createElement("div");n.className="resource-detail-item",n.setAttribute("data-uuid",t.uuid),n.setAttribute("title",`点击打开资源预览\n资源名称: ${t.name}\n提示: 会在新标签页中打开资源，同时在控制台提供Network页签定位指引`),n.innerHTML=`\n                            <span class="resource-detail-name" title="${t.name}">${t.name}</span>\n                            <span class="resource-detail-size">${y.formatBytes(t.size)}</span>\n                            <span class="inspect-icon" data-uuid="${t.uuid}" title="在新标签页打开资源预览">🔍</span>\n                        `,e.appendChild(n)})),i.appendChild(e)}s.appendChild(i)})),i.appendChild(s),e.appendChild(i)})),this.addStickyHeaderBehavior()):e.innerHTML='<div class="no-data">没有符合筛选条件的资源数据</div>'):e.innerHTML='<div class="no-data">暂无资源数据，请点击刷新按钮获取数据</div>'}renderDirectoryMode(e){const t=new Map;e.querySelectorAll(".expanded").forEach((e=>{e.id&&t.set(e.id,!0)})),e.innerHTML="";let n=v.getBundleDirectoryInfo();0!==n.length?(n=this.applyFilterToDirectoryData(n),0!==n.length?(n.forEach((n=>{const i=document.createElement("div");i.className="bundle-group-block";const o=this.escapeSelector(n.name),r=document.createElement("h3");r.className="bundle-group-header",r.setAttribute("data-target",`bundle-dir-${o}`),r.innerHTML=`\n                <span class="expand-toggle">▶</span>\n                <span class="bundle-title">${n.name}</span>\n                <span class="bundle-count">${n.count||0} 个资源 / ${y.formatBytes(n.size||0)}</span>\n            `,i.appendChild(r);const s=document.createElement("div");if(s.className="bundle-content",s.id=`bundle-dir-${o}`,t.get(s.id)){s.classList.add("expanded");const e=r.querySelector(".expand-toggle");e&&e.classList.add("expanded")}const a=n.directories;Object.keys(a).sort(((e,t)=>(a[t].size||0)-(a[e].size||0))).forEach((e=>{const n=a[e],i=document.createElement("div");i.className="resource-type-block";const r=this.escapeSelector(e),l=document.createElement("h4");l.className="resource-type-header sticky-header",l.setAttribute("data-target",`dir-${o}-${r}`);const c="/"===e?"根目录":e;l.innerHTML=`\n                    <span class="expand-toggle">▶</span>\n                    <span class="category-title">📁 ${c}</span>\n                    <span class="category-count">${n.count} 个 / ${y.formatBytes(n.size)}</span>\n                `,i.appendChild(l);const d=l.querySelector(".category-title");if(d&&setTimeout((()=>this.adjustSingleTitleOverflow(d)),0),n.uuids&&n.uuids.length>0){const e=document.createElement("div");if(e.className="resource-details",e.id=`dir-${o}-${r}`,t.get(e.id)){e.classList.add("expanded");const t=l.querySelector(".expand-toggle");t&&t.classList.add("expanded")}const s=[];n.uuids.forEach((e=>{const t=v.getAssetInfo(e);if(t){const n=t.path?t.path.split("/").pop():e,i=t.extension||"UNKNOWN";s.push({name:n||"unknown",size:t.size||0,type:i,uuid:e})}})),s.sort(((e,t)=>t.size-e.size)),s.forEach((t=>{const n=document.createElement("div");n.className="resource-detail-item",n.setAttribute("data-uuid",t.uuid),n.setAttribute("title",`点击打开资源预览\n文件名: ${t.name}\n类型: ${t.type}\n提示: 会在新标签页中打开资源，同时在控制台提供Network页签定位指引`),n.innerHTML=`\n                            <span class="resource-detail-name" title="${t.name}">${t.name}</span>\n                            <span class="resource-type">[${t.type}]</span>\n                            <span class="resource-detail-size">${y.formatBytes(t.size)}</span>\n                            <span class="inspect-icon" data-uuid="${t.uuid}" title="在新标签页打开资源预览">🔍</span>\n                        `,e.appendChild(n)})),i.appendChild(e)}s.appendChild(i)})),i.appendChild(s),e.appendChild(i)})),this.addStickyHeaderBehavior()):e.innerHTML='<div class="no-data">没有符合筛选条件的资源数据</div>'):e.innerHTML='<div class="no-data">暂无资源数据，请点击刷新按钮获取数据</div>'}addStickyHeaderBehavior(){const e=this.container.querySelector(".resource-memory-content");e&&(this.scrollHandler&&e.removeEventListener("scroll",this.scrollHandler),this.scrollHandler=this.createStickyScrollHandler(),e.addEventListener("scroll",this.scrollHandler),this.adjustTextOverflow())}createStickyScrollHandler(){let e=!1;return()=>{e||(requestAnimationFrame((()=>{this.updateStickyHeaders(),e=!1})),e=!0)}}updateStickyHeaders(){const e=this.container.querySelector(".resource-memory-content");if(!e)return;const t=e.getBoundingClientRect().top,n=e.querySelectorAll(".bundle-group-block");let i=null,o=0;if(n.forEach((e=>{const n=e.querySelector(".bundle-group-header"),o=e.querySelector(".bundle-content");if(!n||!o)return;n.style.top="0px",n.classList.remove("is-sticky");e.querySelectorAll(".resource-type-header").forEach((e=>{e.style.top="0px",e.classList.remove("is-sticky")}));const r=n.getBoundingClientRect(),s=o.getBoundingClientRect();r.top<=t&&s.bottom>t&&(i=n)})),i){i.style.top="0px",i.classList.add("is-sticky"),o=i.offsetHeight;const e=i.closest(".bundle-group-block"),n=null==e?void 0:e.querySelector(".bundle-content");if(e&&n&&n.classList.contains("expanded")){const n=e.querySelectorAll(".resource-type-header");let i=null;n.forEach((e=>{const n=e.nextElementSibling;if(!n||!n.classList.contains("expanded"))return;const r=e.getBoundingClientRect(),s=n.getBoundingClientRect();r.top<=t+o&&s.bottom>t+o&&(i=e)})),i&&(i.style.top=`${o}px`,i.classList.add("is-sticky"))}}}updateElement(e,t){const n=document.getElementById(e);n&&(n.textContent=t)}destroy(){if(this.stopMonitoring(),this.scrollHandler&&this.container){const e=this.container.querySelector(".resource-memory-content");e&&e.removeEventListener("scroll",this.scrollHandler)}this.container&&this.container.parentNode&&this.container.parentNode.removeChild(this.container),this.container=null,this.scrollHandler=null}adjustTextOverflow(){if(!this.container)return;this.container.querySelectorAll(".category-title").forEach((e=>{this.adjustSingleTitleOverflow(e)}))}adjustSingleTitleOverflow(e){e.hasAttribute("data-overflow-checked")||(e.setAttribute("data-overflow-checked","true"),e.scrollWidth>e.clientWidth&&(e.classList.add("text-overflow"),setTimeout((()=>{e.scrollWidth>e.clientWidth&&(e.classList.remove("text-overflow"),e.classList.add("text-overflow-small"))}),250)))}escapeSelector(e){return e.replace(/[^\w-]/g,"_")}}class P{constructor(){this.container=null,this.content=null,this.toggleButton=null,this.resizeHandle=null,this.isOpen=!1,this.toggleCallback=null,this.isResizing=!1,this.startX=0,this.startWidth=0,this.minWidth=150,this.maxWidth=800,this.defaultWidth=300}create(){this.createContainer(),this.createToggleButton(),this.createContent(),this.createResizeHandle(),this.applyStyles(),this.bindEvents(),this.bindResizeEvents(),this.setInitialState()}createContainer(){this.container=document.createElement("div"),this.container.id="node-inspector-right-drawer",this.container.style.width=`${this.defaultWidth}px`,document.body.appendChild(this.container)}createToggleButton(){this.toggleButton=document.createElement("div"),this.toggleButton.id="node-inspector-right-toggle",this.toggleButton.innerHTML="内<br>存<br>监<br>控",this.toggleButton.title="切换资源监控器",this.container.appendChild(this.toggleButton)}createContent(){this.content=document.createElement("div"),this.content.id="node-inspector-right-content",this.container.appendChild(this.content)}createResizeHandle(){this.resizeHandle=document.createElement("div"),this.resizeHandle.id="node-inspector-right-resize-handle",this.container.appendChild(this.resizeHandle)}applyStyles(){const e=document.createElement("style");e.textContent=`\n            #node-inspector-right-drawer {\n                position: fixed;\n                top: 0;\n                right: 0;\n                height: 100vh;\n                background: #2d2d2d;\n                border-left: 1px solid #444;\n                z-index: 10000;\n                transition: transform 0.3s ease;\n                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n                font-size: 12px;\n                color: #fff;\n                box-shadow: -2px 0 10px rgba(0,0,0,0.3);\n                min-width: ${this.minWidth}px;\n                max-width: ${this.maxWidth}px;\n            }\n\n            #node-inspector-right-drawer.closed {\n                transform: translateX(100%);\n            }\n\n            #node-inspector-right-toggle {\n                position: absolute;\n                top: calc(50vh + 100px);\n                left: -30px;\n                transform: translateY(-50%);\n                width: 30px;\n                height: 160px;\n                background: #2d2d2d;\n                border: 1px solid #444;\n                border-right: none;\n                border-radius: 5px 0 0 5px;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                cursor: pointer;\n                font-size: 14px;\n                color: #fff;\n                user-select: none;\n                transition: background 0.2s ease;\n            }\n\n            #node-inspector-right-toggle:hover {\n                background: #3d3d3d;\n            }\n\n            #node-inspector-right-resize-handle {\n                position: absolute;\n                top: 0;\n                left: 0;\n                width: 4px;\n                height: 100%;\n                background: transparent;\n                cursor: col-resize;\n                z-index: 1001;\n                transition: background 0.2s ease;\n            }\n\n            #node-inspector-right-resize-handle:hover {\n                background: #0078d4;\n            }\n\n            #node-inspector-right-content {\n                width: 100%;\n                height: 100%;\n                overflow: hidden;\n                padding-left: 4px;\n                padding-right: 12px;\n                box-sizing: border-box;\n                background: transparent;\n            }\n\n            .node-inspector-right-panel {\n                background: #2d2d2d;\n                border-bottom: 1px solid #444;\n                overflow: auto;\n            }\n\n            .node-inspector-right-panel h3 {\n                margin: 0;\n                padding: 10px;\n                background: #1e1e1e;\n                border-bottom: 1px solid #444;\n                font-size: 14px;\n                font-weight: bold;\n            }\n\n            /* 拖拽时的样式 */\n            body.resizing-right-drawer {\n                user-select: none;\n                cursor: col-resize !important;\n            }\n\n            body.resizing-right-drawer * {\n                pointer-events: none !important;\n            }\n\n            body.resizing-right-drawer #node-inspector-right-drawer {\n                pointer-events: auto !important;\n            }\n\n            body.resizing-right-drawer #node-inspector-right-resize-handle {\n                pointer-events: auto !important;\n            }\n\n            /* 防止iframe或canvas干扰 */\n            body.resizing-right-drawer iframe,\n            body.resizing-right-drawer canvas,\n            body.resizing-right-drawer embed,\n            body.resizing-right-drawer object {\n                pointer-events: none !important;\n            }\n        `,document.head.appendChild(e)}bindEvents(){this.toggleButton&&this.toggleButton.addEventListener("click",(()=>{this.toggle()}))}toggle(){this.isOpen=!this.isOpen,this.updateUI(),this.toggleCallback&&this.toggleCallback(this.isOpen)}onToggle(e){this.toggleCallback=e}isDrawerOpen(){return this.isOpen}getContentContainer(){return this.content}destroy(){this.container&&(document.body.removeChild(this.container),this.container=null),this.content=null,this.toggleButton=null,this.resizeHandle=null}setInitialState(){this.isOpen=!1,this.updateUI()}updateUI(){this.container&&(this.isOpen?this.container.classList.remove("closed"):this.container.classList.add("closed"))}bindResizeEvents(){this.resizeHandle&&(this.resizeHandle.addEventListener("mousedown",(e=>{this.startResize(e)})),document.addEventListener("mousemove",(e=>{this.handleResize(e)}),{capture:!0}),document.addEventListener("mouseup",(e=>{this.stopResize()}),{capture:!0}),document.addEventListener("mouseleave",(()=>{this.stopResize()})),window.addEventListener("blur",(()=>{this.stopResize()})))}startResize(e){this.isResizing=!0,this.startX=e.clientX,this.startWidth=this.container.clientWidth,document.body.classList.add("resizing-right-drawer"),this.resizeHandle.style.background="#0078d4",e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()}handleResize(e){if(!this.isResizing)return;const t=this.startX-e.clientX,n=Math.max(this.minWidth,Math.min(this.maxWidth,this.startWidth+t));this.container.style.width=`${n}px`,e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()}stopResize(){this.isResizing&&(this.isResizing=!1,document.body.classList.remove("resizing-right-drawer"),this.resizeHandle.style.background="")}resetWidth(){this.container&&(this.container.style.width=`${this.defaultWidth}px`)}}class w{constructor(){this.container=null,this.treeContainer=null,this.nodeSelectCallback=null,this.nodeHighlightCallback=null,this.expandedNodes=new Set,this.selectedNodeId=null,this.lastNodesHash="",this.isInteracting=!1,this.filterInput=null,this.clearButton=null,this.allNodes=[],this.filterText=""}create(e){this.createContainer(e),this.applyStyles()}createContainer(e){this.container=document.createElement("div"),this.container.className="node-inspector-panel node-tree";const t=document.createElement("div");t.className="node-tree-header";const n=document.createElement("h3");n.textContent="节点树",t.appendChild(n);const i=document.createElement("div");i.className="filter-container",this.filterInput=document.createElement("input"),this.filterInput.type="text",this.filterInput.placeholder="过滤节点...",this.filterInput.className="filter-input",this.filterInput.addEventListener("input",(e=>{this.filterText=e.target.value,this.applyFilter()})),this.clearButton=document.createElement("button"),this.clearButton.textContent="×",this.clearButton.className="clear-button",this.clearButton.title="清除过滤",this.clearButton.addEventListener("click",(()=>{this.clearFilter()})),i.appendChild(this.filterInput),i.appendChild(this.clearButton),t.appendChild(i),this.container.appendChild(t),this.treeContainer=document.createElement("div"),this.treeContainer.className="tree-container",this.container.appendChild(this.treeContainer),e.appendChild(this.container)}applyStyles(){const e=document.createElement("style");e.textContent="\n            .node-tree {\n                display: flex;\n                flex-direction: column;\n                height: 100%;\n            }\n\n            .node-tree-header {\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n                padding: 2px 2px;\n                border-bottom: 1px solid #444;\n                background: #2d2d2d;\n                flex-shrink: 0;\n                position: sticky;\n                top: 0;\n                z-index: 10;\n            }\n\n            .node-tree-header h3 {\n                margin: 0;\n                font-size: 14px;\n                color: #fff;\n            }\n\n            .filter-container {\n                display: flex;\n                align-items: center;\n                gap: 4px;\n            }\n\n            .filter-input {\n                width: 120px;\n                height: 24px;\n                padding: 0 8px;\n                border: 1px solid #555;\n                border-radius: 3px;\n                background: #2d2d2d;\n                color: #fff;\n                font-size: 12px;\n                outline: none;\n            }\n\n            .filter-input:focus {\n                border-color: #0078d4;\n            }\n\n            .filter-input::placeholder {\n                color: #888;\n            }\n\n            .clear-button {\n                width: 24px;\n                height: 24px;\n                padding: 0;\n                border: 1px solid #555;\n                border-radius: 3px;\n                background: #2d2d2d;\n                color: #fff;\n                font-size: 14px;\n                cursor: pointer;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                transition: all 0.2s ease;\n            }\n\n            .clear-button:hover {\n                background: #3d3d3d;\n                border-color: #666;\n            }\n\n            .clear-button:active {\n                background: #1d1d1d;\n            }\n\n            .tree-container {\n                flex: 1;\n                overflow-y: auto;\n                padding: 5px;\n            }\n\n            .tree-node {\n                margin: 1px 0;\n                user-select: none;\n            }\n\n            .tree-node-header {\n                display: flex;\n                align-items: center;\n                padding: 2px 8px;\n                cursor: pointer;\n                border-radius: 3px;\n                transition: background 0.2s ease;\n            }\n\n            .tree-node-header.inactive {\n                opacity: 0.5;\n            }\n\n            .tree-node-header.filtered {\n                background: #4a4a00;\n            }\n\n            .tree-node-header:hover {\n                background: #3d3d3d;\n            }\n\n            .tree-node-header.selected {\n                background: #0078d4;\n            }\n\n            .tree-node-header.filtered:hover {\n                background: #3d3d3d;\n            }\n\n            .tree-node-header.filtered.selected {\n                background: #0078d4;\n            }\n\n            .tree-node-expand {\n                width: 16px;\n                height: 16px;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                margin-right: 4px;\n                font-size: 10px;\n                color: #ccc;\n                cursor: pointer;\n            }\n\n            .tree-node-expand.empty {\n                visibility: hidden;\n            }\n\n            .tree-node-name {\n                flex: 1;\n                font-size: 12px;\n                color: #fff;\n                overflow: hidden;\n                text-overflow: ellipsis;\n                white-space: nowrap;\n                text-align: left;\n            }\n\n            .tree-node-highlight {\n                width: 36px;\n                height: 20px;\n                margin-left: 4px;\n                padding: 0;\n                border: 1px solid #666;\n                border-radius: 3px;\n                background: #2d2d2d;\n                color: #fff;\n                font-size: 16px;\n                cursor: pointer;\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                transition: all 0.2s ease;\n                flex-shrink: 0;\n                opacity: 0;\n                visibility: hidden;\n            }\n\n            .tree-node-header:hover .tree-node-highlight {\n                opacity: 1;\n                visibility: visible;\n            }\n\n            .tree-node-highlight:hover {\n                background: #3d3d3d;\n                border-color: #0078d4;\n            }\n\n            .tree-node-highlight:active {\n                background: #1d1d1d;\n            }\n\n            .tree-node-children {\n                margin-left: 5px;\n                border-left: 1px solid #444;\n                padding-left: 2px;\n            }\n\n            .tree-node-children.collapsed {\n                display: none;\n            }\n\n            .tree-empty {\n                padding: 20px;\n                text-align: center;\n                color: #888;\n                font-style: italic;\n            }\n        ",document.head.appendChild(e)}updateTree(e){if(!this.treeContainer)return;if(this.isInteracting)return;this.allNodes=e;const t=this.calculateNodesHash(e);t!==this.lastNodesHash&&(this.lastNodesHash=t,this.renderTree())}renderTree(){if(!this.treeContainer)return;this.treeContainer.innerHTML="";const e=this.filterText?this.getFilteredNodes():this.allNodes;if(0===e.length){const e=document.createElement("div");return e.className="tree-empty",e.textContent=this.filterText?"未找到匹配的节点":"未找到节点",void this.treeContainer.appendChild(e)}e.forEach((e=>{const t=this.createNodeElement(e,0);this.treeContainer&&this.treeContainer.appendChild(t)}))}getFilteredNodes(){if(!this.filterText)return this.allNodes;const e=this.filterText.toLowerCase(),t=[],n=t=>{const i=t.name.toLowerCase().includes(e),o=[];return t.children&&t.children.length>0&&t.children.forEach((e=>{const t=n(e);t&&o.push(t)})),i?Object.assign(Object.assign({},t),{children:t.children}):o.length>0?Object.assign(Object.assign({},t),{children:o}):null};return this.allNodes.forEach((e=>{const i=n(e);i&&t.push(i)})),t}applyFilter(){this.renderTree(),this.filterText&&this.expandFilteredNodes()}expandFilteredNodes(){const e=new Set,t=n=>{n.name.toLowerCase().includes(this.filterText.toLowerCase())&&e.add(n.id),n.children&&n.children.length>0&&n.children.forEach((e=>t(e)))};this.expandedNodes.clear();const n=t=>{let i=!1;if(t.children&&t.children.length>0)for(const o of t.children)e.has(o.id)&&(i=!0),n(o)&&(i=!0);return i&&this.expandedNodes.add(t.id),i};this.allNodes.forEach((e=>t(e))),this.allNodes.forEach((e=>n(e))),this.renderTree()}clearFilter(){this.filterInput&&(this.filterInput.value="",this.filterText="",this.applyFilter())}calculateNodesHash(e){const t=[],n=e=>{t.push(`${e.id}|${e.name}|${e.active}`),e.children&&e.children.length>0&&(t.push(`children:${e.children.length}`),e.children.forEach((e=>n(e))))};return e.forEach((e=>n(e))),t.join("#")}createNodeElement(e,t){const n=document.createElement("div");n.className="tree-node",n.dataset.nodeId=e.id;const i=document.createElement("div");i.className="tree-node-header",e.active||i.classList.add("inactive"),this.selectedNodeId===e.id&&i.classList.add("selected"),this.filterText&&e.name.toLowerCase().includes(this.filterText.toLowerCase())&&i.classList.add("filtered");const o=document.createElement("div");if(o.className="tree-node-expand",e.children.length>0){const t=this.expandedNodes.has(e.id);o.textContent=t?"▼":"▶",o.addEventListener("click",(t=>{t.stopPropagation(),this.handleNodeExpansion(e.id)}))}else o.classList.add("empty");const r=document.createElement("div");r.className="tree-node-name",r.textContent=e.name;const s=document.createElement("button");if(s.className="tree-node-highlight",s.textContent="📌",s.title="显示包围盒",s.addEventListener("click",(t=>{t.stopPropagation(),this.handleNodeHighlight(e)})),i.appendChild(o),i.appendChild(r),i.appendChild(s),i.addEventListener("click",(t=>{t.target!==s&&this.handleNodeClick(e)})),n.appendChild(i),e.children.length>0){const i=document.createElement("div");i.className="tree-node-children",this.expandedNodes.has(e.id)||i.classList.add("collapsed"),e.children.forEach((e=>{const n=this.createNodeElement(e,t+1);i.appendChild(n)})),n.appendChild(i)}return n}handleNodeExpansion(e){this.isInteracting=!0,this.toggleNodeExpansion(e),setTimeout((()=>{this.isInteracting=!1}),200)}toggleNodeExpansion(e){var t;this.expandedNodes.has(e)?this.expandedNodes.delete(e):this.expandedNodes.add(e);const n=null===(t=this.treeContainer)||void 0===t?void 0:t.querySelector(`[data-node-id="${e}"]`);if(n){const t=n.querySelector(".tree-node-expand"),i=n.querySelector(".tree-node-children");if(t&&i){const n=this.expandedNodes.has(e);t.textContent=n?"▼":"▶",n?i.classList.remove("collapsed"):i.classList.add("collapsed")}}}handleNodeClick(e){this.isInteracting=!0,this.selectNode(e),setTimeout((()=>{this.isInteracting=!1}),200)}handleNodeHighlight(e){this.nodeHighlightCallback&&this.nodeHighlightCallback(e)}selectNode(e){var t,n;if(this.selectedNodeId){const e=null===(t=this.treeContainer)||void 0===t?void 0:t.querySelector(`[data-node-id="${this.selectedNodeId}"] .tree-node-header`);e&&e.classList.remove("selected")}this.selectedNodeId=e.id;const i=null===(n=this.treeContainer)||void 0===n?void 0:n.querySelector(`[data-node-id="${e.id}"] .tree-node-header`);i&&i.classList.add("selected"),this.nodeSelectCallback&&this.nodeSelectCallback(e)}onNodeSelect(e){this.nodeSelectCallback=e}onNodeHighlight(e){this.nodeHighlightCallback=e}}class _{constructor(){this.container=null,this.propertiesContainer=null,this.propertyChangeCallback=null,this.refreshNodeCallback=null,this.showTooltipCallback=null,this.currentNode=null,this.debugButton=null,this.refreshButton=null,this.header=null}create(e){this.createContainer(e),this.applyStyles()}createContainer(e){this.container=document.createElement("div"),this.container.className="node-inspector-panel property-panel",this.header=document.createElement("h3"),this.header.className="property-panel-header",this.header.textContent="节点属性";const t=document.createElement("div");t.className="property-panel-buttons",this.refreshButton=document.createElement("button"),this.refreshButton.className="refresh-button",this.refreshButton.textContent="刷新",this.refreshButton.title="重新读取选中节点的属性",this.refreshButton.style.display="none",this.refreshButton.addEventListener("click",(()=>{this.refreshNodeProperties()})),t.appendChild(this.refreshButton),this.debugButton=document.createElement("button"),this.debugButton.className="debug-output-button",this.debugButton.textContent="输出",this.debugButton.title="输出选中节点的路径和属性",this.debugButton.disabled=!0,this.debugButton.addEventListener("click",(()=>{this.outputNodeDebugInfo()})),t.appendChild(this.debugButton),this.header.appendChild(t),this.container.appendChild(this.header),this.propertiesContainer=document.createElement("div"),this.propertiesContainer.className="properties-container",this.container.appendChild(this.propertiesContainer),e.appendChild(this.container),this.showEmptyState()}applyStyles(){const e=document.createElement("style");e.textContent='\n            .property-panel-header {\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n                position: relative;\n            }\n\n            .property-panel-buttons {\n                display: flex;\n                align-items: center;\n                justify-content: flex-end;\n                gap: 4px;\n                height: 18px;\n            }\n\n            .refresh-button, .debug-output-button {\n                /* 重置所有默认样式 */\n                margin: 0;\n                padding: 0;\n                border: none;\n                outline: none;\n                background: none;\n                font-family: inherit;\n                font-size: 11px;\n                line-height: 1;\n                text-align: center;\n                color: white;\n                cursor: pointer;\n                transition: background-color 0.2s;\n                \n                /* 布局属性 */\n                display: flex;\n                align-items: center;\n                justify-content: center;\n                box-sizing: border-box;\n                height: 18px;\n                border-radius: 3px;\n                \n                /* 去除浏览器默认样式 */\n                -webkit-appearance: none;\n                -moz-appearance: none;\n                appearance: none;\n                vertical-align: baseline;\n            }\n\n            .refresh-button {\n                background: #28a745;\n                width: 60px;\n            }\n\n            .refresh-button:hover {\n                background: #218838;\n            }\n\n            .debug-output-button {\n                background: #0078d4;\n                width: 30px;\n            }\n\n            .debug-output-button:hover:not(:disabled) {\n                background: #106ebe;\n            }\n\n            .debug-output-button:disabled {\n                background: #444;\n                cursor: not-allowed;\n                color: #888;\n            }\n\n            .properties-container {\n                padding: 8px;\n                overflow: visible;\n            }\n\n            .property-row {\n                display: flex;\n                align-items: center;\n                margin-bottom: 4px;\n                padding: 1px 0;\n            }\n\n            .property-label {\n                flex: 0 0 60px;\n                font-size: 11px;\n                color: #ccc;\n                margin-right: 6px;\n                text-align: right;\n            }\n\n            .property-input {\n                flex: 1;\n                background: #1e1e1e;\n                border: 1px solid #444;\n                border-radius: 3px;\n                padding: 3px 5px;\n                color: #fff;\n                font-size: 11px;\n                font-family: monospace;\n            }\n\n            .property-input:focus {\n                outline: none;\n                border-color: #0078d4;\n                box-shadow: 0 0 0 1px #0078d4;\n            }\n\n            .property-input[type="checkbox"] {\n                flex: none;\n                width: 16px;\n                height: 16px;\n                margin: 0;\n            }\n\n            .property-input[type="color"] {\n                flex: none;\n                width: 32px;\n                height: 16px;\n                padding: 0;\n                border: none;\n                border-radius: 3px;\n                cursor: pointer;\n            }\n\n            .property-empty {\n                padding: 15px;\n                text-align: center;\n                color: #888;\n                font-style: italic;\n                font-size: 12px;\n            }\n\n            .color-input-group {\n                display: flex;\n                align-items: center;\n                gap: 3px;\n            }\n\n            .color-input-group input[type="number"] {\n                width: 45px;\n            }\n        ',document.head.appendChild(e)}displayNodeProperties(e){if(!this.propertiesContainer)return;this.currentNode=e,this.propertiesContainer.innerHTML="",this.debugButton&&(this.debugButton.disabled=!1),this.refreshButton&&(this.refreshButton.style.display="inline-block");if([{key:"active",label:"激活",value:e.active,type:"boolean"},{key:"name",label:"名称",value:e.name,type:"string"},{key:"x",label:"X坐标",value:e.position.x,type:"number"},{key:"y",label:"Y坐标",value:e.position.y,type:"number"},{key:"anchorX",label:"锚点X",value:e.anchor.x,type:"number"},{key:"anchorY",label:"锚点Y",value:e.anchor.y,type:"number"},{key:"width",label:"宽度",value:e.size.width,type:"number"},{key:"height",label:"高度",value:e.size.height,type:"number"},{key:"scaleX",label:"X缩放",value:e.scale.x,type:"number"},{key:"scaleY",label:"Y缩放",value:e.scale.y,type:"number"},{key:"rotation",label:"旋转",value:e.rotation,type:"number"},{key:"opacity",label:"透明度",value:e.color.a,type:"number"}].forEach((e=>{const t=this.createPropertyRow(e.key,e.label,e.value,e.type);this.propertiesContainer.appendChild(t)})),e.label){const t=this.createPropertyRow("label.text","文本",e.label.text,"string"),n=this.createPropertyRow("label.fontSize","字号",e.label.fontSize,"number");this.propertiesContainer.appendChild(t),this.propertiesContainer.appendChild(n)}this.createColorPropertyRows(e.color)}refreshNodeProperties(){if(this.currentNode)if(this.refreshNodeCallback)try{const e=this.refreshNodeCallback(this.currentNode);this.currentNode=e,this.displayNodeProperties(e),console.log("节点属性已刷新"),this.showTooltipCallback&&this.refreshButton&&this.showTooltipCallback("刷新完成",this.refreshButton)}catch(e){console.error("刷新节点属性失败:",e)}else console.warn("没有设置刷新回调函数");else console.warn("没有选中的节点")}outputNodeDebugInfo(){if(!this.currentNode)return void console.warn("没有选中的节点");const e=this.getNodePath(this.currentNode),t=this.getNodeProperties(this.currentNode);console.log("=== 节点调试信息 ==="),console.log("节点路径:",e),console.log("节点属性:",t),console.log("原始节点对象:",this.currentNode),console.log("=================="),this.showTooltipCallback&&this.debugButton&&this.showTooltipCallback("节点信息已输出到控制台",this.debugButton)}getNodePath(e){const t=[];let n=e;if(t.unshift(n.name),n.ccNode)try{let e=n.ccNode.parent,i=0;const o=20;for(;e&&i<o;){const n=this.getNodeName(e);t.unshift(n),e=e.parent,i++}}catch(e){console.warn("获取节点路径时出错:",e),t.unshift("[路径获取失败]")}return t.join("/")}getNodeName(e){var t,n;return e?e.name||e._name||(null===(t=e.node)||void 0===t?void 0:t.name)||`Node_${(null===(n=e.uuid)||void 0===n?void 0:n.substring(0,8))||"Unknown"}`:"UnknownNode"}getNodeProperties(e){const t={"基本信息":{ID:e.id,"名称":e.name,"激活状态":e.active},"位置信息":{"坐标":`(${e.position.x}, ${e.position.y})`,"锚点":`(${e.anchor.x}, ${e.anchor.y})`},"尺寸信息":{"大小":`${e.size.width} x ${e.size.height}`,"缩放":`(${e.scale.x}, ${e.scale.y})`},"变换信息":{"旋转角度":`${e.rotation}°`},"外观信息":{"颜色":`RGB(${e.color.r}, ${e.color.g}, ${e.color.b})`,"透明度":e.color.a},"层级信息":{"子节点数量":e.children.length,"子节点":e.children.map((e=>e.name))}};return e.label&&(t.Label组件={"文本内容":e.label.text,"字体大小":e.label.fontSize}),e.ccNode&&(t.Creator信息=this.getCreatorSpecificInfo(e.ccNode)),t}getCreatorSpecificInfo(e){var t,n,i,o,r;const s={"版本检测":this.detectCreatorVersion(),"节点类型":(null===(t=e.constructor)||void 0===t?void 0:t.name)||"Unknown"};try{if(void 0!==e.color)s.Creator版本="2.x",s.原始属性={uuid:e.uuid,x:e.x,y:e.y,width:e.width,height:e.height,scaleX:e.scaleX,scaleY:e.scaleY,angle:e.angle,opacity:e.opacity,anchorX:e.anchorX,anchorY:e.anchorY};else{s.Creator版本="3.x+";const t=null===(n=e.getComponent)||void 0===n?void 0:n.call(e,"cc.UITransform"),a=(null===(i=e.getComponent)||void 0===i?void 0:i.call(e,"cc.UIRenderer"))||(null===(o=e.getComponent)||void 0===o?void 0:o.call(e,"cc.Renderable2D"));s.原始属性={uuid:e.uuid,position:e.position,scale:e.scale,angle:e.angle},t&&(s.UITransform组件={width:t.width,height:t.height,anchorX:t.anchorX,anchorY:t.anchorY}),a&&(s.渲染组件={"类型":(null===(r=a.constructor)||void 0===r?void 0:r.name)||"Unknown","颜色":a.color})}s.父节点=e.parent?this.getNodeName(e.parent):"无",s.组件列表=this.getNodeComponents(e)}catch(e){s.错误=`获取Creator信息时出错: ${e instanceof Error?e.message:String(e)}`}return s}detectCreatorVersion(){try{const e=window.cc,t=(null==e?void 0:e.ENGINE_VERSION)||"未知";return t.startsWith("2.")?`Creator 2.x (${t})`:t.startsWith("3.")?`Creator 3.x (${t})`:t.startsWith("4.")?`Creator 4.x (${t})`:`未知版本 (${t})`}catch(e){return"版本检测失败"}}getNodeComponents(e){try{return e._components&&Array.isArray(e._components)?e._components.map((e=>{var t;return(null===(t=e.constructor)||void 0===t?void 0:t.name)||e.__classname__||"Unknown"})):["组件信息不可用"]}catch(e){return["获取组件失败"]}}createColorPropertyRows(e){if(!this.propertiesContainer)return;const t=document.createElement("div");t.className="property-row";const n=document.createElement("div");n.className="property-label",n.textContent="RGB",t.appendChild(n);const i=document.createElement("div");i.className="color-input-group";const o=document.createElement("input");o.type="number",o.className="property-input",o.value=e.r.toString(),o.min="0",o.max="255",o.addEventListener("change",(()=>{let e=Math.max(0,Math.min(255,Math.round(parseInt(o.value)||0)));o.value=e.toString(),this.handlePropertyChange("color.r",e)}));const r=document.createElement("input");r.type="number",r.className="property-input",r.value=e.g.toString(),r.min="0",r.max="255",r.addEventListener("change",(()=>{let e=Math.max(0,Math.min(255,Math.round(parseInt(r.value)||0)));r.value=e.toString(),this.handlePropertyChange("color.g",e)}));const s=document.createElement("input");s.type="number",s.className="property-input",s.value=e.b.toString(),s.min="0",s.max="255",s.addEventListener("change",(()=>{let e=Math.max(0,Math.min(255,Math.round(parseInt(s.value)||0)));s.value=e.toString(),this.handlePropertyChange("color.b",e)}));const a=document.createElement("input");a.type="color",a.className="property-input",a.value=this.rgbToHex(e.r,e.g,e.b),a.addEventListener("change",(()=>{const e=this.hexToRgb(a.value);if(e){const t=Math.max(0,Math.min(255,Math.round(e.r))),n=Math.max(0,Math.min(255,Math.round(e.g))),i=Math.max(0,Math.min(255,Math.round(e.b)));o.value=t.toString(),r.value=n.toString(),s.value=i.toString(),this.handlePropertyChange("color.r",t),this.handlePropertyChange("color.g",n),this.handlePropertyChange("color.b",i)}})),i.appendChild(o),i.appendChild(r),i.appendChild(s),i.appendChild(a),t.appendChild(i),this.propertiesContainer.appendChild(t)}createPropertyRow(e,t,n,i){const o=document.createElement("div");o.className="property-row";const r=document.createElement("div");r.className="property-label",r.textContent=t,o.appendChild(r);const s=document.createElement("input");switch(s.className="property-input",i){case"boolean":s.type="checkbox",s.checked=Boolean(n),s.addEventListener("change",(()=>{this.handlePropertyChange(e,s.checked)}));break;case"number":s.type="number",s.value=n.toString(),s.step=e.includes("scale")?"0.1":"1","opacity"===e&&(s.min="0",s.max="255"),s.addEventListener("change",(()=>{let t=parseFloat(s.value);"opacity"===e&&(t=Math.max(0,Math.min(255,Math.round(t))),s.value=t.toString()),this.handlePropertyChange(e,t)}));break;case"string":s.type="text",s.value=n.toString(),s.addEventListener("change",(()=>{this.handlePropertyChange(e,s.value)}))}return o.appendChild(s),o}handlePropertyChange(e,t){this.propertyChangeCallback&&this.propertyChangeCallback(e,t)}showEmptyState(){if(!this.propertiesContainer)return;this.currentNode=null,this.debugButton&&(this.debugButton.disabled=!0),this.refreshButton&&(this.refreshButton.style.display="none"),this.propertiesContainer.innerHTML="";const e=document.createElement("div");e.className="property-empty",e.textContent="请选择一个节点",this.propertiesContainer.appendChild(e)}rgbToHex(e,t,n){return"#"+((1<<24)+(e<<16)+(t<<8)+n).toString(16).slice(1)}hexToRgb(e){const t=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);return t?{r:parseInt(t[1],16),g:parseInt(t[2],16),b:parseInt(t[3],16)}:null}onPropertyChange(e){this.propertyChangeCallback=e}onRefreshNode(e){this.refreshNodeCallback=e}onShowTooltip(e){this.showTooltipCallback=e}}class S{processChildren(e){const t=[];return e.children&&e.children.length>0&&e.children.forEach((e=>{t.push(this.convertCCNodeToNodeData(e))})),t}generateNodeId(e){if(e.uuid)return e.uuid;if(e._id)return e._id;this.nodeIdCache||(this.nodeIdCache=new WeakMap);let t=this.nodeIdCache.get(e);return t||(t=this.generateFallbackId(e),this.nodeIdCache.set(e,t)),t}generateFallbackId(e){const t=this.getNodePath(e);if(t)return`path_${t}`;const n=e.name||"unknown",i=Math.floor(e.x||0),o=Math.floor(e.y||0);return this.nodeIdCounter||(this.nodeIdCounter=0),this.nodeIdCounter++,`node_${n}_${i}_${o}_${this.nodeIdCounter}`}getNodePath(e){const t=[];let n=e;try{for(;n&&n.parent;){const e=n.parent;if(e.children){const i=e.children.indexOf(n);i>=0&&t.unshift(i.toString())}n=e}return t.length>0?t.join("_"):null}catch(e){return null}}getNodeName(e){var t,n;return(null===(t=e.$gobj)||void 0===t?void 0:t.name)||(null===(n=e.$gobj)||void 0===n?void 0:n._name)||e.name||"未命名节点"}getNodeActive(e){return void 0===e.active||e.active}createDOMHighlight(e){try{const t=document.getElementById("node-inspector-highlight");t&&t.remove();const n=document.createElement("div");n.id="node-inspector-highlight",n.style.cssText=`\n                position: fixed;\n                left: ${e.x}px;\n                top: ${e.y}px;\n                width: ${e.width}px;\n                height: ${e.height}px;\n                border: 4px solid #ffff00;\n                background: rgba(255, 255, 0, 0.65);\n                pointer-events: none;\n                z-index: 999999;\n                box-sizing: border-box;\n                border-radius: 4px;\n                animation: nodeInspectorHighlightBlink 1.5s ease-in-out forwards;\n            `,this.ensureHighlightStyles(),document.body.appendChild(n),setTimeout((()=>{n&&n.parentNode&&n.remove()}),1500)}catch(e){console.error("创建DOM高亮层失败:",e)}}ensureHighlightStyles(){const e="node-inspector-highlight-styles";if(!document.getElementById(e)){const t=document.createElement("style");t.id=e,t.textContent="\n                @keyframes nodeInspectorHighlightBlink {\n                    0% { \n                        opacity: 1; \n                        transform: scale(1);\n                        box-shadow: 0 0 20px rgba(255, 255, 0, 0.8);\n                    }\n                    25% { \n                        opacity: 0.4; \n                        transform: scale(1.02);\n                        box-shadow: 0 0 30px rgba(255, 255, 0, 0.6);\n                    }\n                    50% { \n                        opacity: 1; \n                        transform: scale(1);\n                        box-shadow: 0 0 20px rgba(255, 255, 0, 0.8);\n                    }\n                    75% { \n                        opacity: 0.4; \n                        transform: scale(1.02);\n                        box-shadow: 0 0 30px rgba(255, 255, 0, 0.6);\n                    }\n                    100% { \n                        opacity: 0; \n                        transform: scale(1);\n                        box-shadow: 0 0 10px rgba(255, 255, 0, 0.3);\n                    }\n                }\n            ",document.head.appendChild(t)}}}class k extends S{constructor(){super(),console.log("*********** 项目设置 ***********"),console.log("creator版本",(null===cc||void 0===cc?void 0:cc.ENGINE_VERSION)||"");const e=cc.game.canvas;if(!e)return void console.log("❌ 未找到GameCanvas元素");const t=e.getBoundingClientRect(),n=cc.view.getDesignResolutionSize();let i=cc.view.getDevicePixelRatio();console.log("dom画布rect",t.x,t.y,t.width,t.height),console.log("设计尺寸",n.width,n.height),console.log("像素比",i);const o=cc.Canvas.instance;o&&(o.fitWidth&&o.fitHeight?console.log("适配策略: 宽高适配"):o.fitHeight&&!o.fitWidth?console.log("适配策略: 高度适配"):!o.fitHeight&&o.fitWidth?console.log("适配策略: 宽度适配"):console.log("适配策略: 无适配")),console.log("********************************")}convertCCNodeToNodeData(e){let t;const n=e.getComponent("cc.Label")||e.getComponent(cc.Label);n&&(t={text:n.string||"",fontSize:n.fontSize||40});return{id:this.generateNodeId(e),name:this.getNodeName(e),active:this.getNodeActive(e),position:{x:e.x||0,y:e.y||0},anchor:{x:e.anchorX||.5,y:e.anchorY||.5},size:{width:e.width||0,height:e.height||0},scale:{x:e.scaleX||1,y:e.scaleY||1},rotation:e.angle||0,color:{r:e.color.r||255,g:e.color.g||255,b:e.color.b||255,a:e.opacity||255},label:t,children:this.processChildren(e),ccNode:e}}updateNodeProperty(e,t,n){const i=e.ccNode;if(i)try{switch(t){case"active":i.active=Boolean(n);break;case"x":e.position.x=Number(n),i.setPosition(Number(n),e.position.y);break;case"y":e.position.y=Number(n),i.setPosition(e.position.x,Number(n));break;case"anchorX":e.anchor.x=Number(n),i.setAnchorPoint(Number(n),e.anchor.y);break;case"anchorY":e.anchor.y=Number(n),i.setAnchorPoint(e.anchor.x,Number(n));break;case"width":e.size.width=Number(n),i.setContentSize(Number(n),e.size.height);break;case"height":e.size.height=Number(n),i.setContentSize(e.size.width,Number(n));break;case"scaleX":e.scale.x=Number(n),i.setScale(Number(n),e.scale.y);break;case"scaleY":e.scale.y=Number(n),i.setScale(e.scale.x,Number(n));break;case"rotation":i.angle=Number(n);break;case"opacity":i.opacity=Number(n);break;case"color.r":e.color.r=Number(n),i.color=e.color;break;case"color.g":e.color.g=Number(n),i.color=e.color;break;case"color.b":e.color.b=Number(n),i.color=e.color;break;case"label.text":{const t=i.getComponent("cc.Label")||i.getComponent(cc.Label);t&&e.label&&(e.label.text=String(n),t.string=String(n));break}case"label.fontSize":{const t=i.getComponent("cc.Label")||i.getComponent(cc.Label);t&&e.label&&(e.label.fontSize=Number(n),t.fontSize=Number(n));break}}}catch(e){console.error("更新Creator 2.x节点属性失败:",e)}}getNodeScreenRect(e){try{let t=cc.Camera.findCamera(e)||cc.Camera.main;if(!t)return console.error("❌ 未找到节点专属摄像机"),null;let n=this.getNodeScreenAABB(e,t);const i=this.getDomPosition(n.lt),o=this.getDomPosition(n.rb);let r=Math.abs(i.x-o.x),s=Math.abs(i.y-o.y);return{x:i.x,y:Math.min(i.y,o.y),width:r,height:s}}catch(e){return console.error("获取Creator 2.x节点屏幕位置失败:",e),null}}getNodeScreenAABB(e,t){let n=e.getBoundingBoxToWorld();return{lt:t.getWorldToScreenPoint(cc.v2(n.x,n.y+n.height)),rb:t.getWorldToScreenPoint(cc.v2(n.x+n.width,n.y))}}getDomPosition(e){try{const t=cc.game.canvas;if(!t)return x.log("❌ 未找到GameCanvas元素"),{x:0,y:0};const n=t.getBoundingClientRect(),i=cc.view.getDesignResolutionSize();let o=cc.view.getDevicePixelRatio();x.log("像素比",o),x.log("dom画布rect",n.x,n.y,n.width,n.height),x.log("屏幕位置",e.x,e.y),x.log("设计尺寸",i.width,i.height);let r=n.width,s=n.height,a=0,l=0;const c=cc.Canvas.instance;if(c)if(c.fitWidth&&c.fitHeight){let t=Math.min(r/i.width,s/i.height),o=.5*(r-i.width*t);a=n.x+o+e.x/i.width*(r-2*o);let c=.5*(s-i.height*t);l=n.y+s-c-e.y/i.height*(s-2*c)}else if(c.fitHeight&&!c.fitWidth){let t=s/i.height,o=.5*(r-i.width*t);a=n.x+e.x/i.width*(n.width-2*o);let c=.5*(s-i.height*t);l=n.y+s-c-e.y/i.height*(s-2*c)}else if(!c.fitHeight&&c.fitWidth){let t=r/i.width,o=.5*(r-i.width*t),c=.5*(s-i.height*t);a=n.x+o+e.x/i.width*(r-2*o),l=n.y+s-e.y/i.height*(s-2*c)}else{let t=Math.max(r/i.width,s/i.height),o=.5*(r-i.width*t),c=.5*(s-i.height*t);a=n.x+o+e.x/i.width*(r-2*o),l=n.y+s-e.y/i.height*(s-2*c)}return{x:a,y:l}}catch(e){return x.log("Creator屏幕坐标转DOM坐标失败:",e),{x:0,y:0}}}}class N extends S{constructor(){var e,t,n,i,o;super(),console.log("*********** 项目设置 ***********"),console.log("creator版本",(null===cc||void 0===cc?void 0:cc.ENGINE_VERSION)||"");const r=cc.game.canvas;if(!r)return void console.log("❌ 未找到GameCanvas元素");const s=r.getBoundingClientRect(),a=cc.view.getDesignResolutionSize();let l=cc.screen.devicePixelRatio;console.log("dom画布rect",s.x,s.y,s.width,s.height),console.log("设计尺寸",a.width,a.height),console.log("像素比",l);let c=null===(o=null===(i=null===(n=null===(t=null===(e=cc.view)||void 0===e?void 0:e.getResolutionPolicy)||void 0===t?void 0:t.call(e))||void 0===n?void 0:n.getContentStrategy)||void 0===i?void 0:i.call(n))||void 0===o?void 0:o.strategy;console.log("当前策略值=",c),c===cc.ResolutionPolicy.SHOW_ALL?console.log("适配策略: 宽高适配"):c===cc.ResolutionPolicy.FIXED_HEIGHT?console.log("适配策略: 高度适配"):c===cc.ResolutionPolicy.FIXED_WIDTH?console.log("适配策略: 宽度适配"):console.log("适配策略: 无适配"),console.log("********************************")}convertCCNodeToNodeData(e){const t=e.getComponent("cc.UITransform"),n=e.getComponent("cc.UIRenderer")||e.getComponent("cc.Renderable2D");let i;const o=e.getComponent("cc.Label")||e.getComponent(cc.Label);o&&(i={text:o.string||"",fontSize:o.fontSize||40});return{id:this.generateNodeId(e),name:this.getNodeName(e),active:this.getNodeActive(e),position:{x:e.position.x||e.x||0,y:e.position.y||e.y||0},anchor:{x:(null==t?void 0:t.anchorX)||.5,y:(null==t?void 0:t.anchorY)||.5},size:{width:(null==t?void 0:t.width)||0,height:(null==t?void 0:t.height)||0},scale:{x:e.scale.x||1,y:e.scale.y||1},rotation:e.angle||0,color:n?{r:n.color.r||255,g:n.color.g||255,b:n.color.b||255,a:n.color.a||255}:{r:255,g:255,b:255,a:255},label:i,children:this.processChildren(e),ccNode:e}}updateNodeProperty(e,t,n){const i=e.ccNode;if(i)try{switch(t){case"active":i.active=Boolean(n);break;case"x":e.position.x=Number(n),i.setPosition(Number(n),e.position.y);break;case"y":e.position.y=Number(n),i.setPosition(e.position.x,Number(n));break;case"anchorX":{e.anchor.x=Number(n);const t=i.getComponent("cc.UITransform");t&&t.setAnchorPoint(Number(n),e.anchor.y);break}case"anchorY":{e.anchor.y=Number(n);const t=i.getComponent("cc.UITransform");t&&t.setAnchorPoint(e.anchor.x,Number(n));break}case"width":{e.size.width=Number(n);const t=i.getComponent("cc.UITransform");t&&t.setContentSize(Number(n),e.size.height);break}case"height":{e.size.height=Number(n);const t=i.getComponent("cc.UITransform");t&&t.setContentSize(e.size.width,Number(n));break}case"scaleX":e.scale.x=Number(n),i.setScale(Number(n),e.scale.y);break;case"scaleY":e.scale.y=Number(n),i.setScale(e.scale.x,Number(n));break;case"rotation":i.angle=Number(n);break;case"opacity":{e.color.a=Number(n);const t=i.getComponent("cc.UIRenderer")||i.getComponent("cc.Renderable2D");t&&(t.color=e.color);break}case"color.r":{e.color.r=Number(n);const t=i.getComponent("cc.UIRenderer")||i.getComponent("cc.Renderable2D");t&&(t.color=e.color);break}case"color.g":{e.color.g=Number(n);const t=i.getComponent("cc.UIRenderer")||i.getComponent("cc.Renderable2D");t&&(t.color=e.color);break}case"color.b":{e.color.b=Number(n);const t=i.getComponent("cc.UIRenderer")||i.getComponent("cc.Renderable2D");t&&(t.color=e.color);break}case"label.text":{const t=i.getComponent("cc.Label")||i.getComponent(cc.Label);t&&e.label&&(e.label.text=String(n),t.string=String(n));break}case"label.fontSize":{const t=i.getComponent("cc.Label")||i.getComponent(cc.Label);t&&e.label&&(e.label.fontSize=Number(n),t.fontSize=Number(n));break}}}catch(e){console.error("更新Creator 3.x节点属性失败:",e)}}getNodeScreenRect(e){try{const t=this.findCamera(e);if(!t)return console.error("❌ 未找到节点专属摄像机"),null;const n=e.getComponent("cc.UITransform");if(!n)return null;let i=this.getNodeScreenAABB(n,t);const o=this.getDomPosition(i.lt),r=this.getDomPosition(i.rb);let s=Math.abs(o.x-r.x),a=Math.abs(o.y-r.y);return{x:o.x,y:Math.min(o.y,r.y),width:s,height:a}}catch(e){return console.error("获取Creator 3.x节点屏幕位置失败:",e),null}}findCamera(e){if(e.scene&&e.scene.renderScene){const t=e.scene.renderScene.cameras;for(let n=0;n<t.length;n++){const i=t[n];if(i.visibility&e.layer)return i}}return null}getScreenPosition(e,t){const n=e.convertToWorldSpaceAR(cc.v3(0,0,1));x.log(`世界坐标 x:${n.x} y:${n.y} z:${n.z}`);let i=cc.v3();return t.worldToScreen(i,n),x.log(`屏幕坐标 x:${i.x} y:${i.y} z:${i.z}`),i}getNodeScreenAABB(e,t){let n=e.getBoundingBoxToWorld();return{lt:t.worldToScreen(cc.v3(),cc.v3(n.x,n.y+n.height,0)),rb:t.worldToScreen(cc.v3(),cc.v3(n.x+n.width,n.y,0))}}getDomPosition(e){try{const t=cc.game.canvas;if(!t)return x.log("❌ 未找到GameCanvas元素"),{x:0,y:0};const n=t.getBoundingClientRect(),i=cc.view.getDesignResolutionSize();let o=cc.screen.devicePixelRatio;x.log("像素比",o),x.log("dom画布rect",n.x,n.y,n.width,n.height),x.log("屏幕位置",e.x,e.y),x.log("设计尺寸",i.width,i.height);let r=0,s=0;return r=n.x+e.x/o,s=n.y+n.height-e.y/o,{x:r,y:s}}catch(e){return x.log("Creator屏幕坐标转DOM坐标失败:",e),{x:0,y:0}}}}class z{constructor(){this.selectedNode=null,this.nodeUpdateInterval=null,this.nodeTreePanel=new w,this.propertyPanel=new _,f()?this.calculator=new N:this.calculator=new k}initialize(e,t){this.createUI(e),this.bindEvents(),this.propertyPanel.onShowTooltip(t)}createUI(e){this.nodeTreePanel.create(e),this.propertyPanel.create(e)}bindEvents(){this.nodeTreePanel.onNodeSelect((e=>{this.selectedNode=e,this.propertyPanel.displayNodeProperties(e),window.selectNode=null==e?void 0:e.ccNode})),this.nodeTreePanel.onNodeHighlight((e=>{this.highlightNodeInScene(e)})),this.propertyPanel.onPropertyChange(((e,t)=>{this.selectedNode&&this.updateNodeProperty(this.selectedNode,e,t)})),this.propertyPanel.onRefreshNode((e=>e.ccNode?this.convertCCNodeToNodeData(e.ccNode):(console.warn("无法刷新节点：ccNode引用不存在"),e)))}startNodeMonitoring(){this.nodeUpdateInterval&&this.stopNodeMonitoring(),this.nodeUpdateInterval=window.setInterval((()=>{this.updateNodeTree()}),150),console.log("节点监控已开始")}stopNodeMonitoring(){this.nodeUpdateInterval&&(clearInterval(this.nodeUpdateInterval),this.nodeUpdateInterval=null,console.log("节点监控已停止"))}updateNodeTree(){const e=this.getAllRootNodes();this.nodeTreePanel.updateTree(e)}getAllRootNodes(){var e;const t=[];try{const n=null===(e=window.cc)||void 0===e?void 0:e.director;if(n){const e=n.getScene();e&&e.children&&e.children.length>0&&e.children.forEach((e=>{t.push(this.convertCCNodeToNodeData(e))}))}}catch(e){console.warn("无法获取Creator场景节点:",e)}return t}convertCCNodeToNodeData(e){return this.calculator.convertCCNodeToNodeData(e)}updateNodeProperty(e,t,n){if(e.ccNode)try{this.calculator.updateNodeProperty(e,t,n)}catch(e){console.error("更新节点属性失败:",e)}}highlightNodeInScene(e){const t=e.ccNode;if(t)if("undefined"!=typeof document)try{const e=this.calculator.getNodeScreenRect(t);if(!e)return void console.warn("无法获取节点屏幕位置");x.log("显示到dom上的rect",e.x,e.y,e.width,e.height),this.calculator.createDOMHighlight(e)}catch(e){console.error("高亮节点时出错:",e)}else console.warn("非浏览器环境，无法显示DOM高亮效果");else console.warn("无法高亮节点：ccNode引用不存在")}destroy(){this.stopNodeMonitoring()}}class B{constructor(){this.drawerUI=new t,this.rightDrawerUI=new P,this.resourceMemoryPanel=new C,this.nodeManager=new z}initialize(){this.createUI(),this.bindEvents()}createUI(){this.drawerUI.create(),this.rightDrawerUI.create();const e=this.rightDrawerUI.getContentContainer();this.resourceMemoryPanel.create(e);const t=this.drawerUI.getContentContainer();this.nodeManager.initialize(t,this.drawerUI.showTooltip.bind(this.drawerUI))}bindEvents(){this.drawerUI.onToggle((e=>{this.handleDrawerToggle(e)})),this.rightDrawerUI.onToggle((e=>{this.handleRightDrawerToggle(e)}))}handleDrawerToggle(e){e?this.nodeManager.startNodeMonitoring():(this.nodeManager.stopNodeMonitoring(),this.drawerUI.resetWidth())}handleRightDrawerToggle(e){e?(this.resourceMemoryPanel.refreshData(),console.log("\x3c!----右侧抽屉已展开，资源内存监控已激活----\x3e")):(this.rightDrawerUI.resetWidth(),console.log("\x3c!----右侧抽屉已收起----\x3e"))}destroy(){this.nodeManager.destroy(),this.drawerUI.destroy(),this.rightDrawerUI.destroy(),this.resourceMemoryPanel.destroy()}}function A(){const e=new B;return e.initialize(),e}try{const{DEBUG:e,EDITOR:t,isBrowser:n}=function(){var e,t,n,i,o,r,s;let a=!1,l=!1,c=!1;try{const r=window.cc;if(f())try{const t=null==r?void 0:r.env;t?(a=t.DEBUG||!1,l=t.EDITOR||!1):(a=(null==r?void 0:r.DEBUG)||window.DEBUG||window.CC_DEBUG||!1,l=(null==r?void 0:r.EDITOR)||window.EDITOR||window.CC_EDITOR||!1);const n=null===(e=window.cc)||void 0===e?void 0:e.sys;n&&(c=n.isBrowser||!1)}catch(e){a=window.DEBUG||!1,l=window.EDITOR||!1,c=(null===(n=null===(t=window.cc)||void 0===t?void 0:t.sys)||void 0===n?void 0:n.isBrowser)||!1}else a=window.CC_DEBUG||!1,l=window.CC_EDITOR||!1,c=(null===(o=null===(i=window.cc)||void 0===i?void 0:i.sys)||void 0===o?void 0:o.isBrowser)||!1}catch(e){console.warn("检测Creator环境变量失败:",e),a=window.DEBUG||window.CC_DEBUG||!1,l=window.EDITOR||window.CC_EDITOR||!1,c=(null===(s=null===(r=window.cc)||void 0===r?void 0:r.sys)||void 0===s?void 0:s.isBrowser)||!1}return{DEBUG:a,EDITOR:l,isBrowser:c}}();e&&!t&&n&&(A(),console.log("Node Inspector已自动初始化"))}catch(e){console.warn("Node Inspector自动初始化失败，请手动调用 window?.initNodeInspector?.():",e)}window.initNodeInspector=A}();
