import { Tween } from 'cc';
import { _decorator, Collider2D, Component, Contact2DType, IPhysics2DContact, Node, tween, v2, v3, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('main')
export class main extends Component {

    private p : Vec3 = null;
    private ball : Node = null;
    protected onLoad(): void {
        this.ball = this.node.getChildByName("BallMask");
        let p = this.ball.position;
        tween(this.ball).to(3,{position : v3(p.x +600,p.y - 200,0)}).start()
    }

    start() {
        let collider = this.node.getChildByName("BallMask").getChildByName("Ball").getComponent(Collider2D);
        if(collider){
            collider.on(Contact2DType.BEGIN_CONTACT,this.hitBack,this);
        }
    }

    hitBack(self : Collider2D, other : Collider2D, contact : IPhysics2DContact){
        Tween.stopAllByTarget(this.ball)
        let con = contact.getWorldManifold();
        let start = this.ball.worldPosition;
        let end = con.points[0];
        
        let on = con.normal;
        let io = end.subtract(v2(start.x,start.y));
        // or = io - 2(io * on)on
        let or =  io.subtract( on.multiply2f( 2*(io.dot(on)), 2*(io.dot(on))));
        console.log(or);
        or.normalize()
        tween(this.ball).to(3,{worldPosition : v3(start.x + or.x * 1200,start.y + or.y * 1200,0)}).start();

    }


}

