
import { _decorator, Component,view ,screen} from 'cc';
const { ccclass, property } = _decorator;

 
@ccclass('setting')
export class setting extends Component {

    private static _instance: setting;

    public static get instance() {
        if (this._instance) {
            return this._instance;
        }

        this._instance = new setting();
        this._instance.ini()
        return this._instance;
    }

    public static Data:any={};
    public static gameData:any={};
    public static tileMapData:any={};
    public static eventData:any={};

   public Playermove;  //人物是否可以移动
   private mapSize={//地图大小
    height:0,
    width:0
   };
   private frameSize={//实际屏幕分辨率
    height:0,
    width:0
   };
   private designSize={//设计分辨率
    height:0,
    width:0
   };

   private Scale:number;
   private percentage:number;
   private CameraY:number;
   

   private ini(){
       this.Playermove=false;
        this.frameSize.width=view.getFrameSize().width;
        this.frameSize.height=view.getFrameSize().height;

       var fwidth=screen.windowSize.width;
        var fheight=screen.windowSize.height;
   
        this.designSize.width=view.getDesignResolutionSize().width;
        this.designSize.height=view.getDesignResolutionSize().height;

        this.mapSize.width=3000;
        this.mapSize.height=2400;

        var wScale=this.designSize.width/this.frameSize.width;//适配比例
        var hScale=this.designSize.height/this.frameSize.height
        this.Scale=wScale>hScale?wScale:hScale//适配比例值

        this.percentage = (750/this.Scale)/this.frameSize.height;

        var val=(this.designSize.height/this.Scale)/this.frameSize.height;
        this.CameraY = (1-val)/2+(155/this.Scale)/this.frameSize.height;


   }
    /**
    * 地图的大小
    */
   getMapSize(){
       return this.mapSize;
   }
   /**
    * 屏幕的分辨率。
    */
   getFrameSize(){
        return this.frameSize;
   }
   /**
    * 设计的分辨率。
    */
   getDesignSize(){
        return this.designSize;
   }
   /**
    * 分辨率适配比例
    */
   getScale(){
        return this.Scale;
   }
    /**
    * 地图在屏幕中的占比
    */
   getMapPercentage(){
        this.percentage=Math.round(this.percentage*100)/100;
        return this.percentage;
   }
    /**
    * 地图在屏幕中的Y轴起始点
    */
    getMapCameraY(){
        this.CameraY=Math.round(this.CameraY*100)/100;
        return this.CameraY;
    }

}

