
import { _decorator, Component, Node, Label} from 'cc';
import { PlayerProperty } from'./ui/PlayerProperty'
import { uiManager } from './uiManager'
import { Itemdetail } from './ui/Itemdetail';
import { setting } from './config/setting';
import { LoadConfig } from './loadConfig';
import { infoConfig } from './config/infoconfig';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    
    @property({type:Node})
    private MainNode: Node|null = null;
    @property({type:Node})
    private Info: Node|null = null;
    @property({type:Node})
    private Name: Node|null = null;
    @property({type:Node})
    private Lv: Node|null = null;
    @property({type:Node})
    private Money: Node|null = null;
    @property({type:Node})
    private Identity: Node|null = null;

    private _currDigPath:string=''

    private sysInput:any={};

    private infoFlag=false;
    
    onLoad(){
        this._currDigPath=""
        this.infoFlag=true;
        this.up();
    }
    update(dt:any){

        if(this.infoFlag){
            this.infoFlag=false;
            LoadConfig.loadData("Tools",(data:any)=>{
				setting.Data['tools']=data;
			});
        }
    }
    

    start () {

    }

    showTown(){
        setting.instance.Playermove=true;

        uiManager.instance.hideAllDialog();
    }

    showFigure(){
        setting.instance.Playermove=false;
        uiManager.instance.hideDialog(this._currDigPath);
        uiManager.instance.showDialog('prefab/ui/PlayerProperty'); 
        this._currDigPath='prefab/ui/PlayerProperty';
    }

    showPack(){
        setting.instance.Playermove=false;
        Itemdetail.hide();
        uiManager.instance.hideDialog(this._currDigPath);
        uiManager.instance.showDialog('prefab/ui/Toolsconfig');
        this._currDigPath='prefab/ui/Toolsconfig';
    }

    showSkill(){
        setting.instance.Playermove=false;
    }

    showTask(){
        setting.instance.Playermove=false;
    }


    up(){
        this.setName();
        this.setLv();
        this.setMoney();
        this.setIdentity();
    }

    setName(){
        this.Name.getComponent(Label).string=setting.Data.game['Name'];
    }
    setLv(){
        this.Lv.getComponent(Label).string=infoConfig.LV[setting.Data.game['Lv']]+'境';
    }
    setMoney(){
        this.Money.getComponent(Label).string=setting.Data.game['Money'];
    }
    setIdentity(){
        this.Identity.getComponent(Label).string=infoConfig.IDENTITY[setting.Data.game['Identity']];
    }
}
